/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.common.spi;

import java.util.Arrays;
import jdk.graal.compiler.core.common.spi.ConstantFieldProvider;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.options.OptionKey;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;

public abstract class JavaConstantFieldProvider
implements ConstantFieldProvider {
    private final ResolvedJavaField stringValueField;
    private final ResolvedJavaField stringHashField;

    protected JavaConstantFieldProvider(MetaAccessProvider metaAccess) {
        try {
            ResolvedJavaType stringType = metaAccess.lookupJavaType(String.class);
            this.stringValueField = JavaConstantFieldProvider.findField(stringType, "value");
            this.stringHashField = JavaConstantFieldProvider.findField(stringType, "hash");
        }
        catch (SecurityException e) {
            throw new GraalError(e);
        }
    }

    private static ResolvedJavaField findField(ResolvedJavaType type, String fieldName) {
        Object[] stringFields;
        for (ResolvedJavaField resolvedJavaField : stringFields = type.getInstanceFields(false)) {
            if (!resolvedJavaField.getName().equals(fieldName)) continue;
            return resolvedJavaField;
        }
        throw new GraalError("missing field \"" + fieldName + "\" " + Arrays.toString(stringFields));
    }

    @Override
    public <T> T readConstantField(ResolvedJavaField field, ConstantFieldProvider.ConstantFieldTool<T> tool) {
        JavaConstant value;
        if (this.isStableField(field, tool) && (value = tool.readValue()) != null && this.isStableFieldValueConstant(field, value, tool)) {
            return this.foldStableArray(value, field, tool);
        }
        if (this.isFinalField(field, tool) && (value = tool.readValue()) != null && this.isFinalFieldValueConstant(field, value, tool)) {
            return tool.foldConstant(value);
        }
        return null;
    }

    protected <T> T foldStableArray(JavaConstant value, ResolvedJavaField field, ConstantFieldProvider.ConstantFieldTool<T> tool) {
        return tool.foldStableArray(value, JavaConstantFieldProvider.getArrayDimension(field.getType()), this.isDefaultStableField(field, tool));
    }

    private static int getArrayDimension(JavaType type) {
        int dimensions = 0;
        JavaType componentType = type;
        while ((componentType = componentType.getComponentType()) != null) {
            ++dimensions;
        }
        return dimensions;
    }

    private static boolean isArray(ResolvedJavaField field) {
        JavaType fieldType = field.getType();
        return fieldType instanceof ResolvedJavaType && ((ResolvedJavaType)fieldType).isArray();
    }

    protected boolean isStableFieldValueConstant(ResolvedJavaField field, JavaConstant value, ConstantFieldProvider.ConstantFieldTool<?> tool) {
        return !value.isDefaultForKind();
    }

    protected boolean isFinalFieldValueConstant(ResolvedJavaField field, JavaConstant value, ConstantFieldProvider.ConstantFieldTool<?> tool) {
        return !value.isDefaultForKind() || Options.TrustFinalDefaultFields.getValue(tool.getOptions()) != false;
    }

    protected boolean isStableField(ResolvedJavaField field, ConstantFieldProvider.ConstantFieldTool<?> tool) {
        if (this.isPrimitiveBoxingCacheField(field)) {
            return true;
        }
        if (this.isSyntheticEnumSwitchMap(field)) {
            return true;
        }
        if (this.isWellKnownImplicitStableField(field)) {
            return true;
        }
        return field.equals((Object)this.stringHashField);
    }

    protected boolean isPrimitiveBoxingCacheField(ResolvedJavaField field) {
        ResolvedJavaType type;
        String typeName;
        return JavaConstantFieldProvider.isArray(field) && field.isFinal() && field.getName().equals("cache") && ((typeName = (type = field.getDeclaringClass()).getName()).equals("Ljava/lang/Character$CharacterCache;") || typeName.equals("Ljava/lang/Byte$ByteCache;") || typeName.equals("Ljava/lang/Short$ShortCache;") || typeName.equals("Ljava/lang/Integer$IntegerCache;") || typeName.equals("Ljava/lang/Long$LongCache;"));
    }

    protected boolean isDefaultStableField(ResolvedJavaField field, ConstantFieldProvider.ConstantFieldTool<?> tool) {
        assert (this.isStableField(field, tool));
        return this.isSyntheticEnumSwitchMap(field);
    }

    protected boolean isFinalField(ResolvedJavaField field, ConstantFieldProvider.ConstantFieldTool<?> tool) {
        return field.isFinal();
    }

    protected boolean isSyntheticEnumSwitchMap(ResolvedJavaField field) {
        if (field.isSynthetic() && field.isStatic() && JavaConstantFieldProvider.isArray(field)) {
            String name = field.getName();
            if (field.isFinal() && name.equals("$VALUES") || name.equals("ENUM$VALUES")) {
                return true;
            }
            if (name.startsWith("$SwitchMap$") || name.startsWith("$SWITCH_TABLE$")) {
                return true;
            }
        }
        return false;
    }

    protected boolean isWellKnownImplicitStableField(ResolvedJavaField field) {
        return field.equals((Object)this.stringValueField);
    }

    static class Options {
        public static final OptionKey<Boolean> TrustFinalDefaultFields = new OptionKey<Boolean>(true);

        Options() {
        }
    }
}

