/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.common.type;

import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.serviceprovider.SpeculationReasonGroup;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;

public abstract class AbstractPointerStamp
extends Stamp {
    private final boolean nonNull;
    private final boolean alwaysNull;

    @Override
    public void accept(SpeculationReasonGroup.SpeculationContextObject.Visitor v) {
        v.visitBoolean(this.nonNull);
        v.visitBoolean(this.alwaysNull);
    }

    protected AbstractPointerStamp(boolean nonNull, boolean alwaysNull) {
        this.nonNull = nonNull;
        this.alwaysNull = alwaysNull;
    }

    public boolean nonNull() {
        assert (!this.isEmpty() || this.nonNull);
        return this.nonNull;
    }

    public boolean alwaysNull() {
        return this.alwaysNull;
    }

    protected abstract AbstractPointerStamp copyWith(boolean var1, boolean var2);

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.alwaysNull ? 1231 : 1237);
        result = 31 * result + (this.nonNull ? 1231 : 1237);
        return result;
    }

    protected Stamp defaultPointerJoin(Stamp stamp) {
        boolean joinAlwaysNull;
        assert (this.getClass() == stamp.getClass()) : String.valueOf(this) + " " + String.valueOf(stamp);
        AbstractPointerStamp other = (AbstractPointerStamp)stamp;
        boolean joinNonNull = this.nonNull || other.nonNull;
        boolean bl = joinAlwaysNull = this.alwaysNull || other.alwaysNull;
        if (joinNonNull && joinAlwaysNull) {
            return this.empty();
        }
        return this.copyWith(joinNonNull, joinAlwaysNull);
    }

    @Override
    public Stamp improveWith(Stamp other) {
        return this.join(other);
    }

    @Override
    public Stamp meet(Stamp stamp) {
        AbstractPointerStamp other = (AbstractPointerStamp)stamp;
        boolean meetNonNull = this.nonNull && other.nonNull;
        boolean meetAlwaysNull = this.alwaysNull && other.alwaysNull;
        return this.copyWith(meetNonNull, meetAlwaysNull);
    }

    @Override
    public Stamp unrestricted() {
        return this.copyWith(false, false);
    }

    public static Stamp pointerNonNull(Stamp stamp) {
        AbstractPointerStamp pointer = (AbstractPointerStamp)stamp;
        return pointer.asNonNull();
    }

    public static Stamp pointerMaybeNull(Stamp stamp) {
        AbstractPointerStamp pointer = (AbstractPointerStamp)stamp;
        return pointer.asMaybeNull();
    }

    public static Stamp pointerAlwaysNull(Stamp stamp) {
        AbstractPointerStamp pointer = (AbstractPointerStamp)stamp;
        return pointer.asAlwaysNull();
    }

    public AbstractPointerStamp asNonNull() {
        if (this.isEmpty()) {
            return this;
        }
        return this.copyWith(true, false);
    }

    public AbstractPointerStamp asMaybeNull() {
        if (this.isEmpty()) {
            return this;
        }
        return this.copyWith(false, false);
    }

    public Stamp asAlwaysNull() {
        if (this.isEmpty()) {
            return this;
        }
        return this.copyWith(false, true);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractPointerStamp other = (AbstractPointerStamp)obj;
        return this.alwaysNull == other.alwaysNull && this.nonNull == other.nonNull;
    }

    @Override
    public Constant asConstant() {
        if (this.alwaysNull) {
            return this.nullConstant();
        }
        return super.asConstant();
    }

    public JavaConstant nullConstant() {
        return JavaConstant.NULL_POINTER;
    }

    @Override
    public JavaKind getStackKind() {
        return JavaKind.Illegal;
    }

    public boolean isCompressed() {
        return false;
    }
}

