/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.common.util;

import java.util.Arrays;
import jdk.graal.compiler.core.common.PermanentBailoutException;
import jdk.graal.compiler.core.common.util.EventCounter;
import jdk.graal.compiler.core.common.util.Util;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.TTY;
import jdk.graal.compiler.graph.Graph;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.vm.ci.services.Services;

public final class CompilationAlarm
implements AutoCloseable {
    public static final boolean LOG_PROGRESS_DETECTION = !Services.IS_IN_NATIVE_IMAGE && Boolean.parseBoolean(Services.getSavedProperty((String)("debug." + CompilationAlarm.class.getName() + ".logProgressDetection")));
    private static final ThreadLocal<CompilationAlarm> currentAlarm = new ThreadLocal();
    private static final CompilationAlarm NEVER_EXPIRES = new CompilationAlarm(0.0);
    private final double period;
    private final long expiration;
    public static final int CHECK_BAILOUT_COUNTER = 4096;
    private static final ThreadLocal<StackTraceElement[]> lastStackTraceForThread = new ThreadLocal();
    private static final ThreadLocal<Long> lastUniqueStackTraceForThreadMS = new ThreadLocal();
    private static final ThreadLocal<EventCounter.EventCounterMarker> lastMarkerForThread = new ThreadLocal();
    private static final ThreadLocal<Long> noProgressStartPeriodMS = new ThreadLocal();

    private CompilationAlarm(double period) {
        this.period = period;
        this.expiration = period == 0.0 ? 0L : System.currentTimeMillis() + (long)(period * 1000.0);
    }

    public static CompilationAlarm current() {
        CompilationAlarm alarm = currentAlarm.get();
        return alarm == null ? NEVER_EXPIRES : alarm;
    }

    public double getPeriod() {
        return this.period;
    }

    public boolean hasExpired() {
        return this != NEVER_EXPIRES && System.currentTimeMillis() > this.expiration;
    }

    public void checkExpiration() {
        if (this.hasExpired()) {
            throw new PermanentBailoutException("Compilation exceeded %.3f seconds", this.period);
        }
    }

    @Override
    public void close() {
        if (this != NEVER_EXPIRES) {
            currentAlarm.set(null);
            CompilationAlarm.resetProgressDetection();
        }
    }

    public static CompilationAlarm trackCompilationPeriod(OptionValues options) {
        double period = Options.CompilationExpirationPeriod.getValue(options);
        if (period > 0.0) {
            CompilationAlarm current;
            if (Assertions.assertionsEnabled()) {
                period *= 2.0;
            }
            if (Assertions.detailedAssertionsEnabled(options)) {
                period *= 2.0;
            }
            if ((current = currentAlarm.get()) == null) {
                current = new CompilationAlarm(period);
                currentAlarm.set(current);
                return current;
            }
        }
        return null;
    }

    public static void checkProgress(Graph graph) {
        if (graph == null) {
            return;
        }
        if (graph.eventCounterOverflows(4096)) {
            CompilationAlarm.overflowAction(graph.getOptions(), graph);
        }
    }

    public static boolean checkProgress(OptionValues opt, EventCounter eventCounter) {
        if (opt == null) {
            return false;
        }
        if (eventCounter.eventCounterOverflows(4096)) {
            CompilationAlarm.overflowAction(opt, eventCounter);
            return true;
        }
        return false;
    }

    private static void overflowAction(OptionValues opt, EventCounter counter) {
        if (LOG_PROGRESS_DETECTION) {
            TTY.printf("CompilationAlarm: Progress detection %s; event counter overflowed%n", counter.eventCounterToString());
        }
        CompilationAlarm current = CompilationAlarm.current();
        current.checkExpiration();
        CompilationAlarm.assertProgress(opt, counter);
    }

    private static void assertProgress(OptionValues opt, EventCounter counter) {
        EventCounter.EventCounterMarker lastMarker = lastMarkerForThread.get();
        if (lastMarker != null && lastMarker != counter.getEventCounterMarker()) {
            CompilationAlarm.resetProgressDetection();
            return;
        }
        Object[] lastStackTrace = lastStackTraceForThread.get();
        if (lastStackTrace == null) {
            Long lastUniqueStackTraceTimeStamp = lastUniqueStackTraceForThreadMS.get();
            if (lastUniqueStackTraceTimeStamp == null) {
                CompilationAlarm.assertProgressNoTracking(opt, counter);
                return;
            }
            long delay = noProgressStartPeriodMS.get();
            long now = System.currentTimeMillis();
            long elapsed = now - lastUniqueStackTraceTimeStamp;
            if (elapsed <= delay) {
                if (LOG_PROGRESS_DETECTION) {
                    TTY.printf("CompilationAlarm: Progress detection %s; time diff of %d ms not long enough to take stack trace yet%n", counter.eventCounterToString(), elapsed);
                }
                return;
            }
            if (LOG_PROGRESS_DETECTION) {
                TTY.printf("CompilationAlarm: Progress detection %s; time diff of %d ms long enough to take stack trace%n", counter.eventCounterToString(), elapsed);
            }
        }
        Object[] currentStackTrace = Thread.currentThread().getStackTrace();
        if (lastStackTrace == null || lastStackTrace.length != currentStackTrace.length || !Arrays.equals(lastStackTrace, currentStackTrace)) {
            lastStackTraceForThread.set((StackTraceElement[])currentStackTrace);
            lastUniqueStackTraceForThreadMS.set(System.currentTimeMillis());
            lastMarkerForThread.set(counter.getEventCounterMarker());
        } else {
            CompilationAlarm.assertProgressSlowPath(opt, (StackTraceElement[])lastStackTrace, counter, (StackTraceElement[])currentStackTrace);
        }
    }

    private static void assertProgressNoTracking(OptionValues opt, EventCounter counter) {
        lastUniqueStackTraceForThreadMS.set(System.currentTimeMillis());
        lastMarkerForThread.set(counter.getEventCounterMarker());
        noProgressStartPeriodMS.set((long)(Options.CompilationNoProgressStartTrackingProgressPeriod.getValue(opt) * 1000.0));
        if (LOG_PROGRESS_DETECTION) {
            TTY.printf("CompilationAlarm: Progress detection %s; taking first time stamp, no stack yet%n", counter.eventCounterToString());
        }
    }

    private static void assertProgressSlowPath(OptionValues opt, StackTraceElement[] lastStackTrace, EventCounter counter, StackTraceElement[] currentStackTrace) {
        boolean stuck;
        long stuckThreshold = (long)(Options.CompilationNoProgressPeriod.getValue(opt) * 1000.0);
        if (stuckThreshold == 0L) {
            return;
        }
        assert (Arrays.equals(lastStackTrace, currentStackTrace)) : "Must only enter this branch if no progress was made";
        long lastUniqueStackTraceTime = lastUniqueStackTraceForThreadMS.get();
        long now = System.currentTimeMillis();
        long elapsed = now - lastUniqueStackTraceTime;
        boolean bl = stuck = elapsed > stuckThreshold;
        if (LOG_PROGRESS_DETECTION) {
            TTY.printf("CompilationAlarm: Progress detection %s; no progress for %d ms; stuck? %s; stuck threshold %d ms%n", counter, elapsed, stuck, stuckThreshold);
        }
        if (stuck) {
            throw new PermanentBailoutException("Observed identical stack traces for %d ms, indicating a stuck compilation, counter = %s, stack is:%n%s", elapsed, counter, Util.toString(lastStackTrace));
        }
    }

    public static void resetProgressDetection() {
        lastStackTraceForThread.set(null);
        lastUniqueStackTraceForThreadMS.set(null);
        lastMarkerForThread.set(null);
        noProgressStartPeriodMS.set(null);
    }

    public static class Options {
        public static final OptionKey<Double> CompilationExpirationPeriod = new OptionKey<Double>(300.0);
        public static final OptionKey<Double> CompilationNoProgressPeriod = new OptionKey<Double>(30.0);
        public static final OptionKey<Double> CompilationNoProgressStartTrackingProgressPeriod = new OptionKey<Double>(10.0);
    }
}

