/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.common.util;

import java.util.ArrayList;
import java.util.function.Consumer;
import jdk.graal.compiler.debug.Assertions;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;

public class FrequencyEncoder<T> {
    protected final EconomicMap<T, Entry<T>> map;
    protected boolean containsNull;
    protected boolean encoded;

    public static <T> FrequencyEncoder<T> createIdentityEncoder() {
        return new FrequencyEncoder<T>(EconomicMap.create((Equivalence)Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE));
    }

    public static <T> FrequencyEncoder<T> createEqualityEncoder() {
        return new FrequencyEncoder<T>(EconomicMap.create((Equivalence)Equivalence.DEFAULT));
    }

    public static <T> FrequencyEncoder<T> createVerifyingEqualityEncoder(Consumer<T> verifier) {
        return new VerifyingFrequencyEncoder<T>(EconomicMap.create((Equivalence)Equivalence.DEFAULT), verifier);
    }

    protected FrequencyEncoder(EconomicMap<T, Entry<T>> map) {
        this.map = map;
    }

    public boolean addObject(T object) {
        if (object == null) {
            boolean added = !this.containsNull;
            this.containsNull = true;
            return added;
        }
        Entry<T> entry = (Entry<T>)this.map.get(object);
        if (entry == null) {
            entry = new Entry<T>(object);
            this.map.put(object, entry);
        }
        ++entry.frequency;
        return entry.frequency == 1;
    }

    public int getIndex(T object) {
        assert (this.encoded);
        if (object == null) {
            assert (this.containsNull);
            return 0;
        }
        Entry entry = (Entry)this.map.get(object);
        assert (entry != null && entry.index >= 0) : Assertions.errorMessageContext("entry", entry);
        return entry.index;
    }

    public int findIndex(T object) {
        assert (this.encoded);
        if (object == null) {
            return this.containsNull ? 0 : -1;
        }
        Entry entry = (Entry)this.map.get(object);
        return entry != null ? entry.index : -1;
    }

    public int getLength() {
        return this.map.size() + (this.containsNull ? 1 : 0);
    }

    public T[] encodeAll(T[] allObjects) {
        assert (allObjects.length == this.getLength()) : Assertions.errorMessage(allObjects, this.getLength());
        ArrayList<Entry> sortedEntries = new ArrayList<Entry>(allObjects.length);
        for (Entry value : this.map.getValues()) {
            sortedEntries.add(value);
        }
        sortedEntries.sort((e1, e2) -> -Integer.compare(e1.frequency, e2.frequency));
        int offset = 0;
        if (this.containsNull) {
            allObjects[0] = null;
            offset = 1;
        }
        for (int i = 0; i < sortedEntries.size(); ++i) {
            int index;
            Entry entry = (Entry)sortedEntries.get(i);
            entry.index = index = i + offset;
            allObjects[index] = entry.object;
            assert (entry.object != null);
        }
        this.encoded = true;
        return allObjects;
    }

    static class VerifyingFrequencyEncoder<T>
    extends FrequencyEncoder<T> {
        private final Consumer<T> verifier;

        VerifyingFrequencyEncoder(EconomicMap<T, Entry<T>> map, Consumer<T> verifier) {
            super(map);
            this.verifier = verifier;
        }

        @Override
        public boolean addObject(T object) {
            this.verifier.accept(object);
            return super.addObject(object);
        }
    }

    static class Entry<T> {
        protected final T object;
        protected int frequency;
        protected int index;

        protected Entry(T object) {
            this.object = object;
            this.index = -1;
        }
    }
}

