/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.phases;

import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.core.phases.BaseTier;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.PlaceholderPhase;
import jdk.graal.compiler.phases.common.AddressLoweringPhase;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.common.DeadCodeEliminationPhase;
import jdk.graal.compiler.phases.common.ExpandLogicPhase;
import jdk.graal.compiler.phases.common.FinalCanonicalizerPhase;
import jdk.graal.compiler.phases.common.FixReadsPhase;
import jdk.graal.compiler.phases.common.LowTierLoweringPhase;
import jdk.graal.compiler.phases.common.OptimizeExtendsPhase;
import jdk.graal.compiler.phases.common.OptimizeOffsetAddressPhase;
import jdk.graal.compiler.phases.common.ProfileCompiledMethodsPhase;
import jdk.graal.compiler.phases.common.PropagateDeoptimizeProbabilityPhase;
import jdk.graal.compiler.phases.common.RemoveOpaqueValuePhase;
import jdk.graal.compiler.phases.schedule.SchedulePhase;
import jdk.graal.compiler.phases.tiers.LowTierContext;

public class LowTier
extends BaseTier<LowTierContext> {
    private final CanonicalizerPhase canonicalizerWithoutGVN;
    private final CanonicalizerPhase canonicalizerWithGVN = CanonicalizerPhase.create();

    public LowTier(OptionValues options) {
        this.canonicalizerWithoutGVN = this.canonicalizerWithGVN.copyWithoutGVN();
        if (Options.ProfileCompiledMethods.getValue(options).booleanValue()) {
            this.appendPhase(new ProfileCompiledMethodsPhase());
        }
        this.appendPhase(new LowTierLoweringPhase(this.canonicalizerWithGVN));
        this.appendPhase(new ExpandLogicPhase(this.canonicalizerWithGVN));
        this.appendPhase(new OptimizeOffsetAddressPhase(this.canonicalizerWithGVN));
        this.appendPhase(new FixReadsPhase(true, new SchedulePhase(GraalOptions.StressTestEarlyReads.getValue(options) != false ? SchedulePhase.SchedulingStrategy.EARLIEST : SchedulePhase.SchedulingStrategy.LATEST_OUT_OF_LOOPS_IMPLICIT_NULL_CHECKS)));
        this.appendPhase(this.canonicalizerWithoutGVN);
        this.appendPhase(new PlaceholderPhase(AddressLoweringPhase.class));
        this.appendPhase(FinalCanonicalizerPhase.createFromCanonicalizer(this.canonicalizerWithoutGVN));
        this.appendPhase(new DeadCodeEliminationPhase(DeadCodeEliminationPhase.Optionality.Required));
        this.appendPhase(new PropagateDeoptimizeProbabilityPhase());
        this.appendPhase(new OptimizeExtendsPhase());
        this.appendPhase(new RemoveOpaqueValuePhase());
        this.appendPhase(new SchedulePhase(SchedulePhase.SchedulingStrategy.LATEST_OUT_OF_LOOPS));
    }

    public final CanonicalizerPhase getCanonicalizerWithoutGVN() {
        return this.canonicalizerWithoutGVN;
    }

    public final CanonicalizerPhase getCanonicalizer() {
        return this.canonicalizerWithGVN;
    }

    static class Options {
        public static final OptionKey<Boolean> ProfileCompiledMethods = new OptionKey<Boolean>(false);

        Options() {
        }
    }
}

