/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.phases.fuzzing;

import java.util.stream.Collectors;
import jdk.graal.compiler.core.phases.fuzzing.AbstractCompilationPlan;
import jdk.graal.compiler.core.phases.fuzzing.FullFuzzedTierPlan;
import jdk.graal.compiler.core.phases.fuzzing.MinimalFuzzedCompilationPlan;
import jdk.graal.compiler.core.phases.fuzzing.MinimalFuzzedTierPlan;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.phases.tiers.HighTierContext;
import jdk.graal.compiler.phases.tiers.LowTierContext;
import jdk.graal.compiler.phases.tiers.MidTierContext;

public final class FullFuzzedCompilationPlan
extends MinimalFuzzedCompilationPlan {
    private static final int DEFAULT_PHASE_SKIP_ODDS = 10;
    private final MinimalFuzzedCompilationPlan minimalFuzzedCompilationPlan;

    private FullFuzzedCompilationPlan(MinimalFuzzedCompilationPlan minimalFuzzedCompilationPlan, FullFuzzedTierPlan<HighTierContext> highTier, FullFuzzedTierPlan<MidTierContext> midTier, FullFuzzedTierPlan<LowTierContext> lowTier, GraphState graphState, GraphState.MandatoryStages mandatoryStages, long randomSeed) {
        super(highTier, midTier, lowTier, graphState, mandatoryStages, randomSeed);
        this.minimalFuzzedCompilationPlan = minimalFuzzedCompilationPlan;
    }

    @Override
    public String toString() {
        String phasePlan = super.toString().lines().skip(1L).collect(Collectors.joining(System.lineSeparator()));
        return String.format("%s%nThe %sfull fuzzed compilation plan is:%n%s", this.minimalFuzzedCompilationPlan, AbstractCompilationPlan.PrintingUtils.printFailing(phasePlan), phasePlan);
    }

    public static FullFuzzedCompilationPlan createFullFuzzedCompilationPlan(MinimalFuzzedCompilationPlan minimalFuzzedCompilationPlan, GraphState graphState) {
        return FullFuzzedCompilationPlan.createFullFuzzedCompilationPlan(minimalFuzzedCompilationPlan, graphState, 10, 10, 10);
    }

    public static FullFuzzedCompilationPlan createFullFuzzedCompilationPlan(MinimalFuzzedCompilationPlan minimalFuzzedCompilationPlan, GraphState graphState, int phaseSkipOddsHighTier, int phaseSkipOddsMidTier, int phaseSkipOddsLowTier) {
        GraphState graphStateCopy = graphState.copy();
        FullFuzzedTierPlan<HighTierContext> highTier = FullFuzzedTierPlan.create((MinimalFuzzedTierPlan)minimalFuzzedCompilationPlan.getHighTier(), graphStateCopy, minimalFuzzedCompilationPlan.getRandomSeed(), phaseSkipOddsHighTier, "High tier");
        highTier.updateGraphState(graphStateCopy);
        FullFuzzedTierPlan<MidTierContext> midTier = FullFuzzedTierPlan.create((MinimalFuzzedTierPlan)minimalFuzzedCompilationPlan.getMidTier(), graphStateCopy, minimalFuzzedCompilationPlan.getRandomSeed(), phaseSkipOddsMidTier, "Mid tier");
        midTier.updateGraphState(graphStateCopy);
        FullFuzzedTierPlan<LowTierContext> lowTier = FullFuzzedTierPlan.create((MinimalFuzzedTierPlan)minimalFuzzedCompilationPlan.getLowTier(), graphStateCopy, minimalFuzzedCompilationPlan.getRandomSeed(), phaseSkipOddsLowTier, "Low tier");
        return new FullFuzzedCompilationPlan(minimalFuzzedCompilationPlan.copy(), highTier, midTier, lowTier, graphState, minimalFuzzedCompilationPlan.getMandatoryStages(), minimalFuzzedCompilationPlan.getRandomSeed());
    }

    @Override
    public void saveCompilationPlan(String dumpPath) {
        this.minimalFuzzedCompilationPlan.saveCompilationPlan(dumpPath + "_minimal");
        super.saveCompilationPlan(dumpPath);
    }
}

