/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.phases.fuzzing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import jdk.graal.compiler.core.phases.fuzzing.MinimalFuzzedTierPlan;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.PhaseSuite;

public final class FullFuzzedTierPlan<C>
extends MinimalFuzzedTierPlan<C> {
    private final MinimalFuzzedTierPlan<C> minimalFuzzedTierPlan;
    private final int phaseSkipOdds;

    private FullFuzzedTierPlan(MinimalFuzzedTierPlan<C> minimalTierPlan, GraphState graphState, long randomSeed, int phaseSkipOdds, String tierName) {
        this(minimalTierPlan.getSingleApplyPhases(), minimalTierPlan.getMultiApplyPhases(), minimalTierPlan.getIgnoredPhases(), new PhaseSuite(), minimalTierPlan, randomSeed, phaseSkipOdds, tierName);
        this.computeFullFuzzedTierPlan(graphState);
    }

    private FullFuzzedTierPlan(List<BasePhase<? super C>> singleApplyPhases, List<BasePhase<? super C>> multiApplyPhases, Set<BasePhase<? super C>> unusedPhases, PhaseSuite<C> phaseSuite, MinimalFuzzedTierPlan<C> minimalFuzzedTierPlan, long randomSeed, int phaseSkipOdds, String tierName) {
        super(singleApplyPhases, multiApplyPhases, unusedPhases, phaseSuite, randomSeed, tierName);
        this.minimalFuzzedTierPlan = minimalFuzzedTierPlan;
        this.phaseSkipOdds = phaseSkipOdds;
    }

    protected static <C> FullFuzzedTierPlan<C> create(MinimalFuzzedTierPlan<C> minimalTierPlan, GraphState graphState, long randomSeed, int phaseSkipOdds, String tierName) {
        return new FullFuzzedTierPlan<C>(minimalTierPlan, graphState, randomSeed, phaseSkipOdds, tierName);
    }

    private void computeFullFuzzedTierPlan(GraphState graphState) {
        Random random = new Random(this.getRandomSeed());
        this.setPhaseSuite(this.minimalFuzzedTierPlan.getPhaseSuite().copy());
        this.insertPhasesThatMustApply(graphState);
        int suiteSize = this.getPhaseSuite().getPhases().size();
        ArrayList<Integer> indices = new ArrayList<Integer>(suiteSize);
        for (int index = 0; index < suiteSize; ++index) {
            indices.add(index);
        }
        Collections.shuffle(indices, random);
        ArrayList availablePhases = new ArrayList(this.getSingleApplyPhases());
        Collections.shuffle(availablePhases, random);
        block1: for (BasePhase basePhase : availablePhases) {
            for (Integer positionInSuite : indices) {
                if (random.nextInt(this.phaseSkipOdds) > 0 || !this.insertPhaseAtIndex(basePhase, positionInSuite, graphState)) continue;
                indices.add(++suiteSize);
                Collections.shuffle(indices, random);
                continue block1;
            }
        }
        availablePhases = new ArrayList(this.getMultiApplyPhases());
        Collections.shuffle(availablePhases, random);
        for (BasePhase basePhase : availablePhases) {
            for (int positionInSuite = 0; positionInSuite <= this.getPhaseSuite().getPhases().size(); ++positionInSuite) {
                if (random.nextInt(this.phaseSkipOdds) > 0) continue;
                this.insertPhaseAtIndex(basePhase, positionInSuite, graphState);
            }
        }
        this.insertPhasesThatMustApply(graphState);
    }

    public int getPhaseSkipOdds() {
        return this.phaseSkipOdds;
    }

    @Override
    public String toString() {
        return String.format("%s%n%s%nProbability of inserting a phase: 1/%s (-Dtest.graal.skip.phase.insertion.odds.%s=%s)%n", super.toString(), this.ignoredPhasesToString(), this.phaseSkipOdds, String.join((CharSequence)".", this.getTierName().toLowerCase(Locale.ROOT).split(" ")), this.phaseSkipOdds);
    }

    @Override
    public FullFuzzedTierPlan<C> copy() {
        return new FullFuzzedTierPlan<C>(new ArrayList<BasePhase<? super C>>(this.getSingleApplyPhases()), new ArrayList<BasePhase<? super C>>(this.getMultiApplyPhases()), new HashSet<BasePhase<? super C>>(this.getIgnoredPhases()), this.getPhaseSuite().copy(), this.minimalFuzzedTierPlan.copy(), this.getRandomSeed(), this.phaseSkipOdds, this.getTierName());
    }
}

