/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.phases.fuzzing;

import jdk.graal.compiler.core.phases.fuzzing.FullFuzzedCompilationPlan;
import jdk.graal.compiler.core.phases.fuzzing.MinimalFuzzedCompilationPlan;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.tiers.Suites;

public final class FuzzedSuites
extends Suites {
    private final FullFuzzedCompilationPlan fullFuzzedCompilationPlan;

    private FuzzedSuites(FullFuzzedCompilationPlan fullFuzzedCompilationPlan) {
        super(fullFuzzedCompilationPlan.getSuites().getHighTier(), fullFuzzedCompilationPlan.getSuites().getMidTier(), fullFuzzedCompilationPlan.getSuites().getLowTier());
        this.fullFuzzedCompilationPlan = fullFuzzedCompilationPlan;
    }

    public static FuzzedSuites createFuzzedSuites(Suites originalSuites, GraphState graphState, GraphState.MandatoryStages mandatoryStages, long seed) {
        MinimalFuzzedCompilationPlan minimalFuzzedCompilationPlan = MinimalFuzzedCompilationPlan.createMinimalFuzzedCompilationPlan(originalSuites, graphState, mandatoryStages, seed);
        FullFuzzedCompilationPlan fullFuzzedCompilationPlan = FullFuzzedCompilationPlan.createFullFuzzedCompilationPlan(minimalFuzzedCompilationPlan, graphState);
        return new FuzzedSuites(fullFuzzedCompilationPlan);
    }

    public void saveFuzzedSuites(String dumpPath) {
        this.fullFuzzedCompilationPlan.saveCompilationPlan(dumpPath);
    }

    public static OptionValues fuzzingOptions(OptionValues baseOptions) {
        return new OptionValues(baseOptions, CanonicalizerPhase.Options.CanonicalizerVerifyGVNAllowed, false, new Object[0]);
    }

    public String toString() {
        return this.fullFuzzedCompilationPlan.toString();
    }
}

