/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.core.target;

import java.util.ArrayList;
import jdk.graal.compiler.code.CompilationResult;
import jdk.graal.compiler.core.common.CompilationIdentifier;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.alloc.DefaultCodeEmissionOrder;
import jdk.graal.compiler.core.common.alloc.RegisterAllocationConfig;
import jdk.graal.compiler.core.common.cfg.BasicBlock;
import jdk.graal.compiler.core.common.cfg.CodeEmissionOrder;
import jdk.graal.compiler.core.common.spi.ForeignCallSignature;
import jdk.graal.compiler.core.common.spi.ForeignCallsProvider;
import jdk.graal.compiler.core.gen.LIRCompilerBackend;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.lir.asm.CompilationResultBuilderFactory;
import jdk.graal.compiler.lir.asm.EntryPointDecorator;
import jdk.graal.compiler.lir.phases.LIRSuites;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.tiers.SuitesProvider;
import jdk.graal.compiler.phases.tiers.TargetProvider;
import jdk.graal.compiler.phases.util.Providers;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.CompilationRequest;
import jdk.vm.ci.code.CompiledCode;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.ValueKindFactory;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;

public abstract class Backend
implements TargetProvider,
ValueKindFactory<LIRKind> {
    private final Providers providers;
    private final ArrayList<CodeInstallationTaskFactory> codeInstallationTaskFactories;
    public static final ForeignCallSignature ARITHMETIC_FREM = new ForeignCallSignature("arithmeticFrem", Float.TYPE, Float.TYPE, Float.TYPE);
    public static final ForeignCallSignature ARITHMETIC_DREM = new ForeignCallSignature("arithmeticDrem", Double.TYPE, Double.TYPE, Double.TYPE);

    protected Backend(Providers providers) {
        this.providers = providers;
        this.codeInstallationTaskFactories = new ArrayList();
    }

    public synchronized void addCodeInstallationTask(CodeInstallationTaskFactory factory) {
        this.codeInstallationTaskFactories.add(factory);
    }

    public Providers getProviders() {
        return this.providers;
    }

    public CodeCacheProvider getCodeCache() {
        return this.providers.getCodeCache();
    }

    public MetaAccessProvider getMetaAccess() {
        return this.providers.getMetaAccess();
    }

    public ConstantReflectionProvider getConstantReflection() {
        return this.providers.getConstantReflection();
    }

    public ForeignCallsProvider getForeignCalls() {
        return this.providers.getForeignCalls();
    }

    public abstract SuitesProvider getSuites();

    @Override
    public TargetDescription getTarget() {
        return this.providers.getCodeCache().getTarget();
    }

    public LIRKind getValueKind(JavaKind javaKind) {
        return LIRKind.fromJavaKind(this.getTarget().arch, javaKind);
    }

    public abstract RegisterAllocationConfig newRegisterAllocationConfig(RegisterConfig var1, String[] var2, Object var3);

    public <T extends BasicBlock<T>> CodeEmissionOrder<T> newBlockOrder(int originalBlockCount, T startBlock) {
        return new DefaultCodeEmissionOrder<T>(originalBlockCount, startBlock);
    }

    protected abstract CompiledCode createCompiledCode(ResolvedJavaMethod var1, CompilationRequest var2, CompilationResult var3, boolean var4, OptionValues var5);

    public InstalledCode createInstalledCode(DebugContext debug, ResolvedJavaMethod method, CompilationResult compilationResult, InstalledCode predefinedInstalledCode, boolean isDefault) {
        return this.createInstalledCode(debug, method, null, compilationResult, predefinedInstalledCode, isDefault, null);
    }

    public InstalledCode createInstalledCode(DebugContext debug, ResolvedJavaMethod method, CompilationRequest compilationRequest, CompilationResult compilationResult, InstalledCode predefinedInstalledCode, boolean isDefault) {
        return this.createInstalledCode(debug, method, compilationRequest, compilationResult, predefinedInstalledCode, isDefault, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public InstalledCode createInstalledCode(DebugContext debug, ResolvedJavaMethod method, CompilationRequest compilationRequest, CompilationResult compilationResult, InstalledCode predefinedInstalledCode, boolean isDefault, Object[] context) {
        CodeInstallationTask[] tasks;
        Object[] objectArray;
        if (context != null) {
            objectArray = context;
        } else {
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = this.getProviders().getCodeCache();
            objectArray2[1] = method;
            objectArray = objectArray2;
            objectArray2[2] = compilationResult;
        }
        Object[] debugContext = objectArray;
        Backend backend = this;
        synchronized (backend) {
            tasks = new CodeInstallationTask[this.codeInstallationTaskFactories.size()];
            for (int i = 0; i < this.codeInstallationTaskFactories.size(); ++i) {
                tasks[i] = this.codeInstallationTaskFactories.get(i).create();
            }
        }
        try (DebugContext.Scope s2 = debug.scope((Object)"CodeInstall", debugContext);){
            DebugContext.Activation a = debug.activate();
            try {
                InstalledCode installedCode;
                try {
                    Backend.preCodeInstallationTasks(tasks, compilationResult);
                    CompiledCode compiledCode = this.createCompiledCode(method, compilationRequest, compilationResult, isDefault, debug.getOptions());
                    installedCode = this.getProviders().getCodeCache().installCode(method, compiledCode, predefinedInstalledCode, compilationResult.getSpeculationLog(), isDefault);
                    assert (predefinedInstalledCode == null || installedCode == predefinedInstalledCode) : Assertions.errorMessage(predefinedInstalledCode, installedCode);
                }
                catch (Throwable t) {
                    Backend.failCodeInstallationTasks(tasks, t);
                    throw t;
                }
                Backend.postCodeInstallationTasks(tasks, compilationResult, installedCode);
                InstalledCode installedCode2 = installedCode;
                if (a != null) {
                    a.close();
                }
                return installedCode2;
            }
            catch (Throwable throwable) {
                if (a != null) {
                    try {
                        a.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
    }

    private static void failCodeInstallationTasks(CodeInstallationTask[] tasks, Throwable t) {
        for (CodeInstallationTask task : tasks) {
            task.installFailed(t);
        }
    }

    private static void preCodeInstallationTasks(CodeInstallationTask[] tasks, CompilationResult compilationResult) {
        for (CodeInstallationTask task : tasks) {
            task.preProcess(compilationResult);
        }
    }

    private static void postCodeInstallationTasks(CodeInstallationTask[] tasks, CompilationResult compilationResult, InstalledCode installedCode) {
        try {
            for (CodeInstallationTask task : tasks) {
                task.postProcess(compilationResult, installedCode);
            }
        }
        catch (Throwable t) {
            installedCode.invalidate();
            throw t;
        }
    }

    public InstalledCode addInstalledCode(DebugContext debug, ResolvedJavaMethod method, CompilationRequest compilationRequest, CompilationResult compilationResult) {
        return this.createInstalledCode(debug, method, compilationRequest, compilationResult, null, false);
    }

    public InstalledCode createDefaultInstalledCode(DebugContext debug, ResolvedJavaMethod method, CompilationResult compilationResult) {
        return this.createInstalledCode(debug, method, compilationResult, null, true);
    }

    public CompilationIdentifier getCompilationIdentifier(ResolvedJavaMethod resolvedJavaMethod) {
        return CompilationIdentifier.INVALID_COMPILATION_ID;
    }

    public void emitBackEnd(StructuredGraph graph, Object stub, ResolvedJavaMethod installedCodeOwner, CompilationResult compilationResult, CompilationResultBuilderFactory factory, EntryPointDecorator entryPointDecorator, RegisterConfig config, LIRSuites lirSuites) {
        LIRCompilerBackend.emitBackEnd(graph, stub, installedCodeOwner, this, compilationResult, factory, entryPointDecorator, config, lirSuites);
    }

    public static abstract class CodeInstallationTask {
        public void preProcess(CompilationResult compilationResult) {
        }

        public void postProcess(CompilationResult compilationResult, InstalledCode installedCode) {
        }

        public void installFailed(Throwable cause) {
        }
    }

    public static abstract class CodeInstallationTaskFactory {
        public abstract CodeInstallationTask create();
    }
}

