/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.debug;

import jdk.graal.compiler.debug.AccumulatedKey;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.debug.DebugContext;

public abstract class CloseableCounter
implements DebugCloseable {
    protected final DebugContext debug;
    protected final CloseableCounter parent;
    protected final AccumulatedKey counter;
    protected final long start;
    protected long nestedAmountToSubtract;

    CloseableCounter(DebugContext debug, CloseableCounter parent, AccumulatedKey counter) {
        this.debug = debug;
        this.parent = parent;
        this.start = this.getCounterValue();
        this.counter = counter;
    }

    @Override
    public DebugContext getDebug() {
        return this.debug;
    }

    protected void interceptDifferenceAccm(long difference) {
    }

    protected void interceptDifferenceFlat(long difference) {
    }

    @Override
    public void close() {
        long end = this.getCounterValue();
        long difference = end - this.start;
        if (this.parent != null && !this.counter.getName().equals(this.parent.counter.getName())) {
            this.parent.nestedAmountToSubtract += difference;
            CloseableCounter ancestor = this.parent.parent;
            while (ancestor != null) {
                if (ancestor.counter.getName().equals(this.counter.getName())) {
                    ancestor.nestedAmountToSubtract -= difference;
                    break;
                }
                ancestor = ancestor.parent;
            }
        }
        long flatAmount = difference - this.nestedAmountToSubtract;
        this.counter.addToCurrentValue(this.debug, difference);
        this.counter.flat.addToCurrentValue(this.debug, flatAmount);
        this.interceptDifferenceAccm(difference);
        this.interceptDifferenceFlat(flatAmount);
    }

    abstract long getCounterValue();
}

