/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.debug;

import jdk.graal.compiler.debug.AbstractKey;
import jdk.graal.compiler.debug.AccumulatedKey;
import jdk.graal.compiler.debug.CloseableCounter;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.MemUseTrackerKey;
import jdk.graal.compiler.debug.MetricKey;
import org.graalvm.collections.Pair;

class MemUseTrackerKeyImpl
extends AccumulatedKey
implements MemUseTrackerKey {
    MemUseTrackerKeyImpl(String format, Object arg1, Object arg2) {
        super(new FlatMemUseTracker(format, arg1, arg2), format, arg1, arg2);
    }

    @Override
    public DebugCloseable start(DebugContext debug) {
        if (debug.isMemUseTrackerEnabled(this)) {
            MemUseCloseableCounterImpl result = new MemUseCloseableCounterImpl(this, debug);
            debug.currentMemUseTracker = result;
            return result;
        }
        return DebugCloseable.VOID_CLOSEABLE;
    }

    public static String valueToString(long value) {
        return String.format("%d bytes", value);
    }

    @Override
    public String toHumanReadableFormat(long value) {
        return MemUseTrackerKeyImpl.valueToString(value);
    }

    @Override
    public Pair<String, String> toCSVFormat(long value) {
        return Pair.create((Object)String.valueOf(value), (Object)"bytes");
    }

    @Override
    public MemUseTrackerKey doc(String doc) {
        this.setDoc(doc);
        return this;
    }

    static final class FlatMemUseTracker
    extends AbstractKey
    implements MetricKey {
        FlatMemUseTracker(String nameFormat, Object nameArg1, Object nameArg2) {
            super(nameFormat, nameArg1, nameArg2);
        }

        @Override
        protected String createName(String format, Object arg1, Object arg2) {
            return super.createName(format, arg1, arg2) + "_Flat";
        }

        @Override
        public MetricKey doc(String doc) {
            throw new IllegalArgumentException("Cannot set documentation for derived key " + this.getName());
        }

        @Override
        public String getDocName() {
            return null;
        }

        @Override
        public String toHumanReadableFormat(long value) {
            return MemUseTrackerKeyImpl.valueToString(value);
        }

        @Override
        public Pair<String, String> toCSVFormat(long value) {
            return Pair.create((Object)String.valueOf(value), (Object)"bytes");
        }
    }

    static final class MemUseCloseableCounterImpl
    extends CloseableCounter
    implements DebugCloseable {
        private final DebugContext debug;

        MemUseCloseableCounterImpl(AccumulatedKey counter, DebugContext debug) {
            super(debug, debug.currentMemUseTracker, counter);
            this.debug = debug;
        }

        @Override
        long getCounterValue() {
            return MemUseTrackerKey.getCurrentThreadAllocatedBytes();
        }

        @Override
        public void close() {
            super.close();
            this.debug.currentMemUseTracker = this.parent;
        }
    }
}

