/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.debug;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.Signature;

public final class MethodFilter {
    private final ArrayList<BaseFilter> positiveFilters;
    private final ArrayList<BaseFilter> negativeFilters;
    private static MethodFilter matchNothingInstance = null;
    private static MethodFilter matchAllInstance = null;

    private MethodFilter(ArrayList<BaseFilter> positiveFilters, ArrayList<BaseFilter> negativeFilters) {
        this.positiveFilters = positiveFilters;
        this.negativeFilters = negativeFilters;
    }

    public static MethodFilter parse(String commaSeparatedPatterns) {
        String[] filters = commaSeparatedPatterns.split(",");
        ArrayList<BaseFilter> positiveFilters = new ArrayList<BaseFilter>();
        ArrayList<BaseFilter> negativeFilters = new ArrayList<BaseFilter>();
        for (int i = 0; i < filters.length; ++i) {
            String pattern = filters[i].trim();
            boolean positive = true;
            if (pattern.startsWith("~")) {
                positive = false;
                pattern = pattern.substring(1);
            }
            BaseFilter filter = new BaseFilter(pattern);
            if (positive) {
                positiveFilters.add(filter);
                continue;
            }
            negativeFilters.add(filter);
        }
        return new MethodFilter(positiveFilters, negativeFilters);
    }

    public static MethodFilter matchNothing() {
        if (matchNothingInstance == null) {
            matchNothingInstance = new MethodFilter(new ArrayList<BaseFilter>(), new ArrayList<BaseFilter>());
        }
        return matchNothingInstance;
    }

    public static MethodFilter matchAll() {
        if (matchAllInstance == null) {
            ArrayList<BaseFilter> matchAllFilter = new ArrayList<BaseFilter>();
            matchAllFilter.add(new BaseFilter("*"));
            matchAllInstance = new MethodFilter(matchAllFilter, new ArrayList<BaseFilter>());
        }
        return matchAllInstance;
    }

    public boolean matchesNothing() {
        return this.positiveFilters.isEmpty() && this.negativeFilters.isEmpty();
    }

    public String toString() {
        String positive = this.positiveFilters.stream().map(BaseFilter::toString).collect(Collectors.joining(", "));
        String negative = this.negativeFilters.stream().map(filter -> filter.toString(false)).collect(Collectors.joining(", "));
        if (this.positiveFilters.isEmpty()) {
            return negative;
        }
        if (this.negativeFilters.isEmpty()) {
            return positive;
        }
        return positive + ", " + negative;
    }

    public boolean matches(JavaMethod method) {
        return this.matches((BaseFilter baseFilter) -> baseFilter.matches(method));
    }

    public boolean matches(String javaClassName, String name, Signature sig) {
        return this.matches((BaseFilter baseFilter) -> baseFilter.matches(javaClassName, name, sig));
    }

    public boolean matchesWithArgs(String declaringClassName, String name, List<Type> argTypes) {
        return this.matches((BaseFilter baseFilter) -> baseFilter.matchesWithArgs(declaringClassName, name, argTypes));
    }

    public boolean matchesClassName(String className) {
        return this.matches((BaseFilter baseFilter) -> baseFilter.matchesClassName(className));
    }

    private boolean matches(Predicate<BaseFilter> predicate) {
        for (BaseFilter negative : this.negativeFilters) {
            if (!predicate.test(negative)) continue;
            return false;
        }
        if (!this.negativeFilters.isEmpty() && this.positiveFilters.isEmpty()) {
            return true;
        }
        for (BaseFilter positive : this.positiveFilters) {
            if (!predicate.test(positive)) continue;
            return true;
        }
        return false;
    }

    public static String createGlobString(String pattern) {
        return Pattern.quote(pattern).replace("?", "\\E.\\Q").replace("*", "\\E.*\\Q");
    }

    private static Pattern createClassGlobPattern(String pattern) {
        if (pattern.length() == 0) {
            return null;
        }
        if (pattern.contains(".")) {
            return Pattern.compile(MethodFilter.createGlobString(pattern));
        }
        return Pattern.compile("([^\\.\\$]*[\\.\\$])*" + MethodFilter.createGlobString(pattern));
    }

    private static final class BaseFilter {
        private final Pattern clazz;
        private final Pattern methodName;
        private final Pattern[] signature;

        private BaseFilter(String sourcePattern) {
            String pattern = sourcePattern.trim();
            int pos = pattern.indexOf(40);
            if (pos != -1) {
                if (pattern.charAt(pattern.length() - 1) != ')') {
                    throw new IllegalArgumentException("missing ')' at end of method filter pattern: " + pattern);
                }
                String[] signatureClasses = pattern.substring(pos + 1, pattern.length() - 1).split(";", -1);
                this.signature = new Pattern[signatureClasses.length];
                for (int i = 0; i < signatureClasses.length; ++i) {
                    this.signature[i] = MethodFilter.createClassGlobPattern(signatureClasses[i].trim());
                }
                pattern = pattern.substring(0, pos);
            } else {
                this.signature = null;
            }
            pos = pattern.lastIndexOf(46);
            if (pos != -1) {
                this.clazz = MethodFilter.createClassGlobPattern(pattern.substring(0, pos));
                this.methodName = Pattern.compile(MethodFilter.createGlobString(pattern.substring(pos + 1)));
            } else {
                this.clazz = null;
                this.methodName = Pattern.compile(MethodFilter.createGlobString(pattern));
            }
        }

        private boolean matchesClassName(String className) {
            return this.clazz == null || this.clazz.matcher(className).matches();
        }

        private boolean matches(JavaMethod o) {
            if (this.methodName != null && !this.methodName.matcher(o.getName()).matches()) {
                return false;
            }
            if (this.clazz != null && !this.clazz.matcher(o.getDeclaringClass().toJavaName()).matches()) {
                return false;
            }
            return this.matchesSignature(o.getSignature());
        }

        private boolean matchesSignature(Signature sig) {
            if (this.signature == null) {
                return true;
            }
            if (sig.getParameterCount(false) != this.signature.length) {
                return false;
            }
            for (int i = 0; i < this.signature.length; ++i) {
                JavaType type = sig.getParameterType(i, null);
                String javaName = type.toJavaName();
                if (this.signature[i] == null || this.signature[i].matcher(javaName).matches()) continue;
                return false;
            }
            return true;
        }

        private boolean matchesArgTypes(List<Type> argTypes) {
            if (this.signature == null) {
                return true;
            }
            if (argTypes.size() != this.signature.length) {
                return false;
            }
            for (int i = 0; i < this.signature.length; ++i) {
                String javaName = argTypes.get(i).getTypeName();
                if (this.signature[i] == null || this.signature[i].matcher(javaName).matches()) continue;
                return false;
            }
            return true;
        }

        private boolean matches(String javaClassName, String name, Signature sig) {
            assert (sig != null || this.signature == null);
            if (this.methodName != null && !this.methodName.matcher(name).matches()) {
                return false;
            }
            if (this.clazz != null && !this.clazz.matcher(javaClassName).matches()) {
                return false;
            }
            return this.matchesSignature(sig);
        }

        private boolean matchesWithArgs(String javaClassName, String name, List<Type> argTypes) {
            assert (argTypes != null || this.signature == null);
            if (this.methodName != null && !this.methodName.matcher(name).matches()) {
                return false;
            }
            if (this.clazz != null && !this.clazz.matcher(javaClassName).matches()) {
                return false;
            }
            return this.matchesArgTypes(argTypes);
        }

        public String toString() {
            return this.toString(true);
        }

        private String toString(boolean positive) {
            StringBuilder buf = new StringBuilder("MethodFilter[");
            String sep = "";
            if (!positive) {
                buf.append(sep).append("NOT");
                sep = ", ";
            }
            if (this.clazz != null) {
                buf.append(sep).append("clazz=").append(this.clazz);
                sep = ", ";
            }
            if (this.methodName != null) {
                buf.append(sep).append("methodName=").append(this.methodName);
                sep = ", ";
            }
            if (this.signature != null) {
                buf.append(sep).append("signature=").append(Arrays.toString(this.signature));
                sep = ", ";
            }
            return buf.append("]").toString();
        }
    }
}

