/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.debug;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.WritableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.OpenOption;
import java.util.Iterator;
import java.util.ServiceLoader;
import jdk.graal.compiler.debug.PathUtilitiesProvider;
import jdk.graal.compiler.debug.StandardPathUtilitiesProvider;

public class PathUtilities {
    private static final PathUtilitiesProvider PROVIDER = PathUtilities.loadProvider();
    private static final int MAX_FILE_NAME_LENGTH = 242;
    private static final String ELLIPSIS = "...";

    private static PathUtilitiesProvider loadProvider() {
        ServiceLoader<PathUtilitiesProvider> providers = ServiceLoader.load(PathUtilitiesProvider.class);
        Iterator<PathUtilitiesProvider> it = providers.iterator();
        if (it.hasNext()) {
            PathUtilitiesProvider singleProvider = it.next();
            if (it.hasNext()) {
                PathUtilitiesProvider other = it.next();
                throw new InternalError(String.format("Multiple %s providers found: %s, %s", PathUtilitiesProvider.class.getName(), singleProvider.getClass().getName(), other.getClass().getName()));
            }
            return singleProvider;
        }
        return new StandardPathUtilitiesProvider();
    }

    public static String sanitizeFileName(String name) {
        return PROVIDER.sanitizeFileName(name);
    }

    public static String getPath(String first, String ... more) {
        return PROVIDER.getPath(first, more);
    }

    public static String getAbsolutePath(String path) {
        return PROVIDER.getAbsolutePath(path);
    }

    public static boolean exists(String path) {
        return PROVIDER.exists(path);
    }

    public static String createDirectories(String path) throws IOException {
        return PROVIDER.createDirectories(path);
    }

    public static OutputStream openOutputStream(String path, boolean append) throws IOException {
        return PROVIDER.openOutputStream(path, append);
    }

    public static OutputStream openOutputStream(String path) throws IOException {
        return PROVIDER.openOutputStream(path, false);
    }

    public static String getParent(String path) {
        return PROVIDER.getParent(path);
    }

    public static WritableByteChannel openFileChannel(String path, OpenOption ... options) throws IOException {
        return PROVIDER.openFileChannel(path, options);
    }

    public static InputStream openInputStream(String path) throws IOException {
        return PROVIDER.openInputStream(path);
    }

    public static String archiveAndDelete(String directory, String zip) throws IOException {
        return PROVIDER.archiveAndDelete(directory, zip);
    }

    private static String constructFileName(String prefix, String label, String suffix) {
        String fileName;
        int fileNameLengthWithoutLabel = suffix.length() + prefix.length() + "[]".length();
        int labelLengthLimit = 242 - fileNameLengthWithoutLabel;
        if (labelLengthLimit < ELLIPSIS.length()) {
            int prefixLengthLimit = Math.min(242 - suffix.length(), prefix.length());
            fileName = prefix.substring(0, prefixLengthLimit) + suffix;
        } else if (label == null) {
            fileName = prefix + suffix;
        } else {
            Object adjustedLabel = label;
            if (label.length() > labelLengthLimit) {
                adjustedLabel = label.substring(0, labelLengthLimit - ELLIPSIS.length()) + ELLIPSIS;
            }
            fileName = prefix + "[" + (String)adjustedLabel + "]" + suffix;
        }
        return PathUtilities.sanitizeFileName(fileName);
    }

    public static String createUnique(String directory, String prefix, String label, String ext, boolean createMissingDirectory) throws IOException {
        Object uniqueTag = "";
        int dumpCounter = 1;
        while (true) {
            String fileName = PathUtilities.constructFileName(prefix, label, (String)uniqueTag + ext);
            String result = PathUtilities.getPath(directory, fileName);
            try {
                if (createMissingDirectory) {
                    if (PathUtilities.exists(result)) {
                        throw new FileAlreadyExistsException(result);
                    }
                    return PathUtilities.createDirectories(result);
                }
                try {
                    return PROVIDER.createFile(result);
                }
                catch (AccessDeniedException e) {
                    throw PROVIDER.isDirectory(result, false) ? new FileAlreadyExistsException(e.getFile()) : e;
                }
            }
            catch (FileAlreadyExistsException e) {
                uniqueTag = "_" + dumpCounter++;
                if (dumpCounter <= 10) continue;
                uniqueTag = (String)uniqueTag + "_" + System.nanoTime();
                continue;
            }
            break;
        }
    }

    public static boolean isDirectory(String path, boolean followLinks) {
        return PROVIDER.isDirectory(path, followLinks);
    }

    public static void deleteFile(String path) throws IOException {
        PROVIDER.deleteFile(path);
    }
}

