/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.debug;

import java.io.PrintStream;
import java.util.Iterator;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.debug.DebugConfig;
import jdk.graal.compiler.debug.DebugConfigImpl;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.DebugDumpHandler;
import jdk.graal.compiler.debug.DebugVerifyHandler;
import jdk.graal.compiler.debug.Indent;
import jdk.graal.compiler.debug.JavaMethodContext;
import jdk.graal.compiler.debug.TTY;
import jdk.graal.compiler.serviceprovider.GraalServices;
import jdk.vm.ci.meta.JavaMethod;

public final class ScopeImpl
implements DebugContext.Scope {
    private final DebugContext owner;
    private final ScopeImpl parent;
    private final boolean sandbox;
    private IndentImpl lastUsedIndent;
    private final boolean emptyScope;
    private final Object[] context;
    private String qualifiedName;
    private final String unqualifiedName;
    private static final char SCOPE_SEP = '.';
    private boolean countEnabled;
    private boolean timeEnabled;
    private boolean memUseTrackingEnabled;
    private boolean verifyEnabled;
    private int currentDumpLevel;
    private int currentLogLevel;
    private PrintStream output;
    private boolean interceptDisabled;

    private boolean isEmptyScope() {
        return this.emptyScope;
    }

    ScopeImpl(DebugContext owner, Thread thread, boolean interceptDisabled) {
        this(owner, ScopeImpl.getThreadName(thread), null, false, interceptDisabled, new Object[0]);
    }

    private static String getThreadName(Thread thread) {
        String name = thread.getName();
        if (name.isEmpty()) {
            return thread.toString();
        }
        return name;
    }

    private ScopeImpl(DebugContext owner, String unqualifiedName, ScopeImpl parent, boolean sandbox, boolean interceptDisabled, Object ... context) {
        this.owner = owner;
        this.parent = parent;
        this.sandbox = sandbox;
        this.context = context;
        this.unqualifiedName = unqualifiedName;
        this.interceptDisabled = interceptDisabled;
        if (parent != null) {
            this.emptyScope = unqualifiedName.equals("");
        } else {
            if (unqualifiedName.isEmpty()) {
                throw new IllegalArgumentException("root scope name must be non-empty");
            }
            this.emptyScope = false;
        }
        this.output = TTY.out;
        assert (context != null);
    }

    @Override
    public void close() {
        this.owner.currentScope = this.parent;
        this.owner.lastClosedScope = this;
    }

    boolean isTopLevel() {
        return this.parent == null;
    }

    boolean isDumpEnabled(int dumpLevel) {
        assert (NumUtil.assertNonNegativeInt(dumpLevel));
        return this.currentDumpLevel >= dumpLevel;
    }

    boolean isVerifyEnabled() {
        return this.verifyEnabled;
    }

    boolean isLogEnabled(int logLevel) {
        assert (NumUtil.assertPositiveInt(logLevel));
        return this.currentLogLevel >= logLevel;
    }

    boolean isCountEnabled() {
        return this.countEnabled;
    }

    boolean isTimeEnabled() {
        return this.timeEnabled;
    }

    boolean isMemUseTrackingEnabled() {
        return this.memUseTrackingEnabled;
    }

    public void log(int logLevel, String msg, Object ... args) {
        assert (this.owner.checkNoConcurrentAccess());
        if (this.isLogEnabled(logLevel)) {
            this.getLastUsedIndent().log(logLevel, msg, args);
        }
    }

    public void dump(int dumpLevel, Object object, String formatString, Object ... args) {
        DebugConfig config;
        assert (this.isDumpEnabled(dumpLevel));
        if (this.isDumpEnabled(dumpLevel) && (config = this.getConfig()) != null) {
            for (DebugDumpHandler dumpHandler : config.dumpHandlers()) {
                dumpHandler.dump(object, this.owner, false, formatString, args);
            }
        }
    }

    private DebugConfig getConfig() {
        return this.owner.currentConfig;
    }

    public void verify(Object object, String formatString, Object ... args) {
        DebugConfig config;
        if (this.isVerifyEnabled() && (config = this.getConfig()) != null) {
            String message = String.format(formatString, args);
            for (DebugVerifyHandler handler : config.verifyHandlers()) {
                handler.verify(this.owner, object, message, new Object[0]);
            }
        }
    }

    public ScopeImpl scope(CharSequence name, DebugConfig sandboxConfig, Object ... newContextObjects) {
        ScopeImpl newScope = null;
        newScope = sandboxConfig != null ? new ScopeImpl(this.owner, name.toString(), this, true, this.interceptDisabled, newContextObjects) : this.createChild(name.toString(), newContextObjects);
        newScope.updateFlags(this.owner.currentConfig);
        return newScope;
    }

    private static <E extends Exception> RuntimeException silenceException(Class<E> type, Throwable ex) throws E {
        throw (Exception)ex;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RuntimeException handle(Throwable e) {
        block18: {
            try {
                DebugContext.Scope ownerLastClosedScope = this.owner.lastClosedScope;
                if (ownerLastClosedScope instanceof ScopeImpl) {
                    ScopeImpl lastClosed = (ScopeImpl)ownerLastClosedScope;
                    assert (lastClosed.parent == this) : "DebugContext.handle() used without closing a scope opened by DebugContext.scope(...) or DebugContext.sandbox(...) or an exception occurred while opening a scope";
                    if (e == this.owner.lastExceptionThrown) break block18;
                    RuntimeException newException = null;
                    this.owner.currentScope = lastClosed;
                    try (ScopeImpl s = lastClosed;){
                        newException = s.interceptException(e);
                    }
                    assert (this.owner.currentScope == this) : Assertions.errorMessageContext("owner", this.owner, "owner.currentScope", this.owner.currentScope, "this", this);
                    assert (lastClosed == ownerLastClosedScope) : Assertions.errorMessageContext("lastClosed", lastClosed, "owener.lastClosedScope", ownerLastClosedScope);
                    if (newException != null) {
                        this.owner.lastExceptionThrown = newException;
                        throw newException;
                    }
                    this.owner.lastExceptionThrown = e;
                    break block18;
                }
                if (ownerLastClosedScope == null) {
                    throw new AssertionError((Object)"DebugContext.handle() used without closing a scope opened by DebugContext.scope(...) or DebugContext.sandbox(...) or an exception occurred while opening a scope");
                }
                assert (ownerLastClosedScope instanceof DebugContext.DisabledScope) : ownerLastClosedScope;
            }
            catch (Throwable t) {
                if (t != e && t.getCause() == null) {
                    t.initCause(e);
                }
                throw t;
            }
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw ScopeImpl.silenceException(RuntimeException.class, e);
    }

    void updateFlags(DebugConfigImpl config) {
        if (config == null) {
            this.countEnabled = false;
            this.memUseTrackingEnabled = false;
            this.timeEnabled = false;
            this.verifyEnabled = false;
            this.currentDumpLevel = -1;
            this.output = TTY.out;
        } else if (this.isEmptyScope()) {
            this.countEnabled = this.parent.countEnabled;
            this.memUseTrackingEnabled = this.parent.memUseTrackingEnabled;
            this.timeEnabled = this.parent.timeEnabled;
            this.verifyEnabled = this.parent.verifyEnabled;
            this.output = this.parent.output;
            this.currentDumpLevel = this.parent.currentDumpLevel;
            this.currentLogLevel = this.parent.currentLogLevel;
        } else {
            this.countEnabled = config.isCountEnabled(this);
            this.memUseTrackingEnabled = config.isMemUseTrackingEnabled(this);
            this.timeEnabled = config.isTimeEnabled(this);
            this.verifyEnabled = config.isVerifyEnabled(this);
            this.output = config.output();
            this.currentDumpLevel = config.getDumpLevel(this);
            this.currentLogLevel = config.getLogLevel(this);
        }
    }

    DebugCloseable disableIntercept() {
        final boolean previous = this.interceptDisabled;
        this.interceptDisabled = true;
        return new DebugCloseable(){
            final /* synthetic */ ScopeImpl this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void close() {
                this.this$0.interceptDisabled = previous;
            }
        };
    }

    private RuntimeException interceptException(Throwable e) {
        if (!this.interceptDisabled && this.owner.currentConfig != null) {
            ScopeImpl s = this.scope("InterceptException", null, e);
            try {
                RuntimeException runtimeException = this.owner.currentConfig.interceptException(this.owner, e);
                if (s != null) {
                    s.close();
                }
                return runtimeException;
            }
            catch (Throwable throwable) {
                try {
                    if (s != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    return new RuntimeException("Exception while intercepting exception", t);
                }
            }
        }
        return null;
    }

    private ScopeImpl createChild(String newName, Object[] newContext) {
        return new ScopeImpl(this.owner, newName, this, false, this.interceptDisabled, newContext);
    }

    @Override
    public Iterable<Object> getCurrentContext() {
        final ScopeImpl scope = this;
        return new Iterable<Object>(this){

            @Override
            public Iterator<Object> iterator() {
                return new Iterator<Object>(){
                    ScopeImpl currentScope;
                    int objectIndex;
                    {
                        this.currentScope = scope;
                    }

                    @Override
                    public boolean hasNext() {
                        this.selectScope();
                        return this.currentScope != null;
                    }

                    private void selectScope() {
                        while (this.currentScope != null && this.currentScope.context.length <= this.objectIndex) {
                            this.currentScope = this.currentScope.sandbox ? null : this.currentScope.parent;
                            this.objectIndex = 0;
                        }
                    }

                    @Override
                    public Object next() {
                        this.selectScope();
                        if (this.currentScope != null) {
                            return this.currentScope.context[this.objectIndex++];
                        }
                        throw new IllegalStateException("May only be called if there is a next element.");
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("This iterator is read only.");
                    }
                };
            }
        };
    }

    @Override
    public String getQualifiedName() {
        if (this.qualifiedName == null) {
            if (this.parent == null) {
                this.qualifiedName = this.unqualifiedName;
            } else {
                this.qualifiedName = this.parent.getQualifiedName();
                if (!this.isEmptyScope()) {
                    this.qualifiedName = this.qualifiedName + "." + this.unqualifiedName;
                }
            }
        }
        return this.qualifiedName;
    }

    Indent pushIndentLogger() {
        this.lastUsedIndent = this.getLastUsedIndent().indent();
        return this.lastUsedIndent;
    }

    private IndentImpl getLastUsedIndent() {
        if (this.lastUsedIndent == null) {
            this.lastUsedIndent = this.parent != null ? new IndentImpl(this.parent.getLastUsedIndent()) : new IndentImpl(null);
        }
        return this.lastUsedIndent;
    }

    private final class IndentImpl
    implements Indent {
        private static final String INDENTATION_INCREMENT = "  ";
        final String indent;
        final IndentImpl parentIndent;
        private boolean emitted;

        boolean isEmitted() {
            return this.emitted;
        }

        IndentImpl(IndentImpl parentIndent) {
            this.parentIndent = parentIndent;
            this.indent = parentIndent == null ? "" : parentIndent.indent + INDENTATION_INCREMENT;
        }

        private void printScopeName(StringBuilder str, boolean isCurrent) {
            if (!this.emitted) {
                boolean mustPrint = true;
                if (this.parentIndent != null && !this.parentIndent.isEmitted()) {
                    this.parentIndent.printScopeName(str, false);
                    mustPrint = false;
                }
                if (isCurrent || this.printContext(null) != 0 || mustPrint) {
                    str.append(this.indent).append("[thread:").append(GraalServices.getCurrentThreadId()).append("] scope: ").append(ScopeImpl.this.getQualifiedName()).append(System.lineSeparator());
                }
                this.printContext(str);
                this.emitted = true;
            }
        }

        private int printContext(StringBuilder str) {
            int count = 0;
            if (ScopeImpl.this.context != null && ScopeImpl.this.context.length > 0) {
                for (Object contextObj : ScopeImpl.this.context) {
                    if (!(contextObj instanceof JavaMethodContext) && !(contextObj instanceof JavaMethod)) continue;
                    if (str != null) {
                        str.append(this.indent).append("Context: ").append(contextObj).append(System.lineSeparator());
                    }
                    ++count;
                }
            }
            return count;
        }

        public void log(int logLevel, String msg, Object ... args) {
            if (ScopeImpl.this.isLogEnabled(logLevel)) {
                StringBuilder str = new StringBuilder();
                this.printScopeName(str, true);
                str.append(this.indent);
                String result = args.length == 0 ? msg : String.format(msg, args);
                String lineSep = System.lineSeparator();
                str.append(result.replace(lineSep, lineSep.concat(this.indent)));
                str.append(lineSep);
                ScopeImpl.this.output.append(str);
                ScopeImpl.this.lastUsedIndent = this;
            }
        }

        IndentImpl indent() {
            ScopeImpl.this.lastUsedIndent = new IndentImpl(this);
            return ScopeImpl.this.lastUsedIndent;
        }

        @Override
        public void close() {
            if (this.parentIndent != null) {
                ScopeImpl.this.lastUsedIndent = this.parentIndent;
            }
        }
    }
}

