/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.graph;

import java.util.ArrayList;
import java.util.Iterator;
import jdk.graal.compiler.core.common.Fields;
import jdk.graal.compiler.core.common.FieldsScanner;
import jdk.graal.compiler.graph.Graph;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.graph.NodeInputList;
import jdk.graal.compiler.graph.NodeList;
import jdk.graal.compiler.graph.NodeSuccessorList;
import jdk.graal.compiler.graph.Position;
import jdk.internal.misc.Unsafe;

public abstract class Edges
extends Fields {
    private static final Unsafe UNSAFE = Unsafe.getUnsafe();
    private final int directCount;
    private final Type type;

    public Edges(Type type, int directCount, ArrayList<? extends FieldsScanner.FieldInfo> edges) {
        super(edges);
        this.type = type;
        this.directCount = directCount;
    }

    public static void translateInto(Edges edges, ArrayList<NodeClass.EdgeInfo> infos) {
        for (int index = 0; index < edges.getCount(); ++index) {
            infos.add(new NodeClass.EdgeInfo(edges.offsets[index], edges.getName(index), edges.getType(index), edges.getDeclaringClass(index)));
        }
    }

    public static Node getNodeUnsafe(Node node, long offset) {
        return (Node)UNSAFE.getReference(node, offset);
    }

    public static NodeList<Node> getNodeListUnsafe(Node node, long offset) {
        return (NodeList)UNSAFE.getReference(node, offset);
    }

    public void putNodeUnsafeChecked(Node node, long offset, Node value, int index) {
        this.verifyUpdateValid(node, index, value);
        Edges.putNodeUnsafe(node, offset, value);
    }

    public static void putNodeUnsafe(Node node, long offset, Node value) {
        UNSAFE.putReference(node, offset, value);
    }

    public static void putNodeListUnsafe(Node node, long offset, NodeList<?> value) {
        UNSAFE.putReference(node, offset, value);
    }

    public int getDirectCount() {
        return this.directCount;
    }

    public static Node getNode(Node node, long[] offsets, int index) {
        return Edges.getNodeUnsafe(node, offsets[index]);
    }

    public static NodeList<Node> getNodeList(Node node, long[] offsets, int index) {
        return Edges.getNodeListUnsafe(node, offsets[index]);
    }

    public void initializeLists(Node node, Node prototype) {
        long[] curOffsets = this.offsets;
        Type curType = this.type;
        for (int index = this.getDirectCount(); index < this.getCount(); ++index) {
            NodeList<Node> list = Edges.getNodeList(prototype, curOffsets, index);
            if (list == null) continue;
            int size = list.initialSize;
            NodeInputList<Node> newList = curType == Type.Inputs ? new NodeInputList(node, size) : new NodeSuccessorList(node, size);
            this.initializeList(node, index, newList);
        }
    }

    public void copy(Node fromNode, Node toNode) {
        int index;
        assert (fromNode != toNode) : fromNode;
        assert (fromNode.getNodeClass().getClazz() == toNode.getNodeClass().getClazz()) : "fromNode " + String.valueOf(fromNode) + " toNode " + String.valueOf(toNode);
        long[] curOffsets = this.offsets;
        Type curType = this.type;
        int curDirectCount = this.getDirectCount();
        for (index = 0; index < curDirectCount; ++index) {
            this.initializeNode(toNode, index, Edges.getNode(fromNode, curOffsets, index));
        }
        int curCount = this.getCount();
        while (index < curCount) {
            NodeList<Node> list = Edges.getNodeList(toNode, curOffsets, index);
            NodeList<Node> fromList = Edges.getNodeList(fromNode, curOffsets, index);
            if (fromList != null) {
                if (list == null || list == fromList) {
                    list = curType == Type.Inputs ? new NodeInputList<Node>(toNode, fromList) : new NodeSuccessorList<Node>(toNode, fromList);
                    this.initializeList(toNode, index, list);
                } else {
                    list.copy(fromList);
                }
            }
            ++index;
        }
    }

    void minimizeSize(Node node) {
        for (int i = this.getDirectCount(); i < this.getCount(); ++i) {
            NodeList<Node> list = Edges.getNodeList(node, this.offsets, i);
            if (list == null) continue;
            list.minimizeSize();
        }
    }

    public void initializeNode(Node node, int index, Node value) {
        this.putNodeUnsafeChecked(node, this.offsets[index], value, index);
    }

    public void initializeList(Node node, int index, NodeList<Node> value) {
        this.verifyUpdateValid(node, index, value);
        Edges.putNodeListUnsafe(node, this.offsets[index], value);
    }

    private void verifyUpdateValid(Node node, int index, Object newValue) {
        if (newValue != null && !this.getType(index).isAssignableFrom(newValue.getClass())) {
            throw new IllegalArgumentException("Can not assign " + String.valueOf(newValue) + " to " + String.valueOf(this.getType(index)) + " in " + String.valueOf(node));
        }
    }

    public void setNode(Node node, int index, Node value) {
        assert (index < this.directCount) : index;
        Node old = Edges.getNodeUnsafe(node, this.offsets[index]);
        this.initializeNode(node, index, value);
        this.update(node, old, value);
    }

    public abstract void update(Node var1, Node var2, Node var3);

    public Iterable<Position> getPositionsIterable(final Node node) {
        return new Iterable<Position>(this){
            final /* synthetic */ Edges this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Iterator<Position> iterator() {
                if (Graph.isNodeModificationCountsEnabled()) {
                    return new EdgesWithModCountIterator(node, this.this$0);
                }
                return new EdgesIterator(node, this.this$0);
            }
        };
    }

    public Type type() {
        return this.type;
    }

    public static enum Type {
        Inputs,
        Successors;

    }

    private static final class EdgesWithModCountIterator
    extends EdgesIterator {
        private final int modCount;

        private EdgesWithModCountIterator(Node node, Edges edges) {
            super(node, edges);
            assert (Graph.isNodeModificationCountsEnabled());
            this.modCount = node.modCount();
        }

        @Override
        public boolean hasNext() {
            try {
                boolean bl = super.hasNext();
                return bl;
            }
            finally {
                assert (this.modCount == this.node.modCount()) : "must not be modified";
            }
        }

        @Override
        public Position next() {
            try {
                Position position = super.next();
                return position;
            }
            finally {
                assert (this.modCount == this.node.modCount()) : "must not be modified";
            }
        }
    }

    private static class EdgesIterator
    implements Iterator<Position> {
        protected final Node node;
        protected final Edges edges;
        protected int index;
        protected int subIndex;
        protected boolean needsForward;
        protected final int directCount;
        protected final long[] offsets;

        EdgesIterator(Node node, Edges edges) {
            this.node = node;
            this.edges = edges;
            this.index = -1;
            this.subIndex = 0;
            this.needsForward = true;
            this.directCount = edges.getDirectCount();
            this.offsets = edges.getOffsets();
        }

        void forward() {
            this.needsForward = false;
            if (this.index < this.directCount) {
                ++this.index;
                if (this.index < this.directCount) {
                    return;
                }
            } else {
                ++this.subIndex;
            }
            if (this.index < this.edges.getCount()) {
                this.forwardNodeList();
            }
        }

        private void forwardNodeList() {
            do {
                NodeList<Node> list;
                if ((list = Edges.getNodeList(this.node, this.offsets, this.index)) != null && this.subIndex < list.size()) {
                    return;
                }
                this.subIndex = 0;
                ++this.index;
            } while (this.index < this.edges.getCount());
        }

        @Override
        public boolean hasNext() {
            if (this.needsForward) {
                this.forward();
            }
            return this.index < this.edges.getCount();
        }

        @Override
        public Position next() {
            if (this.needsForward) {
                this.forward();
            }
            this.needsForward = true;
            if (this.index < this.directCount) {
                return new Position(this.edges, this.index, -1);
            }
            return new Position(this.edges, this.index, this.subIndex);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

