/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.graph;

import jdk.graal.compiler.graph.Node;

public final class NodeStack {
    private static final int DEFAULT_INITIAL_SIZE = 8;
    protected Node[] values;
    public int tos;

    public NodeStack() {
        this(8);
    }

    public NodeStack(int initialSize) {
        this.values = new Node[initialSize];
    }

    public int size() {
        return this.tos;
    }

    public void push(Node n) {
        int newIndex;
        int valuesLength = this.values.length;
        if ((newIndex = this.tos++) >= valuesLength) {
            this.grow();
        }
        this.values[newIndex] = n;
    }

    private void grow() {
        int valuesLength = this.values.length;
        Node[] newValues = new Node[valuesLength << 1];
        System.arraycopy(this.values, 0, newValues, 0, valuesLength);
        this.values = newValues;
    }

    public Node get(int index) {
        return this.values[index];
    }

    public Node pop() {
        assert (this.tos > 0) : "stack must be non-empty";
        return this.values[--this.tos];
    }

    public Node peek() {
        assert (this.tos > 0) : "stack must be non-empty";
        return this.values[this.tos - 1];
    }

    public boolean isEmpty() {
        return this.tos == 0;
    }

    public void clear() {
        this.tos = 0;
    }

    public String toString() {
        if (this.tos == 0) {
            return "NodeStack: []";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.tos; ++i) {
            sb.append(", ");
            sb.append(this.values[i]);
        }
        return "NodeStack: [" + sb.substring(2) + "]";
    }
}

