/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.graphio.parsing;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import jdk.graal.compiler.graphio.parsing.DataSource;
import jdk.graal.compiler.graphio.parsing.StreamSource;
import jdk.graal.compiler.graphio.parsing.VersionMismatchException;

public class BinarySource
implements DataSource {
    private final long baseOffset;
    private final ByteBuffer buffer;
    private int lastPosition = 0;
    final ReadableByteChannel channel;
    long bufferOffset;
    private int majorVersion;
    private int minorVersion;
    private MessageDigest digest;
    private boolean performDigest;
    private Object sourceId;

    public BinarySource(Object sourceId, ReadableByteChannel channel) {
        this(channel, 0, 0, 0L);
        this.sourceId = sourceId;
    }

    public BinarySource(ReadableByteChannel channel, int major, int minor, long offset) {
        this.majorVersion = major;
        this.minorVersion = minor;
        this.buffer = ByteBuffer.allocateDirect(262144);
        this.buffer.flip();
        this.channel = channel;
        this.bufferOffset = this.baseOffset = offset;
        try {
            this.digest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    public Object getSourceId() {
        return this.sourceId;
    }

    public void useDigest(MessageDigest newDigest) {
        this.digest = newDigest;
    }

    private void setVersion(int newMajorVersion, int newMinorVersion) throws IOException {
        if (newMajorVersion > 8 || newMajorVersion == 8 && newMinorVersion > 0) {
            throw new VersionMismatchException("File format version " + StreamSource.versionPair(newMajorVersion, newMinorVersion) + " unsupported.  Current version is " + StreamSource.CURRENT_VERSION);
        }
        this.majorVersion = newMajorVersion;
        this.minorVersion = newMinorVersion;
    }

    @Override
    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    @Override
    public long getMark() {
        return this.bufferOffset + (long)this.buffer.position();
    }

    public long getMarkRelative() {
        return this.getMark() - this.baseOffset;
    }

    @Override
    public int readInt() throws IOException {
        this.ensureAvailable(4);
        return this.buffer.getInt();
    }

    @Override
    public double[] readDoubles() throws IOException {
        int len = this.readInt();
        if (len < 0) {
            return null;
        }
        this.ensureAvailable(len * 8);
        double[] props = new double[len];
        for (int i = 0; i < len; ++i) {
            props[i] = this.buffer.getDouble();
        }
        return props;
    }

    @Override
    public long readLong() throws IOException {
        this.ensureAvailable(8);
        return this.buffer.getLong();
    }

    byte[] peekBytes(int len) throws IOException {
        this.ensureAvailable(len);
        byte[] b = new byte[len];
        this.buffer.mark();
        this.buffer.get(b);
        this.buffer.reset();
        return b;
    }

    @Override
    public float readFloat() throws IOException {
        this.ensureAvailable(4);
        return this.buffer.getFloat();
    }

    @Override
    public int readByte() throws IOException {
        this.ensureAvailable(1);
        return this.buffer.get() & 0xFF;
    }

    @Override
    public double readDouble() throws IOException {
        this.ensureAvailable(8);
        return this.buffer.getDouble();
    }

    @Override
    public byte[] finishDigest() {
        assert (this.performDigest);
        this.digestUpToPosition();
        this.performDigest = false;
        return this.digest.digest();
    }

    @Override
    public void startDigest() {
        this.digest.reset();
        this.performDigest = true;
        this.lastPosition = this.buffer.position();
    }

    private void digestUpToPosition() {
        if (!this.performDigest) {
            return;
        }
        int position = this.buffer.position();
        this.buffer.position(this.lastPosition);
        byte[] remaining = new byte[position - this.buffer.position()];
        this.buffer.get(remaining);
        this.digest.update(remaining);
        assert (position == this.buffer.position());
    }

    protected void fill() throws IOException {
        int position = this.buffer.position();
        this.digestUpToPosition();
        this.buffer.compact();
        this.bufferOffset += (long)position;
        this.lastPosition = 0;
        this.receiveBytes(this.buffer);
        this.buffer.flip();
    }

    protected void receiveBytes(ByteBuffer b) throws IOException {
        if (this.channel.read(b) < 0) {
            throw new EOFException();
        }
    }

    @Override
    public byte[] readBytes() throws IOException {
        int len = this.readInt();
        if (len < 0) {
            return null;
        }
        return this.readBytes(len);
    }

    @Override
    public byte[] readBytes(int len) throws IOException {
        return this.readBytes(new byte[len], len);
    }

    @Override
    public byte[] readBytes(byte[] b, int len) throws IOException {
        int toRead;
        for (int bytesRead = 0; bytesRead < len; bytesRead += toRead) {
            toRead = Math.min(len - bytesRead, this.buffer.capacity());
            this.ensureAvailable(toRead);
            this.buffer.get(b, bytesRead, toRead);
        }
        return b;
    }

    @Override
    public char readShort() throws IOException {
        this.ensureAvailable(2);
        return this.buffer.getChar();
    }

    @Override
    public int[] readInts() throws IOException {
        int len = this.readInt();
        if (len < 0) {
            return null;
        }
        this.ensureAvailable(len * 4);
        int[] props = new int[len];
        for (int i = 0; i < len; ++i) {
            props[i] = this.buffer.getInt();
        }
        return props;
    }

    @Override
    public String readString() throws IOException {
        return new String(this.readBytes(), StandardCharsets.UTF_8);
    }

    private void ensureAvailable(int i) throws IOException {
        if (i > this.buffer.capacity()) {
            throw new IllegalArgumentException(String.format("Can not request %d bytes: buffer capacity is %d", i, this.buffer.capacity()));
        }
        while (this.buffer.remaining() < i) {
            this.fill();
        }
    }

    @Override
    public boolean readHeader() throws IOException {
        byte[] magic = this.peekBytes(StreamSource.MAGIC_BYTES.length);
        if (Arrays.equals(StreamSource.MAGIC_BYTES, magic)) {
            this.readBytes(StreamSource.MAGIC_BYTES.length);
            this.setVersion(this.readByte(), this.readByte());
            return true;
        }
        return false;
    }

    public String toString() {
        return "BinarySource@" + Integer.toHexString(System.identityHashCode(this));
    }
}

