/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.graphio.parsing;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import jdk.graal.compiler.graphio.parsing.BinaryReader;
import jdk.graal.compiler.graphio.parsing.ConstantPool;
import jdk.graal.compiler.graphio.parsing.NameTranslator;
import jdk.graal.compiler.graphio.parsing.model.GraphDocument;
import jdk.graal.compiler.graphio.parsing.model.Group;
import jdk.graal.compiler.graphio.parsing.model.InputBlock;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.Properties;

public interface Builder {
    public void setModelControl(ModelControl var1);

    public void addBlockEdge(int var1, int var2);

    public void addNodeToBlock(int var1);

    public void end();

    public void endBlock(int var1);

    public InputGraph endGraph();

    public void endGroup();

    public void endNode(int var1);

    public ConstantPool getConstantPool();

    public Properties getNodeProperties(int var1);

    public void inputEdge(Port var1, int var2, int var3, char var4, int var5);

    public void makeBlockEdges();

    public void makeGraphEdges();

    public void markGraphDuplicate();

    public void resetStreamData();

    public GraphDocument rootDocument();

    public void setGroupName(String var1, String var2);

    public void setMethod(String var1, String var2, int var3, BinaryReader.Method var4);

    public void setNodeName(NodeClass var1);

    public void setNodeProperty(String var1, Object var2);

    public void setProperty(String var1, Object var2);

    public void setPropertySize(int var1);

    public void start();

    public InputBlock startBlock(int var1);

    public InputBlock startBlock(String var1);

    public InputGraph startGraph(int var1, String var2, Object[] var3);

    public void startGraphContents(InputGraph var1);

    public Group startGroup();

    public void startGroupContent();

    public void startNestedProperty(String var1);

    public void startNode(int var1, boolean var2, NodeClass var3);

    public void startRoot();

    public void successorEdge(Port var1, int var2, int var3, char var4, int var5);

    public NameTranslator prepareNameTranslator();

    public void startDocumentHeader();

    public void endDocumentHeader();

    public void graphContentDigest(byte[] var1);

    public void reportLoadingError(String var1, List<String> var2);

    public static final class NodeClass {
        public final String className;
        public final String nameTemplate;
        public final List<TypedPort> inputs;
        public final List<Port> sux;

        NodeClass(String className, String nameTemplate, List<TypedPort> inputs, List<Port> sux) {
            this.className = className;
            this.nameTemplate = nameTemplate;
            this.inputs = inputs;
            this.sux = sux;
        }

        public String toString() {
            return this.className;
        }

        public int hashCode() {
            int hash = 7;
            hash = 37 * hash + Objects.hashCode(this.className);
            hash = 37 * hash + Objects.hashCode(this.inputs);
            hash = 37 * hash + Objects.hashCode(this.sux);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodeClass other = (NodeClass)obj;
            if (!Objects.equals(this.className, other.className)) {
                return false;
            }
            if (!Objects.equals(this.inputs, other.inputs)) {
                return false;
            }
            return Objects.equals(this.sux, other.sux);
        }

        String toShortString() {
            int lastDot = this.className.lastIndexOf(46);
            String localShortName = this.className.substring(lastDot + 1);
            if (localShortName.endsWith("Node") && !localShortName.equals("StartNode") && !localShortName.equals("EndNode")) {
                return localShortName.substring(0, localShortName.length() - 4);
            }
            return localShortName;
        }
    }

    public static final class Node {
        public final int id;
        public final NodeClass clazz;

        Node(int id, NodeClass clazz) {
            this.id = id;
            this.clazz = clazz;
        }

        public String toString() {
            return this.id + " : " + this.clazz.toShortString();
        }
    }

    public static final class TypedPort
    extends Port {
        final BinaryReader.EnumValue type;

        TypedPort(boolean isList, String name, BinaryReader.EnumValue type) {
            super(isList, name);
            this.type = type;
        }

        @Override
        public int hashCode() {
            return super.hashCode() * 23 ^ Objects.hashCode(this.type);
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && Objects.equals(this.type, ((TypedPort)obj).type);
        }
    }

    public static class Port {
        public final boolean isList;
        public final String name;
        public List<Integer> ids = new ArrayList<Integer>();

        Port(boolean isList, String name) {
            this.isList = isList;
            this.name = name;
        }

        public int hashCode() {
            return (this.isList ? 7 : 13) ^ this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Port other = (Port)obj;
            return this.isList == other.isList && Objects.equals(this.name, other.name);
        }
    }

    public static interface LengthToString {
        public String toString(Length var1);
    }

    public static enum Length {
        S,
        M,
        L;

    }

    public static interface ModelControl {
        public ConstantPool getConstantPool();

        public void setConstantPool(ConstantPool var1);
    }
}

