/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.graphio.parsing;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.graal.compiler.graphio.GraphOutput;
import jdk.graal.compiler.graphio.parsing.BinaryReader;
import jdk.graal.compiler.graphio.parsing.DataBinaryPrinter;
import jdk.graal.compiler.graphio.parsing.ModelBuilder;
import jdk.graal.compiler.graphio.parsing.model.FolderElement;
import jdk.graal.compiler.graphio.parsing.model.GraphDocument;
import jdk.graal.compiler.graphio.parsing.model.Group;
import jdk.graal.compiler.graphio.parsing.model.InputGraph;
import jdk.graal.compiler.graphio.parsing.model.InputMethod;

public final class DataBinaryWriter {
    private static final Set<String> GROUP_PROPERTY_EXCLUDE = new HashSet<String>(Arrays.asList("name", "type"));
    public static final Set<String> NODE_PROPERTY_EXCLUDE = new HashSet<String>(Stream.concat(ModelBuilder.SYSTEM_PROPERTIES.stream(), Stream.of("shortName")).collect(Collectors.toList()));
    private static final Set<String> GRAPH_PROPERTY_EXCLUDE = new HashSet<String>(Arrays.asList("name", "_isDuplicate"));
    private final GraphOutput<InputGraph, BinaryReader.Method> target;
    private final AtomicBoolean cancel;
    private final Consumer<FolderElement> progressCallback;

    private DataBinaryWriter(GraphOutput<InputGraph, BinaryReader.Method> target, AtomicBoolean cancel, Consumer<FolderElement> progressCallback) {
        this.target = target;
        this.cancel = cancel;
        this.progressCallback = progressCallback;
    }

    public static void export(File file, GraphDocument doc, Consumer<FolderElement> progressCallback, AtomicBoolean cancel) throws IOException {
        if (doc != null && file != null && file.getName().endsWith(".bgv")) {
            try (GraphOutput<InputGraph, BinaryReader.Method> target = DataBinaryPrinter.createOutput(FileChannel.open(file.toPath(), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING), doc.getProperties().toMap(new LinkedHashMap<String, Object>(), GROUP_PROPERTY_EXCLUDE, new String[0]));){
                new DataBinaryWriter(target, cancel, progressCallback).export(doc);
            }
        }
    }

    private void export(GraphDocument doc) throws IOException {
        try {
            for (FolderElement folderElement : doc.getElements()) {
                if (this.cancel != null && this.cancel.get()) {
                    throw new CancellationException();
                }
                if (!(folderElement instanceof Group)) continue;
                this.writeGroup((Group)folderElement);
            }
        }
        catch (InterruptedException ex) {
            throw new InterruptedIOException();
        }
    }

    private void completeContent(Group.LazyContent<?> content) throws InterruptedException, IOException {
        Future<?> fut = content.completeContents(null);
        try {
            fut.get();
        }
        catch (ExecutionException e) {
            throw new IOException();
        }
        catch (InterruptedException e) {
            if (this.cancel != null && this.cancel.get()) {
                throw new CancellationException();
            }
            throw e;
        }
    }

    private void writeGroup(Group group) throws IOException, InterruptedException {
        InputMethod method;
        if (this.cancel != null && this.cancel.get()) {
            throw new CancellationException();
        }
        if (group instanceof Group.LazyContent) {
            this.completeContent((Group.LazyContent)((Object)group));
        }
        String shortName = (method = group.getMethod()) != null ? method.getShortName() : group.getName();
        BinaryReader.Method resolvedMethod = method != null ? method.getMethod() : null;
        int bci = method != null ? method.getBci() : -1;
        String name = group.getName();
        this.target.beginGroup(null, name, shortName, resolvedMethod, bci, group.getProperties().toMap(new LinkedHashMap<String, Object>(), GROUP_PROPERTY_EXCLUDE, new String[0]));
        for (FolderElement element : group.getElements()) {
            if (element instanceof Group) {
                this.writeGroup((Group)element);
                continue;
            }
            if (!(element instanceof InputGraph)) continue;
            this.writeGraph((InputGraph)element);
        }
        this.target.endGroup();
    }

    private void writeGraph(InputGraph graph) throws IOException, InterruptedException {
        if (this.cancel != null && this.cancel.get()) {
            throw new CancellationException();
        }
        if (this.progressCallback != null) {
            this.progressCallback.accept(graph);
        }
        if (graph instanceof Group.LazyContent) {
            this.completeContent((Group.LazyContent)((Object)graph));
        }
        this.target.print(graph, graph.getProperties().toMap(new LinkedHashMap<String, Object>(), GRAPH_PROPERTY_EXCLUDE, new String[0]), graph.getDumpId(), graph.getFormat(), graph.getArgs());
    }
}

