/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.graphio.parsing;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import jdk.graal.compiler.graphio.parsing.BinaryReader;
import jdk.graal.compiler.graphio.parsing.Builder;
import jdk.graal.compiler.graphio.parsing.LocationStratum;

public final class LocationStackFrame {
    private final BinaryReader.Method method;
    private final int bci;
    private final List<LocationStratum> strata;
    private final LocationStackFrame parent;
    private int hashCode;

    LocationStackFrame(BinaryReader.Method method, int bci, List<LocationStratum> infos, LocationStackFrame parent) {
        this.method = method;
        this.bci = bci;
        this.parent = parent;
        this.strata = infos;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        LocationStackFrame t = this;
        while (t != null) {
            sb.append(sep);
            sb.append(LocationStackFrame.methodHolderName(t)).append(".").append(t.method.name);
            for (LocationStratum s : t.strata) {
                if (s.file != null) {
                    sb.append("(").append(s.file).append(":").append(s.line).append(")");
                    continue;
                }
                if (s.uri == null) continue;
                sb.append("(").append(s.uri).append(":").append(s.line).append(")");
            }
            sb.append(" [bci:").append(t.bci).append(']');
            sep = "\n";
            t = t.parent;
        }
        return sb.toString();
    }

    private static String methodHolderName(LocationStackFrame t) {
        if (t != null && t.method != null && t.method.holder != null) {
            return t.method.holder.name;
        }
        return null;
    }

    public String getFullMethodName() {
        return this.method == null ? null : this.method.toString(Builder.Length.M);
    }

    BinaryReader.Method getMethod() {
        return this.method;
    }

    public LocationStackFrame getParent() {
        return this.parent;
    }

    public int getBci() {
        return this.bci;
    }

    public String getFileName() {
        return this.strata.get((int)0).file;
    }

    public int getLine() {
        return this.strata.get((int)0).line;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int hash = 5;
            hash = 79 * hash + Objects.hashCode(this.method);
            hash = 79 * hash + this.bci;
            hash = 79 * hash + Objects.hashCode(this.strata);
            if ((hash = 79 * hash + Objects.hashCode(this.parent)) == 0) {
                hash = 79;
            }
            this.hashCode = hash;
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocationStackFrame other = (LocationStackFrame)obj;
        if (!Objects.equals(this.method, other.method)) {
            return false;
        }
        if (!Objects.equals(this.parent, other.parent)) {
            return false;
        }
        return Objects.equals(this.strata, other.strata);
    }

    public List<LocationStratum> getStrata() {
        return Collections.unmodifiableList(this.strata);
    }
}

