/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.graphio.parsing.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import jdk.graal.compiler.graphio.parsing.model.ChangedEvent;
import jdk.graal.compiler.graphio.parsing.model.ChangedEventProvider;
import jdk.graal.compiler.graphio.parsing.model.DataCollectionEvent;
import jdk.graal.compiler.graphio.parsing.model.DataCollectionListener;
import jdk.graal.compiler.graphio.parsing.model.DumpedElement;
import jdk.graal.compiler.graphio.parsing.model.Folder;
import jdk.graal.compiler.graphio.parsing.model.FolderElement;
import jdk.graal.compiler.graphio.parsing.model.Properties;
import jdk.graal.compiler.graphio.parsing.model.Property;

public class GraphDocument
extends Properties.Entity
implements ChangedEventProvider<GraphDocument>,
Folder,
FolderElement,
DumpedElement,
Properties.MutableOwner<GraphDocument> {
    private final List<FolderElement> elements;
    private final ChangedEvent<GraphDocument> changedEvent;
    private final ChangedEvent<GraphDocument> propertyEvent;
    private final List<DataCollectionListener> dataListeners = new ArrayList<DataCollectionListener>();
    private boolean modified;
    private volatile boolean trackModified;
    private DocumentLock lock;
    private Object documentId;
    private final Map<Object, Properties> mutableProperties = new HashMap<Object, Properties>();

    public GraphDocument() {
        this.elements = new ArrayList<FolderElement>();
        this.changedEvent = new ChangedEvent<GraphDocument>(this);
        this.propertyEvent = new ChangedEvent<GraphDocument>(this);
    }

    @Override
    public Object getID() {
        return this.documentId;
    }

    public void setDocumentId(Object documentId) {
        this.documentId = documentId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        GraphDocument graphDocument = this;
        synchronized (graphDocument) {
            this.elements.clear();
        }
        this.changedEvent.fire();
    }

    @Override
    public Properties writableProperties() {
        return this.getProperties();
    }

    @Override
    public void updateProperties(Properties props) {
        this.setModified(true);
        this.propertyEvent.fire();
    }

    public boolean isModified() {
        return this.modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setModified(boolean mod) {
        GraphDocument graphDocument = this;
        synchronized (graphDocument) {
            if (mod == this.modified) {
                return;
            }
            this.modified = mod;
        }
        this.propertyEvent.fire();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getModifiedProperties(FolderElement item) {
        GraphDocument graphDocument = this;
        synchronized (graphDocument) {
            return this.mutableProperties.get(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyPropertiesChanged(FolderElement item, Properties writableProps) {
        GraphDocument graphDocument = this;
        synchronized (graphDocument) {
            Properties oldValue = this.mutableProperties.put(item, writableProps);
            if (oldValue != null && oldValue != writableProps) {
                throw new IllegalArgumentException();
            }
        }
        this.setModified(true);
    }

    @Override
    public final ChangedEvent<GraphDocument> getChangedEvent() {
        return this.changedEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGraphDocument(GraphDocument document) {
        if (document == this) {
            return;
        }
        this.changedEvent.beginAtomic();
        try {
            List<? extends FolderElement> otherElems = document.getElements();
            GraphDocument graphDocument = this;
            synchronized (graphDocument) {
                for (FolderElement folderElement : otherElems) {
                    folderElement.setParent(this);
                    this.addElement(folderElement);
                }
            }
            document.clear();
        }
        finally {
            this.changedEvent.endAtomic();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GraphDocument: ").append(this.getProperties().toString()).append(" \n\n");
        for (FolderElement folderElement : this.getElements()) {
            sb.append(folderElement.toString());
            sb.append("\n\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        GraphDocument graphDocument = this;
        synchronized (graphDocument) {
            return this.elements.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<? extends FolderElement> getElements() {
        GraphDocument graphDocument = this;
        synchronized (graphDocument) {
            return List.copyOf(this.elements);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeElement(FolderElement element) {
        GraphDocument graphDocument = this;
        synchronized (graphDocument) {
            if (!this.elements.remove(element)) {
                return;
            }
        }
        this.changedEvent.fire();
        this.fireDataRemoved(Collections.singleton(element));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addElement(FolderElement element) {
        boolean propertiesChanged = false;
        GraphDocument graphDocument = this;
        synchronized (graphDocument) {
            this.elements.add(element);
            String n = this.getName();
            if ((n == null || n.isEmpty()) && element instanceof Properties.Entity) {
                for (Property p : ((Properties.Entity)((Object)element)).getProperties()) {
                    if ("name".equals(p.getName())) continue;
                    this.getProperties().setProperty(p.getName(), p.getValue());
                }
                propertiesChanged = true;
            }
        }
        this.changedEvent.fire();
        if (propertiesChanged) {
            this.propertyEvent.fire();
        }
        this.fireDataAdded(Collections.singletonList(element));
    }

    void fireDataAdded(List<? extends FolderElement> items) {
        DataCollectionEvent ev = new DataCollectionEvent(this, items, true, this);
        this.fireDataCollectionEvent(ev, DataCollectionListener::dataLoaded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataCollectionListener(DataCollectionListener l) {
        GraphDocument graphDocument = this;
        synchronized (graphDocument) {
            this.dataListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataCollectionListener(DataCollectionListener l) {
        GraphDocument graphDocument = this;
        synchronized (graphDocument) {
            this.dataListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDataCollectionEvent(DataCollectionEvent ev, BiConsumer<DataCollectionListener, DataCollectionEvent> fn) {
        DataCollectionListener[] ll = null;
        if (this.trackModified) {
            this.setModified(true);
        }
        DataCollectionListener[] dataCollectionListenerArray = this;
        synchronized (this) {
            if (this.dataListeners.isEmpty()) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return;
            }
            ll = this.dataListeners.toArray(new DataCollectionListener[0]);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            for (DataCollectionListener l : ll) {
                fn.accept(l, ev);
            }
            return;
        }
    }

    void fireDataRemoved(Collection<? extends FolderElement> data) {
        if (data == null || data.isEmpty()) {
            return;
        }
        this.fireDataCollectionEvent(new DataCollectionEvent(this, data, this), DataCollectionListener::dataRemoved);
        this.setModified(true);
    }

    @Override
    public boolean isParentOf(FolderElement child) {
        return child.getOwner() == this;
    }

    @Override
    public Folder getParent() {
        return null;
    }

    @Override
    public String getName() {
        return this.getProperties().getString("name", null);
    }

    @Override
    public void setParent(Folder parent) {
        if (parent != null) {
            throw new IllegalStateException("Unsupported");
        }
    }

    @Override
    public ChangedEvent<GraphDocument> getPropertyChangedEvent() {
        return this.propertyEvent;
    }

    public synchronized DocumentLock writeLock(String operationLabel, Callable<Boolean> cancel) {
        if (this.lock != null) {
            throw new LockedException("Document is locked by " + this.lock.getOperationLabel(), this.lock);
        }
        this.lock = new DocumentLock(operationLabel, cancel);
        return this.lock;
    }

    public final class DocumentLock
    implements AutoCloseable {
        private final String operationLabel;
        private final Callable<Boolean> cancelFunc;
        private boolean unlocked;

        public DocumentLock(String operationLabel, Callable<Boolean> cancelFunc) {
            this.operationLabel = operationLabel;
            this.cancelFunc = cancelFunc;
        }

        public String getOperationLabel() {
            return this.operationLabel;
        }

        @Override
        public void close() {
            this.unlock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unlock() {
            GraphDocument graphDocument = GraphDocument.this;
            synchronized (graphDocument) {
                if (this.unlocked) {
                    return;
                }
                if (GraphDocument.this.lock != this) {
                    throw new IllegalArgumentException("Not locked.");
                }
                this.unlocked = true;
                GraphDocument.this.trackModified = false;
                GraphDocument.this.lock = null;
            }
        }

        public void trackModifications(boolean track) {
            if (this.unlocked) {
                throw new IllegalStateException("No longer locked.");
            }
            GraphDocument.this.trackModified = track;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean cancel() {
            GraphDocument graphDocument = GraphDocument.this;
            synchronized (graphDocument) {
                if (GraphDocument.this.lock != this) {
                    return true;
                }
            }
            try {
                boolean status = this.cancelFunc.call();
                if (!status) {
                    return false;
                }
            }
            catch (Exception ex) {
                throw new IllegalStateException(ex);
            }
            GraphDocument graphDocument2 = GraphDocument.this;
            synchronized (graphDocument2) {
                return GraphDocument.this.lock != this;
            }
        }
    }

    public static final class LockedException
    extends RuntimeException {
        private final DocumentLock theLock;

        public LockedException(String message, DocumentLock theLock) {
            super(message);
            this.theLock = theLock;
        }

        public String getLockingOperation() {
            return this.theLock.getOperationLabel();
        }

        public boolean tryBreakLock() {
            return this.theLock.cancel();
        }
    }
}

