/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hightiercodegen.irwalk;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import jdk.graal.compiler.core.common.cfg.BlockMap;
import jdk.graal.compiler.core.common.cfg.Loop;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeMap;
import jdk.graal.compiler.hightiercodegen.CodeGenTool;
import jdk.graal.compiler.hightiercodegen.irwalk.BlockNestingVerifier;
import jdk.graal.compiler.hightiercodegen.irwalk.IRWalker;
import jdk.graal.compiler.hightiercodegen.reconstruction.ReconstructionData;
import jdk.graal.compiler.hightiercodegen.reconstruction.StackifierData;
import jdk.graal.compiler.hightiercodegen.reconstruction.stackifier.blocks.LabeledBlock;
import jdk.graal.compiler.hightiercodegen.reconstruction.stackifier.blocks.LabeledBlockGeneration;
import jdk.graal.compiler.hightiercodegen.reconstruction.stackifier.scopes.CatchScopeContainer;
import jdk.graal.compiler.hightiercodegen.reconstruction.stackifier.scopes.IfScopeContainer;
import jdk.graal.compiler.hightiercodegen.reconstruction.stackifier.scopes.LoopScopeContainer;
import jdk.graal.compiler.hightiercodegen.reconstruction.stackifier.scopes.Scope;
import jdk.graal.compiler.hightiercodegen.reconstruction.stackifier.scopes.SwitchScopeContainer;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.ControlSinkNode;
import jdk.graal.compiler.nodes.ControlSplitNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.LoopEndNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.WithExceptionNode;
import jdk.graal.compiler.nodes.cfg.ControlFlowGraph;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.nodes.extended.IntegerSwitchNode;
import jdk.graal.compiler.nodes.java.ExceptionObjectNode;
import jdk.graal.compiler.nodes.java.TypeSwitchNode;
import jdk.graal.compiler.replacements.nodes.BasicArrayCopyNode;
import jdk.vm.ci.meta.ResolvedJavaType;

public class StackifierIRWalker
extends IRWalker {
    public static final String LABEL_PREFIX = "looplabel_";
    protected final BlockNestingVerifier blockNestingVerifier = new BlockNestingVerifier();
    protected final StackifierData stackifierData;

    public StackifierIRWalker(CodeGenTool codeGenTool, ControlFlowGraph cfg, BlockMap<List<Node>> blockToNodeMap, NodeMap<HIRBlock> nodeToBlockMap, ReconstructionData reconstructionData) {
        super(codeGenTool, cfg, blockToNodeMap, nodeToBlockMap, reconstructionData);
        this.stackifierData = (StackifierData)reconstructionData;
    }

    @Override
    protected void lower(DebugContext debugContext) {
        this.stackifierData.debugDump(debugContext);
        this.predeclareVariables(this.cfg.graph);
        this.lowerBlocks(this.stackifierData.getBlocks());
    }

    protected void predeclareVariables(StructuredGraph graph) {
        for (AbstractMergeNode n : graph.getNodes(AbstractMergeNode.TYPE)) {
            for (PhiNode phi : n.phis()) {
                if (this.codeGenTool.nodeLowerer().actualUsageCount(phi) <= 0) continue;
                this.codeGenTool.nodeLowerer().lower(phi);
            }
        }
    }

    protected void lowerBlocks(HIRBlock[] blocks) {
        for (HIRBlock currentBlock : blocks) {
            Node node;
            Object blockEnd;
            if (this.blockHistory.blockVisited(currentBlock)) continue;
            boolean isLoopHeader = currentBlock.isLoopHeader();
            SortedSet<LabeledBlock> labeledBlockStartsBeforeLoop = LabeledBlockGeneration.getSortedSetByLabeledBlockEnd(this.stackifierData);
            SortedSet<LabeledBlock> labeledBlockStartsAfterLoop = LabeledBlockGeneration.getSortedSetByLabeledBlockEnd(this.stackifierData);
            SortedSet<LabeledBlock> blockStarts = this.stackifierData.labeledBlockStarts(currentBlock);
            if (blockStarts != null) {
                for (LabeledBlock forwardBlock : blockStarts) {
                    if (isLoopHeader && StackifierIRWalker.labeledBlockEndsInLoop((LoopScopeContainer)this.stackifierData.getScopeEntry(currentBlock.getBeginNode()), forwardBlock)) {
                        labeledBlockStartsAfterLoop.add(forwardBlock);
                        continue;
                    }
                    labeledBlockStartsBeforeLoop.add(forwardBlock);
                }
            }
            if (!StackifierIRWalker.isInRecursiveLoopCall(isLoopHeader, currentBlock, blocks)) {
                blockEnd = this.stackifierData.labeledBlockEnd(currentBlock);
                if (blockEnd != null) {
                    this.genLabeledBlockEnd((LabeledBlock)blockEnd);
                }
                labeledBlockStartsBeforeLoop.forEach(this::genLabeledBlockHeader);
            }
            if (StackifierIRWalker.newLoopStartsHere(isLoopHeader, currentBlock, blocks)) {
                this.lowerLoop(currentBlock);
                continue;
            }
            this.codeGenTool.genComment("Start of block " + String.valueOf(currentBlock));
            labeledBlockStartsAfterLoop.forEach(this::genLabeledBlockHeader);
            blockEnd = ((List)this.blockToNodeMap.get(currentBlock)).iterator();
            while (blockEnd.hasNext() && (node = (Node)blockEnd.next()) != currentBlock.getEndNode()) {
                if (node instanceof LoopBeginNode) {
                    assert (currentBlock == blocks[0]) : Assertions.errorMessage(currentBlock, blocks[0]);
                } else {
                    this.lowerNode(node);
                }
                this.verifier.visitNode(node, this.codeGenTool);
            }
            FixedNode lastNode = currentBlock.getEndNode();
            if (lastNode instanceof ControlSinkNode) {
                this.lowerNode(lastNode);
            } else if (lastNode instanceof IfNode) {
                IfNode ifNode = (IfNode)lastNode;
                this.lowerIf(currentBlock, ifNode);
            } else if (lastNode instanceof IntegerSwitchNode) {
                IntegerSwitchNode switchNode = (IntegerSwitchNode)lastNode;
                this.lowerSwitch(switchNode);
            } else if (lastNode instanceof TypeSwitchNode) {
                TypeSwitchNode switchNode = (TypeSwitchNode)lastNode;
                this.lowerTypeSwitch(switchNode);
            } else if (this.isWithExceptionNode(lastNode)) {
                this.lowerWithException(currentBlock, (WithExceptionNode)lastNode);
            } else if (lastNode instanceof ControlSplitNode && !(lastNode instanceof BasicArrayCopyNode)) {
                assert (false) : "Unsupported control split node " + String.valueOf(lastNode) + " is not implemented yet";
            } else if (lastNode instanceof LoopEndNode) {
                LoopEndNode loopEnd = (LoopEndNode)lastNode;
                this.lowerLoopEnd(loopEnd);
            } else {
                this.lowerUnhandledBlockEnd(currentBlock, lastNode);
            }
            this.verifier.visitNode(lastNode, this.codeGenTool);
            this.blockHistory.visitBlock(currentBlock);
            this.codeGenTool.genComment("End of block " + String.valueOf(currentBlock));
        }
    }

    private static boolean isInRecursiveLoopCall(boolean isLoopHeader, HIRBlock currenBlock, HIRBlock[] blocks) {
        return isLoopHeader && currenBlock == blocks[0];
    }

    private static boolean newLoopStartsHere(boolean isLoopHeader, HIRBlock currenBlock, HIRBlock[] blocks) {
        return isLoopHeader && currenBlock != blocks[0];
    }

    protected boolean isWithExceptionNode(Node lastNode) {
        return lastNode instanceof InvokeWithExceptionNode;
    }

    private void generateForwardJump(HIRBlock currentBlock, HIRBlock successor) {
        if (LabeledBlockGeneration.isNormalLoopExit(currentBlock, successor, this.stackifierData)) {
            Loop<HIRBlock> loop = currentBlock.getLoop();
            Scope loopScope = ((LoopScopeContainer)this.stackifierData.getScopeEntry(loop.getHeader().getBeginNode())).getLoopScope();
            Scope innerScope = (Scope)this.stackifierData.getEnclosingScope().get((Object)currentBlock);
            while (!innerScope.equals(loopScope) && !(innerScope.getStartBlock().getEndNode() instanceof IntegerSwitchNode)) {
                innerScope = innerScope.getParentScope();
            }
            if (innerScope.equals(loopScope) && !(currentBlock.getEndNode() instanceof IntegerSwitchNode)) {
                this.codeGenTool.genBreak();
            } else {
                this.codeGenTool.genBreak(this.getLabel(loop.getHeader()));
            }
        } else if (this.stackifierData.getLabeledBlockGeneration().isLabeledBlockNeeded(currentBlock, successor)) {
            LabeledBlock forwardBlock = this.stackifierData.labeledBlockEnd(successor);
            this.codeGenTool.genBreak(forwardBlock.getLabel());
        }
    }

    protected void lowerLoop(HIRBlock currentBlock) {
        assert (currentBlock.isLoopHeader());
        LoopScopeContainer loopScopeEntry = (LoopScopeContainer)this.stackifierData.getScopeEntry(currentBlock.getBeginNode());
        Scope loopScope = loopScopeEntry.getLoopScope();
        this.genLoopHeader(currentBlock);
        this.lowerBlocks(loopScope.getSortedBlocks(this.stackifierData));
        this.genLoopEnd(currentBlock);
    }

    protected void lowerLoopEnd(LoopEndNode loopEnd) {
        this.lowerLoopEndResolver(loopEnd);
        this.codeGenTool.genLoopContinue();
    }

    protected void lowerWithException(HIRBlock currentBlock, WithExceptionNode lastNode) {
        HIRBlock normSucc = this.cfg.blockFor(lastNode.next());
        HIRBlock excpSucc = this.cfg.blockFor(lastNode.exceptionEdge());
        CatchScopeContainer scopeEntry = (CatchScopeContainer)this.stackifierData.getScopeEntry(lastNode);
        Scope catchScope = scopeEntry.getCatchScope();
        this.codeGenTool.genTryBlock();
        this.lowerNode(lastNode);
        this.generateForwardJump(currentBlock, normSucc);
        String caughtObjectName = this.codeGenTool.getExceptionObjectId(excpSucc.getBeginNode());
        ResolvedJavaType caughtObjectType = this.codeGenTool.getProviders().getMetaAccess().lookupJavaType(Throwable.class);
        AbstractBeginNode abstractBeginNode = excpSucc.getBeginNode();
        if (abstractBeginNode instanceof ExceptionObjectNode) {
            ExceptionObjectNode excpObj = (ExceptionObjectNode)abstractBeginNode;
            caughtObjectType = excpObj.stamp(NodeView.DEFAULT).javaType(this.codeGenTool.getProviders().getMetaAccess());
        }
        this.codeGenTool.genCatchBlockPrefix(caughtObjectName, caughtObjectType);
        if (catchScope != null) {
            this.lowerBlocks(catchScope.getSortedBlocks(this.stackifierData));
        } else {
            this.generateForwardJump(currentBlock, excpSucc);
        }
        this.codeGenTool.genScopeEnd();
    }

    protected void lowerIfHeader(IfNode ifNode) {
        this.codeGenTool.genIfHeader(ifNode.condition());
    }

    protected void lowerIf(HIRBlock currentBlock, IfNode lastNode) {
        IfScopeContainer ifScopeContainer = (IfScopeContainer)this.stackifierData.getScopeEntry(lastNode);
        Scope thenScope = ifScopeContainer.getThenScope();
        Scope elseScope = ifScopeContainer.getElseScope();
        this.lowerIfHeader(lastNode);
        if (thenScope != null) {
            this.lowerBlocks(thenScope.getSortedBlocks(this.stackifierData));
        } else {
            HIRBlock trueBlock = (HIRBlock)this.nodeToBlockMap.get(lastNode.trueSuccessor());
            this.generateForwardJump(currentBlock, trueBlock);
        }
        this.codeGenTool.genElseHeader();
        if (elseScope != null) {
            this.lowerBlocks(elseScope.getSortedBlocks(this.stackifierData));
        } else {
            HIRBlock falseBlock = (HIRBlock)this.nodeToBlockMap.get(lastNode.falseSuccessor());
            this.generateForwardJump(currentBlock, falseBlock);
        }
        this.codeGenTool.genScopeEnd();
    }

    protected void lowerUnhandledBlockEnd(HIRBlock currentBlock, FixedNode lastNode) {
        if (!(lastNode instanceof LoopBeginNode)) {
            this.lowerNode(lastNode);
        }
        HIRBlock successor = (HIRBlock)this.nodeToBlockMap.get(lastNode.cfgSuccessors().iterator().next());
        this.generateForwardJump(currentBlock, successor);
    }

    public static boolean labeledBlockEndsInLoop(LoopScopeContainer loopScopeContainer, LabeledBlock labeledBlock) {
        HIRBlock labeledBlockEnd = labeledBlock.getEnd();
        return loopScopeContainer.getLoopScope().getBlocks().contains((Object)labeledBlockEnd);
    }

    protected void lowerSwitchCase(IntegerSwitchNode switchNode, AbstractBeginNode successor, int[] keys) {
        this.codeGenTool.genSwitchCase(keys);
    }

    protected void lowerSwitchDefaultCase(IntegerSwitchNode switchNode) {
        this.codeGenTool.genSwitchDefaultCase();
    }

    protected void lowerSwitch(IntegerSwitchNode switchNode) {
        this.codeGenTool.genSwitchHeader(switchNode.value());
        SwitchScopeContainer switchScopeEntry = (SwitchScopeContainer)this.stackifierData.getScopeEntry(switchNode);
        Scope[] caseScopes = switchScopeEntry.getCaseScopes();
        assert (caseScopes != null);
        for (int i = 0; i < switchNode.blockSuccessorCount(); ++i) {
            AbstractBeginNode succ = switchNode.blockSuccessor(i);
            if (succ.equals(switchNode.defaultSuccessor())) {
                this.lowerSwitchDefaultCase(switchNode);
            } else {
                ArrayList<Integer> succKeys = new ArrayList<Integer>();
                for (int keyIndex = 0; keyIndex < switchNode.keyCount(); ++keyIndex) {
                    int key = switchNode.intKeyAt(keyIndex);
                    AbstractBeginNode keySucc = switchNode.keySuccessor(keyIndex);
                    if (!succ.equals(keySucc)) continue;
                    succKeys.add(key);
                }
                assert (succKeys.size() > 0) : "no keys of " + String.valueOf(switchNode) + " have " + String.valueOf(succ) + " as block successor";
                int[] succk = new int[succKeys.size()];
                for (int s = 0; s < succKeys.size(); ++s) {
                    succk[s] = (Integer)succKeys.get(s);
                }
                this.lowerSwitchCase(switchNode, succ, succk);
            }
            if (caseScopes[i] != null) {
                this.lowerBlocks(caseScopes[i].getSortedBlocks(this.stackifierData));
            } else {
                this.generateForwardJump(this.cfg.blockFor(switchNode), this.cfg.blockFor(succ));
            }
            this.codeGenTool.genScopeEnd();
        }
        this.codeGenTool.genScopeEnd();
    }

    protected void lowerTypeSwitchCase(TypeSwitchNode switchNode, AbstractBeginNode succ, int succNum, List<ResolvedJavaType> succKeys) {
        GraalError.unimplementedParent();
    }

    protected void lowerTypeSwitchDefaultCase(TypeSwitchNode switchNode) {
        GraalError.unimplementedParent();
    }

    protected void lowerTypeSwitch(TypeSwitchNode switchNode) {
        for (int i = 0; i < switchNode.blockSuccessorCount(); ++i) {
            AbstractBeginNode succ = switchNode.blockSuccessor(i);
            if (succ.equals(switchNode.defaultSuccessor())) {
                this.lowerTypeSwitchDefaultCase(switchNode);
            } else {
                ArrayList<ResolvedJavaType> succKeys = new ArrayList<ResolvedJavaType>();
                for (int keyIndex = 0; keyIndex < switchNode.keyCount(); ++keyIndex) {
                    ResolvedJavaType key = switchNode.typeAt(keyIndex);
                    AbstractBeginNode keySucc = switchNode.keySuccessor(keyIndex);
                    if (!succ.equals(keySucc)) continue;
                    succKeys.add(key);
                }
                assert (succKeys.size() > 0) : "no keys of " + String.valueOf(switchNode) + " have " + String.valueOf(succ) + " as block successor";
                this.lowerTypeSwitchCase(switchNode, succ, i, succKeys);
            }
            this.generateForwardJump(this.cfg.blockFor(switchNode), this.cfg.blockFor(succ));
            this.codeGenTool.genBlockEndBreak();
            this.codeGenTool.genScopeEnd();
        }
    }

    protected void genLabeledBlockHeader(LabeledBlock labeledBlock) {
        this.blockNestingVerifier.pushLabel(labeledBlock);
        this.codeGenTool.genLabeledBlockHeader(labeledBlock.getLabel());
    }

    protected void genLabeledBlockEnd(LabeledBlock blockEnd) {
        this.blockNestingVerifier.popLabel(blockEnd);
        this.codeGenTool.genScopeEnd();
        this.codeGenTool.genComment("End of LabeledBlock " + blockEnd.getLabel());
    }

    private void genLoopHeader(HIRBlock block) {
        assert (block.isLoopHeader());
        String label = this.getLabel(block);
        this.blockNestingVerifier.pushLabel(label);
        this.codeGenTool.genLabel(label);
        this.codeGenTool.genWhileTrueHeader();
    }

    private void genLoopEnd(HIRBlock header) {
        assert (header.isLoopHeader());
        String label = this.getLabel(header);
        this.blockNestingVerifier.popLabel(label);
        this.codeGenTool.genBlockEndBreak();
        this.codeGenTool.genScopeEnd();
        this.codeGenTool.genComment("End of loop " + label);
    }

    private String getLabel(HIRBlock block) {
        assert (block.isLoopHeader());
        return LABEL_PREFIX + this.stackifierData.blockOrder(block);
    }
}

