/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hightiercodegen.lowerer;

import jdk.graal.compiler.hightiercodegen.CodeGenTool;
import jdk.graal.compiler.hightiercodegen.lowerer.MoveResolver;
import jdk.graal.compiler.nodes.AbstractEndNode;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.ValuePhiNode;

public class PhiResolveLowerer {
    protected final AbstractEndNode end;

    public PhiResolveLowerer(AbstractEndNode end) {
        this.end = end;
    }

    public MoveResolver.Schedule scheduleMoves(CodeGenTool codeGenTool) {
        AbstractMergeNode m = this.end.merge();
        MoveResolver<ValueNode, ValuePhiNode> moveResolver = new MoveResolver<ValueNode, ValuePhiNode>(m.valuePhis().snapshot());
        for (ValuePhiNode phi : m.valuePhis()) {
            if (codeGenTool.nodeLowerer().actualUsageCount(phi) <= 0) continue;
            assert (codeGenTool.getAllocatedVariable(phi) != null);
            ValueNode value = phi.valueAt(this.end);
            moveResolver.addMove(value, phi);
        }
        return moveResolver.scheduleMoves();
    }

    public void lower(CodeGenTool codeGenTool) {
        MoveResolver.Schedule schedule = this.scheduleMoves(codeGenTool);
        String tmpName = null;
        for (MoveResolver.Schedule.Move move : schedule.moves) {
            if (move.target == null) {
                if (tmpName == null) {
                    tmpName = "TEMP_" + codeGenTool.genUniqueID();
                    codeGenTool.genResolvedVarDeclPrefix(tmpName, (ValueNode)move.source);
                } else {
                    codeGenTool.genResolvedVarAssignmentPrefix(tmpName);
                }
                codeGenTool.lowerValue((ValueNode)move.source);
                codeGenTool.genResolvedVarDeclPostfix("TMP Move Phi Schedule");
                continue;
            }
            codeGenTool.lowerValue((ValueNode)move.target);
            codeGenTool.genAssignment();
            if (move.useTemporary) {
                assert (tmpName != null);
                codeGenTool.genResolvedVarAccess(tmpName);
            } else {
                codeGenTool.lowerValue((ValueNode)move.source);
            }
            codeGenTool.genResolvedVarDeclPostfix(null);
        }
    }
}

