/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hightiercodegen.reconstruction.stackifier.scopes;

import java.util.Arrays;
import java.util.Comparator;
import jdk.graal.compiler.hightiercodegen.reconstruction.StackifierData;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import org.graalvm.collections.EconomicSet;

public class Scope {
    protected final EconomicSet<HIRBlock> blocks;
    protected final HIRBlock startBlock;
    protected Scope parentScope;

    public Scope(EconomicSet<HIRBlock> blocks, HIRBlock startBlock) {
        this.blocks = blocks;
        this.startBlock = startBlock;
    }

    public EconomicSet<HIRBlock> getBlocks() {
        return this.blocks;
    }

    public HIRBlock[] getSortedBlocks(StackifierData stackifierData) {
        HIRBlock[] blockArray = (HIRBlock[])this.blocks.toArray((Object[])new HIRBlock[this.blocks.size()]);
        Arrays.sort(blockArray, Comparator.comparingInt(stackifierData::blockOrder));
        return blockArray;
    }

    public HIRBlock getLastBlock(StackifierData stackifierData) {
        HIRBlock last = (HIRBlock)this.blocks.iterator().next();
        for (HIRBlock b : this.blocks) {
            if (!stackifierData.isOrderedBefore(last, b)) continue;
            last = b;
        }
        return last;
    }

    public Scope getParentScope() {
        return this.parentScope;
    }

    public void setParentScope(Scope parentScope) {
        this.parentScope = parentScope;
    }

    public String toString() {
        StringBuilder sB = new StringBuilder("[ ");
        this.blocks.forEach(b -> sB.append(b.toString()).append(" "));
        sB.append("]");
        return sB.toString();
    }

    public HIRBlock getStartBlock() {
        return this.startBlock;
    }
}

