/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot;

import java.io.PrintStream;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.code.CompilationResult;
import jdk.graal.compiler.core.CompilationPrinter;
import jdk.graal.compiler.core.CompilationWatchDog;
import jdk.graal.compiler.core.CompilationWrapper;
import jdk.graal.compiler.core.GraalCompilerOptions;
import jdk.graal.compiler.core.common.CompilationIdentifier;
import jdk.graal.compiler.core.phases.HighTier;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.CounterKey;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.DebugDumpScope;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.debug.TTY;
import jdk.graal.compiler.debug.TimerKey;
import jdk.graal.compiler.hotspot.CompilationStatistics;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.HotSpotBackend;
import jdk.graal.compiler.hotspot.HotSpotCompilationIdentifier;
import jdk.graal.compiler.hotspot.HotSpotGraalCompiler;
import jdk.graal.compiler.hotspot.HotSpotGraalCompilerFactory;
import jdk.graal.compiler.hotspot.HotSpotGraalRuntimeProvider;
import jdk.graal.compiler.hotspot.HotSpotGraalServices;
import jdk.graal.compiler.hotspot.ProfileReplaySupport;
import jdk.graal.compiler.java.BytecodeParserOptions;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.spi.StableProfileProvider;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.options.OptionsParser;
import jdk.graal.compiler.printer.GraalDebugHandlersFactory;
import jdk.graal.compiler.serviceprovider.GraalServices;
import jdk.vm.ci.code.BailoutException;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.CompilationRequest;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.hotspot.HotSpotCompilationRequest;
import jdk.vm.ci.hotspot.HotSpotCompilationRequestResult;
import jdk.vm.ci.hotspot.HotSpotInstalledCode;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.services.Services;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;

public class CompilationTask
implements CompilationWatchDog.EventHandler {
    private final HotSpotJVMCIRuntime jvmciRuntime;
    protected final HotSpotGraalCompiler compiler;
    private final HotSpotCompilationIdentifier compilationId;
    private HotSpotInstalledCode installedCode;
    private final boolean installAsDefault;
    private final StableProfileProvider profileProvider;
    private final boolean shouldRetainLocalVariables;
    private final boolean shouldUsePreciseUnresolvedDeopts;
    private final boolean eagerResolving;
    private StableProfileProvider.TypeFilter profileSaveFilter;
    public static final TimerKey CompilationTime = DebugContext.timer("CompilationTime").doc("Time spent in compilation and code installation.");
    private static final CounterKey CompiledBytecodes = DebugContext.counter("CompiledBytecodes");
    public static final CounterKey CompiledAndInstalledBytecodes = DebugContext.counter("CompiledAndInstalledBytecodes");
    private static final CounterKey InstalledCodeSize = DebugContext.counter("InstalledCodeSize");
    public static final TimerKey CodeInstallationTime = DebugContext.timer("CodeInstallation");
    public static final TimerKey HintedFullGC = DebugContext.timer("HintedFullGC").doc("Time spent in hinted GC performed at the end of compilations.");

    @Override
    public void onStuckCompilation(CompilationWatchDog watchDog, Thread watched, CompilationIdentifier compilation, StackTraceElement[] stackTrace, int stuckTime) {
        CompilationWatchDog.EventHandler.super.onStuckCompilation(watchDog, watched, compilation, stackTrace, stuckTime);
        TTY.println("Compilation %s on %s appears stuck - exiting VM", compilation, watched);
        HotSpotGraalServices.exit(84, this.jvmciRuntime);
    }

    public CompilationTask(HotSpotJVMCIRuntime jvmciRuntime, HotSpotGraalCompiler compiler, HotSpotCompilationRequest request, boolean useProfilingInfo, boolean installAsDefault) {
        this(jvmciRuntime, compiler, request, useProfilingInfo, false, false, false, installAsDefault);
    }

    public CompilationTask(HotSpotJVMCIRuntime jvmciRuntime, HotSpotGraalCompiler compiler, HotSpotCompilationRequest request, boolean useProfilingInfo, boolean shouldRetainLocalVariables, boolean shouldUsePreciseUnresolvedDeopts, boolean installAsDefault) {
        this(jvmciRuntime, compiler, request, useProfilingInfo, shouldRetainLocalVariables, shouldUsePreciseUnresolvedDeopts, false, installAsDefault);
    }

    public CompilationTask(HotSpotJVMCIRuntime jvmciRuntime, HotSpotGraalCompiler compiler, HotSpotCompilationRequest request, boolean useProfilingInfo, boolean shouldRetainLocalVariables, boolean shouldUsePreciseUnresolvedDeopts, boolean eagerResolving, boolean installAsDefault) {
        this.jvmciRuntime = jvmciRuntime;
        this.compiler = compiler;
        this.compilationId = new HotSpotCompilationIdentifier(request);
        this.profileProvider = useProfilingInfo ? new StableProfileProvider() : null;
        this.shouldRetainLocalVariables = shouldRetainLocalVariables;
        this.shouldUsePreciseUnresolvedDeopts = shouldUsePreciseUnresolvedDeopts;
        this.eagerResolving = eagerResolving;
        this.installAsDefault = installAsDefault;
    }

    public void setTypeFilter(StableProfileProvider.TypeFilter typeFilter) {
        this.profileSaveFilter = typeFilter;
    }

    public OptionValues filterOptions(OptionValues options) {
        HotSpotGraalRuntimeProvider graalRuntime = this.compiler.getGraalRuntime();
        GraalHotSpotVMConfig config = graalRuntime.getVMConfig();
        OptionValues newOptions = options;
        if (!config.inline) {
            EconomicMap<OptionKey<?>, Object> m = OptionValues.newOptionMap();
            if (HighTier.Options.Inline.getValue(options).booleanValue() && !HighTier.Options.Inline.hasBeenSet(options)) {
                m.put(HighTier.Options.Inline, (Object)false);
            }
            if (BytecodeParserOptions.InlineDuringParsing.getValue(options).booleanValue() && !BytecodeParserOptions.InlineDuringParsing.hasBeenSet(options)) {
                m.put(BytecodeParserOptions.InlineDuringParsing, (Object)false);
            }
            if (!m.isEmpty()) {
                newOptions = new OptionValues(options, (UnmodifiableEconomicMap<OptionKey<?>, Object>)m);
            }
        }
        return newOptions;
    }

    public HotSpotResolvedJavaMethod getMethod() {
        return this.getRequest().getMethod();
    }

    CompilationIdentifier getCompilationIdentifier() {
        return this.compilationId;
    }

    public int getId() {
        return this.getRequest().getId();
    }

    public int getEntryBCI() {
        return this.getRequest().getEntryBCI();
    }

    public String getIdString() {
        if (this.getEntryBCI() != -1) {
            return this.getId() + "%";
        }
        return Integer.toString(this.getId());
    }

    public HotSpotInstalledCode getInstalledCode() {
        return this.installedCode;
    }

    public HotSpotCompilationRequestResult runCompilation(OptionValues initialOptions) {
        OptionValues options = this.filterOptions(initialOptions);
        HotSpotGraalRuntimeProvider graalRuntime = this.compiler.getGraalRuntime();
        try (DebugContext debug = graalRuntime.openDebugContext(options, this.compilationId, this.getMethod(), this.compiler.getDebugHandlersFactories(), DebugContext.getDefaultLogStream());){
            HotSpotCompilationRequestResult hotSpotCompilationRequestResult = this.runCompilation(debug);
            return hotSpotCompilationRequestResult;
        }
    }

    public HotSpotCompilationRequestResult runCompilation(DebugContext debug) {
        try (DebugCloseable a = CompilationTime.start(debug);){
            HotSpotCompilationRequestResult result = this.runCompilation(debug, new HotSpotCompilationWrapper());
            try (DebugCloseable timer = HintedFullGC.start(debug);){
                GraalServices.notifyLowMemoryPoint(Options.FullGCAfterCompile.getValue(debug.getOptions()));
            }
            HotSpotCompilationRequestResult hotSpotCompilationRequestResult = result;
            return hotSpotCompilationRequestResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HotSpotCompilationRequestResult runCompilation(DebugContext debug, HotSpotCompilationWrapper compilation) {
        HotSpotCompilationRequestResult hotSpotCompilationRequestResult;
        HotSpotGraalRuntimeProvider graalRuntime = this.compiler.getGraalRuntime();
        GraalHotSpotVMConfig config = graalRuntime.getVMConfig();
        int entryBCI = this.getEntryBCI();
        boolean isOSR = entryBCI != -1;
        HotSpotResolvedJavaMethod method = this.getMethod();
        if (this.installAsDefault || isOSR) {
            if (method.hasCodeAtLevel(entryBCI, config.compilationLevelFullOptimization)) {
                return HotSpotCompilationRequestResult.failure((String)"Already compiled", (boolean)false);
            }
            if (HotSpotGraalCompilerFactory.shouldExclude(method)) {
                return HotSpotCompilationRequestResult.failure((String)"GraalCompileOnly excluded", (boolean)false);
            }
        }
        ProfileReplaySupport result = ProfileReplaySupport.profileReplayPrologue(debug, graalRuntime.getHostProviders(), entryBCI, (ResolvedJavaMethod)method, this.profileProvider, this.profileSaveFilter);
        try {
            hotSpotCompilationRequestResult = (HotSpotCompilationRequestResult)compilation.run(debug);
        }
        catch (Throwable throwable) {
            try {
                if (compilation.result != null) {
                    int compiledBytecodes = compilation.result.getBytecodeSize();
                    CompiledBytecodes.add(debug, compiledBytecodes);
                    if (this.installedCode != null) {
                        int codeSize = this.installedCode.getSize();
                        CompiledAndInstalledBytecodes.add(debug, compiledBytecodes);
                        InstalledCodeSize.add(debug, codeSize);
                    }
                    if (result != null && result.getExpectedResult() != null && !result.getExpectedResult().booleanValue()) {
                        TTY.printf("Expected failure: %s %s%n", method.format("%H.%n(%P)%R"), entryBCI);
                    }
                }
                if (result != null) {
                    result.profileReplayEpilogue(debug, compilation.result, compilation.graph, this.profileProvider, this.compilationId, entryBCI, (ResolvedJavaMethod)method);
                }
            }
            catch (Throwable t) {
                return compilation.handleException(t);
            }
            throw throwable;
        }
        try {
            if (compilation.result != null) {
                int compiledBytecodes = compilation.result.getBytecodeSize();
                CompiledBytecodes.add(debug, compiledBytecodes);
                if (this.installedCode != null) {
                    int codeSize = this.installedCode.getSize();
                    CompiledAndInstalledBytecodes.add(debug, compiledBytecodes);
                    InstalledCodeSize.add(debug, codeSize);
                }
                if (result != null && result.getExpectedResult() != null && !result.getExpectedResult().booleanValue()) {
                    TTY.printf("Expected failure: %s %s%n", method.format("%H.%n(%P)%R"), entryBCI);
                }
            }
            if (result != null) {
                result.profileReplayEpilogue(debug, compilation.result, compilation.graph, this.profileProvider, this.compilationId, entryBCI, (ResolvedJavaMethod)method);
            }
        }
        catch (Throwable t) {
            return compilation.handleException(t);
        }
        return hotSpotCompilationRequestResult;
    }

    private void installMethod(DebugContext debug, StructuredGraph graph, CompilationResult compResult) {
        CodeCacheProvider codeCache = this.jvmciRuntime.getHostJVMCIBackend().getCodeCache();
        HotSpotBackend backend = this.compiler.getGraalRuntime().getHostBackend();
        this.installedCode = null;
        Object[] context = new Object[]{new DebugDumpScope(this.getIdString(), true), codeCache, this.getMethod(), compResult};
        try (DebugContext.Scope s = debug.scope("CodeInstall", context, graph);){
            HotSpotCompilationRequest request = this.getRequest();
            this.installedCode = (HotSpotInstalledCode)backend.createInstalledCode(debug, (ResolvedJavaMethod)request.getMethod(), (CompilationRequest)request, compResult, null, this.installAsDefault, context);
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
    }

    public String toString() {
        return "Compilation[id=" + this.getId() + ", " + this.getMethod().format("%H.%n(%p)") + (String)(this.getEntryBCI() == -1 ? "" : "@" + this.getEntryBCI()) + "]";
    }

    private HotSpotCompilationRequest getRequest() {
        return this.compilationId.getRequest();
    }

    protected class HotSpotCompilationWrapper
    extends CompilationWrapper<HotSpotCompilationRequestResult> {
        CompilationResult result;
        StructuredGraph graph;

        protected HotSpotCompilationWrapper() {
            super(CompilationTask.this.compiler.getGraalRuntime().getOutputDirectory(), CompilationTask.this.compiler.getGraalRuntime().getCompilationProblemsPerAction());
        }

        @Override
        protected DebugContext createRetryDebugContext(DebugContext initialDebug, OptionValues retryOptions, PrintStream logStream) {
            SnippetReflectionProvider snippetReflection = CompilationTask.this.compiler.getGraalRuntime().getHostProviders().getSnippetReflection();
            DebugContext.Description description = initialDebug.getDescription();
            GraalDebugHandlersFactory factory = new GraalDebugHandlersFactory(snippetReflection);
            return new DebugContext.Builder(retryOptions, factory).globalMetrics(initialDebug.getGlobalMetrics()).description(description).logStream(logStream).build();
        }

        @Override
        protected void exitHostVM(int status) {
            HotSpotGraalServices.exit(status, CompilationTask.this.jvmciRuntime);
        }

        @Override
        public String toString() {
            return CompilationTask.this.getMethod().format("%H.%n(%p) @ " + CompilationTask.this.getEntryBCI());
        }

        @Override
        protected void parseRetryOptions(String[] options, EconomicMap<OptionKey<?>, Object> values) {
            OptionsParser.parseOptions(options, values, OptionsParser.getOptionsLoader());
        }

        @Override
        protected HotSpotCompilationRequestResult handleException(Throwable t) {
            if (t instanceof BailoutException) {
                BailoutException bailout = (BailoutException)t;
                return HotSpotCompilationRequestResult.failure((String)bailout.getMessage(), (!bailout.isPermanent() ? 1 : 0) != 0);
            }
            return HotSpotCompilationRequestResult.failure((String)t.toString(), (boolean)false);
        }

        @Override
        protected void dumpOnError(DebugContext errorContext, Throwable cause) {
            if (this.graph != null) {
                try (DebugContext.Scope s = errorContext.scope("DumpOnError", this.graph, new DebugDumpScope(CompilationTask.this.getIdString(), true), new DebugDumpScope("Original failure"));){
                    errorContext.forceDump(this.graph, "Exception: %s", cause);
                }
                catch (Throwable t) {
                    throw errorContext.handle(t);
                }
            }
        }

        @Override
        protected CompilationWrapper.ExceptionAction lookupAction(OptionValues values, Throwable cause) {
            if (cause instanceof BailoutException) {
                BailoutException bailout = (BailoutException)cause;
                if (bailout.isPermanent() && !GraalCompilerOptions.CompilationBailoutAsFailure.hasBeenSet(values) && CompilationTask.this.compiler.getGraalRuntime().isBootstrapping()) {
                    return CompilationWrapper.ExceptionAction.Diagnose;
                }
                if (!GraalCompilerOptions.CompilationBailoutAsFailure.getValue(values).booleanValue()) {
                    return super.lookupAction(values, cause);
                }
            }
            if (!GraalCompilerOptions.CompilationFailureAction.hasBeenSet(values)) {
                if (CompilationTask.this.compiler.getGraalRuntime().isBootstrapping()) {
                    TTY.println("Treating CompilationFailureAction as ExitVM due to exception throw during bootstrap: " + String.valueOf(cause));
                    return CompilationWrapper.ExceptionAction.ExitVM;
                }
                if (Services.IS_IN_NATIVE_IMAGE && (cause instanceof AssertionError || cause instanceof GraalError) && Assertions.assertionsEnabled()) {
                    TTY.println("Treating CompilationFailureAction as ExitVM due to assertion failure in libgraal: " + String.valueOf(cause));
                    return CompilationWrapper.ExceptionAction.ExitVM;
                }
            }
            return super.lookupAction(values, cause);
        }

        @Override
        protected HotSpotCompilationRequestResult performCompilation(DebugContext debug) {
            HotSpotResolvedJavaMethod method = CompilationTask.this.getMethod();
            int entryBCI = CompilationTask.this.getEntryBCI();
            boolean isOSR = entryBCI != -1;
            CompilationStatistics stats = CompilationStatistics.create(debug.getOptions(), method, isOSR);
            CompilationPrinter printer = CompilationPrinter.begin(debug.getOptions(), CompilationTask.this.compilationId, method, entryBCI);
            try (DebugContext.Scope s = debug.scope((Object)"Compiling", new DebugDumpScope(CompilationTask.this.getIdString(), true));){
                this.graph = CompilationTask.this.compiler.createGraph((ResolvedJavaMethod)method, entryBCI, CompilationTask.this.profileProvider, CompilationTask.this.compilationId, debug.getOptions(), debug);
                this.result = CompilationTask.this.compiler.compile(this.graph, CompilationTask.this.shouldRetainLocalVariables, CompilationTask.this.shouldUsePreciseUnresolvedDeopts, CompilationTask.this.eagerResolving, CompilationTask.this.compilationId, debug);
            }
            catch (Throwable e) {
                throw debug.handle(e);
            }
            try (DebugCloseable b = CodeInstallationTime.start(debug);){
                CompilationTask.this.installMethod(debug, this.graph, this.result);
            }
            printer.finish(this.result, (InstalledCode)CompilationTask.this.installedCode);
            stats.finish(method, CompilationTask.this.installedCode);
            ResolvedJavaMethod rootMethod = this.result.getMethods()[0];
            int inlinedBytecodes = this.result.getBytecodeSize() - rootMethod.getCodeSize();
            assert (inlinedBytecodes >= 0) : String.valueOf(rootMethod) + " " + String.valueOf(method);
            return HotSpotCompilationRequestResult.success((int)inlinedBytecodes);
        }
    }

    static class Options {
        public static final OptionKey<Boolean> FullGCAfterCompile = new OptionKey<Boolean>(false);

        Options() {
        }
    }
}

