/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.JVMCIVersionCheck;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.hotspot.HotSpotVMConfigAccess;
import jdk.vm.ci.hotspot.HotSpotVMConfigStore;
import jdk.vm.ci.hotspot.VMField;
import jdk.vm.ci.services.Services;

public class GraalHotSpotVMConfigAccess {
    protected final HotSpotVMConfigAccess access;
    private final Map<String, Long> vmAddresses;
    private final Map<String, Long> vmConstants;
    private final Map<String, VMField> vmFields;
    public static final Set<String> KNOWN_ARCHITECTURES = new HashSet<String>(Arrays.asList("amd64", "aarch64", "riscv64"));
    public static final Set<String> KNOWN_OS_NAMES = new HashSet<String>(Arrays.asList("windows", "linux", "darwin"));
    public final String osName;
    public final String osArch;
    public static final int JDK = Runtime.version().feature();
    public static final JVMCIVersionCheck.Version JVMCI_VERSION;
    public static final boolean JVMCI;
    public static final boolean JDK_PRERELEASE;
    private final List<String> missing = new ArrayList<String>();
    private final List<String> unexpected = new ArrayList<String>();
    private boolean deferErrors = this instanceof GraalHotSpotVMConfig;
    private static final String JVMCI_CONFIG_CHECK_PROP_NAME = "debug.jdk.graal.jvmciConfigCheck";

    GraalHotSpotVMConfigAccess(HotSpotVMConfigStore store) {
        String value;
        this.access = new HotSpotVMConfigAccess(store);
        this.vmAddresses = store.getAddresses();
        this.vmConstants = store.getConstants();
        this.vmFields = store.getFields();
        switch (value = Services.getSavedProperty((String)"os.name")) {
            case "Linux": {
                value = "linux";
                break;
            }
            case "SunOS": {
                value = "solaris";
                break;
            }
            case "Mac OS X": {
                value = "darwin";
                break;
            }
            default: {
                if (value.startsWith("Windows")) {
                    value = "windows";
                    break;
                }
                throw new JVMCIError("Unexpected OS name: " + value);
            }
        }
        assert (KNOWN_OS_NAMES.contains(value));
        this.osName = value;
        String arch = switch (arch = Services.getSavedProperty((String)"os.arch")) {
            case "x86_64" -> "amd64";
        };
        this.osArch = arch;
        assert (KNOWN_ARCHITECTURES.contains(arch)) : arch;
    }

    public HotSpotVMConfigStore getStore() {
        return this.access.getStore();
    }

    public static boolean jvmciGE(JVMCIVersionCheck.Version v) {
        return JVMCI && !JVMCI_VERSION.isLessThan(v);
    }

    private boolean isPresent(String name, Map<String, ?> map, boolean expectPresent) {
        if (map.containsKey(name)) {
            if (!expectPresent) {
                this.recordError(name, this.unexpected, String.valueOf(map.get(name)));
            }
            return true;
        }
        if (expectPresent) {
            this.recordError(name, this.missing, null);
        }
        return false;
    }

    private void recordError(String name, List<String> list, String unexpectedValue) {
        if (JDK_PRERELEASE) {
            return;
        }
        Object message = name;
        if (this.deferErrors) {
            StackTraceElement[] trace;
            for (StackTraceElement e : trace = new Exception().getStackTrace()) {
                if (e.getClassName().equals(GraalHotSpotVMConfigAccess.class.getName()) || !e.getMethodName().equals("<init>")) continue;
                message = (String)message + " at " + String.valueOf(e);
                break;
            }
        }
        if (unexpectedValue != null) {
            message = (String)message + " [value: " + unexpectedValue + "]";
        }
        list.add((String)message);
        if (!this.deferErrors) {
            this.reportErrors();
        }
    }

    protected void reportErrors() {
        this.deferErrors = false;
        if (!this.missing.isEmpty() || !this.unexpected.isEmpty()) {
            String jvmci = JVMCI_VERSION == null ? "" : " jvmci-" + String.valueOf(JVMCI_VERSION);
            String runtime = String.format("JDK %d%s %s-%s (java.home=%s, java.vm.name=%s, java.vm.version=%s)", JDK, jvmci, this.osName, this.osArch, Services.getSavedProperty((String)"java.home"), Services.getSavedProperty((String)"java.vm.name"), Services.getSavedProperty((String)"java.vm.version"));
            ArrayList<String> messages = new ArrayList<String>();
            if (!this.missing.isEmpty()) {
                messages.add(String.format("VM config values missing that should be present in %s:%n    %s", runtime, this.missing.stream().sorted().collect(Collectors.joining(System.lineSeparator() + "    "))));
            }
            if (!this.unexpected.isEmpty()) {
                messages.add(String.format("VM config values not expected to be present in %s:%n    %s", runtime, this.unexpected.stream().sorted().collect(Collectors.joining(System.lineSeparator() + "    "))));
            }
            GraalHotSpotVMConfigAccess.reportError(String.join((CharSequence)System.lineSeparator(), messages));
        }
    }

    static void reportError(String rawErrorMessage) {
        String value = Services.getSavedProperty((String)JVMCI_CONFIG_CHECK_PROP_NAME);
        if (!JVMCI && value == null) {
            value = "ignore";
        }
        if ("ignore".equals(value)) {
            return;
        }
        boolean warn = "warn".equals(value) || JDK_PRERELEASE;
        Formatter message = new Formatter().format(rawErrorMessage, new Object[0]);
        String javaHome = Services.getSavedProperty((String)"java.home");
        String vmName = Services.getSavedProperty((String)"java.vm.name");
        if (warn) {
            message.format("%nSet the %s system property to \"ignore\" to suppress ", JVMCI_CONFIG_CHECK_PROP_NAME);
            message.format("this warning and continue execution.%n", new Object[0]);
        } else {
            message.format("%nSet the %s system property to \"ignore\" to suppress ", JVMCI_CONFIG_CHECK_PROP_NAME);
            message.format("this error or to \"warn\" to emit a warning and continue execution.%n", new Object[0]);
        }
        message.format("Currently used Java home directory is %s.%n", javaHome);
        message.format("Currently used VM configuration is: %s%n", vmName);
        if (!warn) {
            throw new JVMCIError(message.toString());
        }
        System.err.println(message.toString());
    }

    public long getAddress(String name, Long notPresent, boolean expectPresent) {
        if (this.isPresent(name, this.vmAddresses, expectPresent)) {
            return this.access.getAddress(name, notPresent);
        }
        return notPresent;
    }

    public long getAddress(String name) {
        if (this.isPresent(name, this.vmAddresses, true)) {
            return this.access.getAddress(name, Long.valueOf(0L));
        }
        return 0L;
    }

    public <T> T getConstant(String name, Class<T> type, T notPresent, boolean expectPresent) {
        if (this.isPresent(name, this.vmConstants, expectPresent)) {
            return (T)this.access.getConstant(name, type, notPresent);
        }
        return notPresent;
    }

    public <T> T verifyConstant(String name, Class<T> type, T expect) {
        Object value;
        if (this.vmConstants.containsKey(name) && !Objects.equals(value = this.access.getConstant(name, type, expect), expect)) {
            this.recordError(name, this.unexpected, String.valueOf(value));
        }
        return expect;
    }

    public <T> T getConstant(String name, Class<T> type) {
        if (this.isPresent(name, this.vmConstants, true)) {
            return (T)this.access.getConstant(name, type);
        }
        return GraalHotSpotVMConfigAccess.getDefault(type);
    }

    public <T> T getFieldOffset(String name, Class<T> type, String cppType, T notPresent, boolean expectPresent) {
        if (this.isPresent(name, this.vmFields, expectPresent)) {
            return (T)this.access.getFieldOffset(name, type, cppType, notPresent);
        }
        return notPresent;
    }

    public <T> T getFieldOffset(String name, Class<T> type, String cppType) {
        if (this.isPresent(name, this.vmFields, true)) {
            return (T)this.access.getFieldOffset(name, type, cppType);
        }
        return GraalHotSpotVMConfigAccess.getDefault(type);
    }

    public <T> T getFieldOffset(String name, Class<T> type) {
        if (this.isPresent(name, this.vmFields, true)) {
            return (T)this.access.getFieldOffset(name, type);
        }
        return GraalHotSpotVMConfigAccess.getDefault(type);
    }

    public long getFieldAddress(String name, String cppType) {
        if (this.isPresent(name, this.vmFields, true)) {
            return this.access.getFieldAddress(name, cppType);
        }
        return 0L;
    }

    public long getFieldAddress(String name, String cppType, long notPresent, boolean expectPresent) {
        if (this.isPresent(name, this.vmFields, expectPresent)) {
            return this.access.getFieldAddress(name, cppType);
        }
        return notPresent;
    }

    public <T> T getFieldValue(String name, Class<T> type, String cppType, T notPresent, boolean expectPresent) {
        if (this.isPresent(name, this.vmFields, expectPresent)) {
            return (T)this.access.getFieldValue(name, type, cppType, notPresent);
        }
        return notPresent;
    }

    public <T> T getFieldValue(String name, Class<T> type, String cppType) {
        if (this.isPresent(name, this.vmFields, true)) {
            return (T)this.access.getFieldValue(name, type, cppType);
        }
        return GraalHotSpotVMConfigAccess.getDefault(type);
    }

    public <T> T getFieldValue(String name, Class<T> type) {
        if (this.isPresent(name, this.vmFields, true)) {
            return (T)this.access.getFieldValue(name, type);
        }
        return GraalHotSpotVMConfigAccess.getDefault(type);
    }

    public <T> T getFlag(String name, Class<T> type) {
        try {
            return (T)this.access.getFlag(name, type);
        }
        catch (JVMCIError e) {
            this.recordError(name, this.missing, null);
            return GraalHotSpotVMConfigAccess.getDefault(type);
        }
    }

    public <T> T getFlag(String name, Class<T> type, T notPresent, boolean expectPresent) {
        if (expectPresent) {
            return this.getFlag(name, type);
        }
        if (Assertions.assertionsEnabled()) {
            try {
                Object value = this.access.getFlag(name, type, null);
                this.recordError(name, this.unexpected, String.valueOf(value));
            }
            catch (JVMCIError jVMCIError) {
                // empty catch block
            }
        }
        return (T)this.access.getFlag(name, type, notPresent);
    }

    private static <T> T getDefault(Class<T> type) {
        if (type == Boolean.class) {
            return type.cast(Boolean.FALSE);
        }
        if (type == Byte.class) {
            return type.cast((byte)0);
        }
        if (type == Integer.class) {
            return type.cast(0);
        }
        if (type == Long.class) {
            return type.cast(0L);
        }
        if (type == String.class) {
            return type.cast(null);
        }
        throw new JVMCIError("Unsupported VM config value type: " + type.getName());
    }

    static {
        String vmVersion = Services.getSavedProperty((String)"java.vm.version");
        JVMCI_VERSION = JVMCIVersionCheck.Version.parse(vmVersion);
        JDK_PRERELEASE = vmVersion.contains("SNAPSHOT") || vmVersion.contains("-dev");
        JVMCI = JVMCI_VERSION != null;
    }
}

