/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot;

import jdk.graal.compiler.bytecode.BytecodeProvider;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.HotSpotBackend;
import jdk.graal.compiler.hotspot.HotSpotGraalRuntime;
import jdk.graal.compiler.hotspot.HotSpotGraalRuntimeProvider;
import jdk.graal.compiler.hotspot.HotSpotReplacementsImpl;
import jdk.graal.compiler.hotspot.HotSpotSnippetMetaAccessProvider;
import jdk.graal.compiler.hotspot.HotSpotZBarrierSet;
import jdk.graal.compiler.hotspot.SnippetSignature;
import jdk.graal.compiler.hotspot.meta.HotSpotGraalConstantFieldProvider;
import jdk.graal.compiler.hotspot.meta.HotSpotHostForeignCallsProvider;
import jdk.graal.compiler.hotspot.meta.HotSpotIdentityHashCodeProvider;
import jdk.graal.compiler.hotspot.meta.HotSpotLoweringProvider;
import jdk.graal.compiler.hotspot.meta.HotSpotMetaAccessExtensionProvider;
import jdk.graal.compiler.hotspot.meta.HotSpotPlatformConfigurationProvider;
import jdk.graal.compiler.hotspot.meta.HotSpotProviders;
import jdk.graal.compiler.hotspot.meta.HotSpotRegistersProvider;
import jdk.graal.compiler.hotspot.meta.HotSpotSnippetReflectionProvider;
import jdk.graal.compiler.hotspot.meta.HotSpotStampProvider;
import jdk.graal.compiler.hotspot.meta.HotSpotSuitesProvider;
import jdk.graal.compiler.hotspot.nodes.HotSpotCompressionNode;
import jdk.graal.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import jdk.graal.compiler.hotspot.word.HotSpotWordTypes;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.ArrayRangeWrite;
import jdk.graal.compiler.nodes.gc.BarrierSet;
import jdk.graal.compiler.nodes.gc.CardTableBarrierSet;
import jdk.graal.compiler.nodes.gc.G1BarrierSet;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.java.AbstractNewObjectNode;
import jdk.graal.compiler.nodes.loop.LoopsDataProviderImpl;
import jdk.graal.compiler.nodes.memory.FixedAccessNode;
import jdk.graal.compiler.nodes.spi.IdentityHashCodeProvider;
import jdk.graal.compiler.nodes.spi.LoopsDataProvider;
import jdk.graal.compiler.nodes.spi.Replacements;
import jdk.graal.compiler.nodes.type.NarrowOopStamp;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.tiers.CompilerConfiguration;
import jdk.graal.compiler.replacements.classfile.ClassfileBytecodeProvider;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.common.InitTimer;
import jdk.vm.ci.hotspot.HotSpotCodeCacheProvider;
import jdk.vm.ci.hotspot.HotSpotConstantReflectionProvider;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.runtime.JVMCIBackend;
import jdk.vm.ci.services.Services;

public abstract class HotSpotBackendFactory {
    protected HotSpotGraalConstantFieldProvider createConstantFieldProvider(GraalHotSpotVMConfig config, MetaAccessProvider metaAccess) {
        return new HotSpotGraalConstantFieldProvider(config, metaAccess);
    }

    protected HotSpotWordTypes createWordTypes(MetaAccessProvider metaAccess, TargetDescription target) {
        return new HotSpotWordTypes(HotSpotReplacementsImpl.noticeTypes(metaAccess), target.wordJavaKind);
    }

    protected HotSpotStampProvider createStampProvider() {
        return new HotSpotStampProvider();
    }

    protected HotSpotPlatformConfigurationProvider createConfigInfoProvider(GraalHotSpotVMConfig config, BarrierSet barrierSet) {
        return new HotSpotPlatformConfigurationProvider(config, barrierSet);
    }

    protected HotSpotMetaAccessExtensionProvider createMetaAccessExtensionProvider() {
        return new HotSpotMetaAccessExtensionProvider();
    }

    protected HotSpotReplacementsImpl createReplacements(TargetDescription target, HotSpotProviders p, BytecodeProvider bytecodeProvider) {
        return new HotSpotReplacementsImpl(p, bytecodeProvider, target);
    }

    protected ClassfileBytecodeProvider createBytecodeProvider(MetaAccessProvider metaAccess, HotSpotSnippetReflectionProvider snippetReflection) {
        return new ClassfileBytecodeProvider(metaAccess, snippetReflection);
    }

    protected HotSpotSnippetReflectionProvider createSnippetReflection(HotSpotGraalRuntimeProvider runtime, HotSpotConstantReflectionProvider constantReflection, HotSpotWordTypes wordTypes) {
        return new HotSpotSnippetReflectionProvider(runtime, constantReflection, wordTypes);
    }

    public abstract String getName();

    public abstract Class<? extends Architecture> getArchitecture();

    protected LoopsDataProvider createLoopsDataProvider() {
        return new LoopsDataProviderImpl();
    }

    public final HotSpotBackend createBackend(HotSpotGraalRuntimeProvider graalRuntime, CompilerConfiguration compilerConfiguration, HotSpotJVMCIRuntime jvmciRuntime, HotSpotBackend host) {
        HotSpotProviders providers;
        assert (host == null);
        OptionValues options = graalRuntime.getOptions();
        JVMCIBackend jvmci = jvmciRuntime.getHostJVMCIBackend();
        GraalHotSpotVMConfig config = graalRuntime.getVMConfig();
        if (Services.IS_BUILDING_NATIVE_IMAGE || Services.IS_IN_NATIVE_IMAGE) {
            SnippetSignature.initPrimitiveKindCache(jvmci.getMetaAccess());
        }
        HotSpotCodeCacheProvider codeCache = (HotSpotCodeCacheProvider)jvmci.getCodeCache();
        TargetDescription target = codeCache.getTarget();
        HotSpotSnippetMetaAccessProvider metaAccess = new HotSpotSnippetMetaAccessProvider(jvmci.getMetaAccess());
        HotSpotConstantReflectionProvider constantReflection = (HotSpotConstantReflectionProvider)jvmci.getConstantReflection();
        HotSpotGraalConstantFieldProvider constantFieldProvider = new HotSpotGraalConstantFieldProvider(config, metaAccess);
        try (InitTimer t = InitTimer.timer((String)"create providers");){
            GraphBuilderConfiguration.Plugins plugins;
            HotSpotReplacementsImpl replacements;
            IdentityHashCodeProvider identityHashCodeProvider;
            ClassfileBytecodeProvider bytecodeProvider;
            HotSpotSnippetReflectionProvider snippetReflection;
            LoopsDataProvider loopsDataProvider;
            HotSpotLoweringProvider lowerer;
            HotSpotStampProvider stampProvider;
            HotSpotMetaAccessExtensionProvider metaAccessExtensionProvider;
            HotSpotPlatformConfigurationProvider platformConfigurationProvider;
            HotSpotHostForeignCallsProvider foreignCalls;
            HotSpotWordTypes wordTypes;
            Value[] nativeABICallerSaveRegisters;
            HotSpotRegistersProvider registers;
            try (InitTimer rt = InitTimer.timer((String)"create HotSpotRegisters provider");){
                registers = this.createRegisters();
            }
            try (InitTimer rt = InitTimer.timer((String)"create NativeABICallerSaveRegisters");){
                nativeABICallerSaveRegisters = this.createNativeABICallerSaveRegisters(config, codeCache.getRegisterConfig());
            }
            try (InitTimer rt = InitTimer.timer((String)"create WordTypes");){
                wordTypes = this.createWordTypes(metaAccess, target);
            }
            try (InitTimer rt = InitTimer.timer((String)"create ForeignCalls provider");){
                foreignCalls = this.createForeignCalls(jvmciRuntime, graalRuntime, metaAccess, codeCache, wordTypes, nativeABICallerSaveRegisters);
            }
            BarrierSet barrierSet = this.createBarrierSet(config, metaAccess);
            try (InitTimer rt = InitTimer.timer((String)"create platform configuration provider");){
                platformConfigurationProvider = this.createConfigInfoProvider(config, barrierSet);
            }
            try (InitTimer rt = InitTimer.timer((String)"create MetaAccessExtensionProvider");){
                metaAccessExtensionProvider = this.createMetaAccessExtensionProvider();
            }
            try (InitTimer rt = InitTimer.timer((String)"create stamp provider");){
                stampProvider = this.createStampProvider();
            }
            try (InitTimer rt = InitTimer.timer((String)"create Lowerer provider");){
                lowerer = this.createLowerer(graalRuntime, metaAccess, foreignCalls, registers, constantReflection, platformConfigurationProvider, metaAccessExtensionProvider, target);
            }
            try (InitTimer rt = InitTimer.timer((String)"create loopsdata provider");){
                loopsDataProvider = this.createLoopsDataProvider();
            }
            try (InitTimer rt = InitTimer.timer((String)"create SnippetReflection provider");){
                snippetReflection = this.createSnippetReflection(graalRuntime, constantReflection, wordTypes);
            }
            try (InitTimer rt = InitTimer.timer((String)"create Bytecode provider");){
                bytecodeProvider = this.createBytecodeProvider(metaAccess, snippetReflection);
            }
            try (InitTimer rt = InitTimer.timer((String)"create IdentityHashCode provider");){
                identityHashCodeProvider = this.createIdentityHashCodeProvider();
            }
            providers = new HotSpotProviders(metaAccess, codeCache, (ConstantReflectionProvider)constantReflection, constantFieldProvider, foreignCalls, lowerer, null, null, registers, snippetReflection, wordTypes, stampProvider, platformConfigurationProvider, metaAccessExtensionProvider, loopsDataProvider, config, identityHashCodeProvider);
            try (InitTimer rt = InitTimer.timer((String)"create Replacements provider");){
                replacements = this.createReplacements(target, providers, bytecodeProvider);
                providers = replacements.getProviders();
                replacements.maybeInitializeEncoder();
            }
            try (InitTimer rt = InitTimer.timer((String)"create GraphBuilderPhase plugins");){
                plugins = this.createGraphBuilderPlugins(graalRuntime, compilerConfiguration, config, target, constantReflection, foreignCalls, metaAccess, snippetReflection, replacements, wordTypes, options, barrierSet);
                replacements.setGraphBuilderPlugins(plugins);
            }
            rt = InitTimer.timer((String)"create Suites provider");
            try {
                HotSpotSuitesProvider suites = this.createSuites(config, graalRuntime, compilerConfiguration, plugins, registers, replacements, options);
                providers.setSuites(suites);
            }
            finally {
                if (rt != null) {
                    rt.close();
                }
            }
            Replacements replacements2 = replacements.getProviders().getReplacements();
            assert (replacements == replacements2) : Assertions.errorMessageContext("replacements", replacements, "replacements2", replacements2);
            GraphBuilderConfiguration.Plugins plugins2 = providers.getGraphBuilderPlugins();
            assert (plugins2 == plugins) : Assertions.errorMessageContext("plugins", plugins, "plugins2", plugins2);
        }
        try (InitTimer rt = InitTimer.timer((String)"instantiate backend");){
            HotSpotBackend hotSpotBackend = this.createBackend(config, graalRuntime, providers);
            return hotSpotBackend;
        }
    }

    protected IdentityHashCodeProvider createIdentityHashCodeProvider() {
        return new HotSpotIdentityHashCodeProvider();
    }

    protected abstract HotSpotBackend createBackend(GraalHotSpotVMConfig var1, HotSpotGraalRuntimeProvider var2, HotSpotProviders var3);

    protected abstract Value[] createNativeABICallerSaveRegisters(GraalHotSpotVMConfig var1, RegisterConfig var2);

    protected abstract GraphBuilderConfiguration.Plugins createGraphBuilderPlugins(HotSpotGraalRuntimeProvider var1, CompilerConfiguration var2, GraalHotSpotVMConfig var3, TargetDescription var4, HotSpotConstantReflectionProvider var5, HotSpotHostForeignCallsProvider var6, MetaAccessProvider var7, HotSpotSnippetReflectionProvider var8, HotSpotReplacementsImpl var9, HotSpotWordTypes var10, OptionValues var11, BarrierSet var12);

    protected abstract HotSpotSuitesProvider createSuites(GraalHotSpotVMConfig var1, HotSpotGraalRuntimeProvider var2, CompilerConfiguration var3, GraphBuilderConfiguration.Plugins var4, HotSpotRegistersProvider var5, HotSpotReplacementsImpl var6, OptionValues var7);

    protected abstract HotSpotRegistersProvider createRegisters();

    protected abstract HotSpotLoweringProvider createLowerer(HotSpotGraalRuntimeProvider var1, MetaAccessProvider var2, HotSpotHostForeignCallsProvider var3, HotSpotRegistersProvider var4, HotSpotConstantReflectionProvider var5, HotSpotPlatformConfigurationProvider var6, HotSpotMetaAccessExtensionProvider var7, TargetDescription var8);

    protected abstract HotSpotHostForeignCallsProvider createForeignCalls(HotSpotJVMCIRuntime var1, HotSpotGraalRuntimeProvider var2, MetaAccessProvider var3, HotSpotCodeCacheProvider var4, HotSpotWordTypes var5, Value[] var6);

    private BarrierSet createBarrierSet(final GraalHotSpotVMConfig config, MetaAccessProvider metaAccess) {
        final boolean useDeferredInitBarriers = config.useDeferredInitBarriers;
        ResolvedJavaType objectArrayType = metaAccess.lookupJavaType(Object[].class);
        if (config.gc == HotSpotGraalRuntime.HotSpotGC.Z) {
            ResolvedJavaField referentField = HotSpotReplacementsUtil.referentField(metaAccess);
            return new HotSpotZBarrierSet(referentField);
        }
        if (config.useG1GC()) {
            ResolvedJavaField referentField = HotSpotReplacementsUtil.referentField(metaAccess);
            return new G1BarrierSet(this, objectArrayType, referentField){
                final /* synthetic */ HotSpotBackendFactory this$0;
                {
                    this.this$0 = this$0;
                    super(objectArrayType, referentField);
                }

                @Override
                protected boolean writeRequiresPostBarrier(FixedAccessNode node, ValueNode writtenValue) {
                    if (!super.writeRequiresPostBarrier(node, writtenValue)) {
                        return false;
                    }
                    return !useDeferredInitBarriers || !this.this$0.isWriteToNewObject(node);
                }

                @Override
                protected boolean arrayRangeWriteRequiresPostBarrier(ArrayRangeWrite write) {
                    if (!super.arrayRangeWriteRequiresPostBarrier(write)) {
                        return false;
                    }
                    return !useDeferredInitBarriers || !this.this$0.isWriteToNewObject(write.asFixedWithNextNode(), write.getAddress().getBase());
                }

                @Override
                protected ValueNode maybeUncompressExpectedValue(ValueNode value) {
                    if (value != null && value.stamp(NodeView.DEFAULT) instanceof NarrowOopStamp) {
                        return HotSpotCompressionNode.uncompress(value.graph(), value, config.getOopEncoding());
                    }
                    return value;
                }
            };
        }
        return new CardTableBarrierSet(this, objectArrayType){
            final /* synthetic */ HotSpotBackendFactory this$0;
            {
                this.this$0 = this$0;
                super(objectArrayType);
            }

            @Override
            protected boolean writeRequiresBarrier(FixedAccessNode node, ValueNode writtenValue) {
                if (!super.writeRequiresBarrier(node, writtenValue)) {
                    return false;
                }
                return !useDeferredInitBarriers || !this.this$0.isWriteToNewObject(node);
            }

            @Override
            protected boolean arrayRangeWriteRequiresBarrier(ArrayRangeWrite write) {
                if (!super.arrayRangeWriteRequiresBarrier(write)) {
                    return false;
                }
                return !useDeferredInitBarriers || !this.this$0.isWriteToNewObject(write.asFixedWithNextNode(), write.getAddress().getBase());
            }
        };
    }

    protected boolean isWriteToNewObject(FixedAccessNode node) {
        if (!node.getLocationIdentity().isInit()) {
            return false;
        }
        return this.isWriteToNewObject(node, node.getAddress().getBase());
    }

    protected boolean isWriteToNewObject(FixedWithNextNode node, ValueNode base) {
        if (base instanceof AbstractNewObjectNode) {
            for (Node pred = node.predecessor(); pred != null; pred = pred.predecessor()) {
                if (pred == base) {
                    node.getDebug().log(2, "Deferred barrier for %s with base %s", (Object)node, (Object)base);
                    return true;
                }
                if (!(pred instanceof AbstractNewObjectNode)) continue;
                node.getDebug().log(2, "Disallowed deferred barrier for %s because %s was last allocation instead of %s", (Object)node, (Object)pred, (Object)base);
                return false;
            }
        }
        node.getDebug().log(2, "Unable to find allocation for deferred barrier for %s with base %s", (Object)node, (Object)base);
        return false;
    }
}

