/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot;

import java.nio.ByteBuffer;
import jdk.graal.compiler.code.DataSection;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.asm.DataBuilder;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.hotspot.HotSpotCompressedNullConstant;
import jdk.vm.ci.hotspot.HotSpotConstant;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.SerializableConstant;
import jdk.vm.ci.meta.VMConstant;

public class HotSpotDataBuilder
extends DataBuilder {
    private static final int MAX_DATA_ALIGNMENT = 32;
    private final TargetDescription target;

    public HotSpotDataBuilder(TargetDescription target) {
        this.target = target;
    }

    @Override
    public DataSection.Data createDataItem(Constant constant) {
        if (JavaConstant.isNull((Constant)constant)) {
            boolean compressed = HotSpotCompressedNullConstant.COMPRESSED_NULL.equals((Object)constant);
            int size = compressed ? 4 : this.target.wordSize;
            return this.createZeroData(size, size);
        }
        if (constant instanceof VMConstant) {
            int size;
            final VMConstant vmConstant = (VMConstant)constant;
            if (!(constant instanceof HotSpotConstant)) {
                throw new GraalError(String.valueOf(constant));
            }
            HotSpotConstant c = (HotSpotConstant)vmConstant;
            int n = size = c.isCompressed() ? 4 : this.target.wordSize;
            assert (this.canForceAlignmentOf(size));
            return new DataSection.Data(this, size, size){

                @Override
                protected void emit(ByteBuffer buffer, DataSection.Patches patches) {
                    int position = buffer.position();
                    if (this.getSize() == 4) {
                        buffer.putInt(-559030611);
                    } else {
                        buffer.putLong(-2401018187971961171L);
                    }
                    patches.registerPatch(position, vmConstant);
                }
            };
        }
        if (constant instanceof SerializableConstant) {
            SerializableConstant s = (SerializableConstant)constant;
            return this.createSerializableData(s);
        }
        throw new GraalError(String.valueOf(constant));
    }

    @Override
    public int getMaxSupportedAlignment() {
        return 32;
    }
}

