/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot;

import jdk.graal.compiler.code.CompilationResult;
import jdk.graal.compiler.debug.GraalError;
import jdk.vm.ci.common.NativeImageReinitialize;

public enum HotSpotMarkId implements CompilationResult.MarkId
{
    VERIFIED_ENTRY,
    UNVERIFIED_ENTRY,
    OSR_ENTRY,
    EXCEPTION_HANDLER_ENTRY,
    DEOPT_HANDLER_ENTRY,
    DEOPT_MH_HANDLER_ENTRY,
    FRAME_COMPLETE,
    ENTRY_BARRIER_PATCH,
    INVOKEINTERFACE,
    INVOKEVIRTUAL,
    INVOKESTATIC,
    INVOKESPECIAL,
    INLINE_INVOKE,
    POLL_NEAR,
    POLL_RETURN_NEAR,
    POLL_FAR,
    POLL_RETURN_FAR,
    CARD_TABLE_ADDRESS,
    NARROW_KLASS_BASE_ADDRESS,
    NARROW_OOP_BASE_ADDRESS,
    CRC_TABLE_ADDRESS,
    LOG_OF_HEAP_REGION_GRAIN_BYTES,
    VERIFY_OOPS,
    VERIFY_OOP_BITS,
    VERIFY_OOP_MASK,
    VERIFY_OOP_COUNT_ADDRESS;

    @NativeImageReinitialize
    private Integer value = null;

    void setValue(Integer value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Object getId() {
        GraalError.guarantee(this.isAvailable(), "mark is not available %s", (Object)this);
        return this.value;
    }

    public boolean isAvailable() {
        return this.value != null;
    }

    public String toString() {
        return "HotSpotCodeMark{" + this.name() + ", value=" + this.value + "}";
    }
}

