/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot;

import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class JVMCIVersionCheck {
    public static final String DEFAULT_VENDOR_ENTRY = "*";
    private static final Map<String, Map<String, Version>> JVMCI_MIN_VERSIONS = Map.of("21", Map.of("*", JVMCIVersionCheck.createLegacyVersion(23, 1, 33)), "23", Map.of("Oracle Corporation", JVMCIVersionCheck.createLabsJDKVersion("23.0.2+7", 1), "*", JVMCIVersionCheck.createLabsJDKVersion("23.0.2+7", 1)));
    private static final int NA = 0;
    private static final int JAVA_MIN_RELEASE = 21;
    public static final String OPEN_LABSJDK_RELEASE_URL_PATTERN = "https://github.com/graalvm/labs-openjdk-*/releases";
    private final String javaSpecVersion;
    private final String vmVersion;
    private final Map<String, String> props;

    public static Version createLabsJDKVersion(String jdkVersionString, int jvmciBuild) {
        return new Version(jdkVersionString, 0, 0, jvmciBuild, false, false);
    }

    public static Version createOpenJDKVersion(String jdkVersionString) {
        return new Version(jdkVersionString, 0, 0, 0, false, true);
    }

    public static Version createLegacyVersion(int jvmciMajor, int jvmciMinor, int jvmciBuild) {
        return new Version("21", jvmciMajor, jvmciMinor, jvmciBuild, true, false);
    }

    private JVMCIVersionCheck(Map<String, String> props, String javaSpecVersion, String vmVersion) {
        this.props = props;
        this.javaSpecVersion = javaSpecVersion;
        this.vmVersion = vmVersion;
    }

    private static String getRequiredProperty(Map<String, String> props, String name) {
        return Objects.requireNonNull(props.get(name), "missing required property: " + name);
    }

    public static Version getMinVersion(Map<String, String> props, Map<String, Map<String, Version>> jvmciMinVersions) {
        String javaSpecVersion = JVMCIVersionCheck.getRequiredProperty(props, "java.specification.version");
        String javaVmVendor = JVMCIVersionCheck.getRequiredProperty(props, "java.vm.vendor");
        Map versionMap = jvmciMinVersions.getOrDefault(javaSpecVersion, Map.of());
        return versionMap.getOrDefault(javaVmVendor, (Version)versionMap.get(DEFAULT_VENDOR_ENTRY));
    }

    static void check(Map<String, String> props, boolean exitOnFailure, PrintFormat format) {
        JVMCIVersionCheck.check(props, exitOnFailure, format, JVMCI_MIN_VERSIONS);
    }

    public static void check(Map<String, String> props, boolean exitOnFailure, PrintFormat format, Map<String, Map<String, Version>> jvmciMinVersions) {
        JVMCIVersionCheck checker = JVMCIVersionCheck.newJVMCIVersionCheck(props);
        String reason = checker.run(JVMCIVersionCheck.getMinVersion(props, jvmciMinVersions), format);
        if (reason != null) {
            Formatter errorMessage = new Formatter().format("%s%n", reason);
            errorMessage.format("Set the JVMCI_VERSION_CHECK environment variable to \"ignore\" to suppress ", new Object[0]);
            errorMessage.format("this error or to \"warn\" to emit a warning and continue execution.%n", new Object[0]);
            checker.appendJVMInfo(errorMessage);
            JVMCIVersionCheck.failVersionCheck(exitOnFailure, errorMessage.toString());
        }
    }

    private static JVMCIVersionCheck newJVMCIVersionCheck(Map<String, String> props) {
        String javaSpecVersion = JVMCIVersionCheck.getRequiredProperty(props, "java.specification.version");
        String javaVmVersion = JVMCIVersionCheck.getRequiredProperty(props, "java.vm.version");
        return new JVMCIVersionCheck(props, javaSpecVersion, javaVmVersion);
    }

    private void appendJVMInfo(Formatter formatter) {
        String javaHome = this.props.get("java.home");
        String vmName = this.props.get("java.vm.name");
        formatter.format("Currently used Java home directory is %s.%n", javaHome);
        formatter.format("Currently used VM configuration is: %s%n", vmName);
        if (this.vmVersion.contains("-jvmci-")) {
            formatter.format("Download the latest Labs OpenJDK from https://github.com/graalvm/labs-openjdk-*/releases", new Object[0]);
        } else {
            formatter.format("Download JDK %s or later.", 21);
        }
    }

    private static void failVersionCheck(boolean exit, String errorMessage) {
        String value = System.getenv("JVMCI_VERSION_CHECK");
        if ("warn".equals(value)) {
            System.err.println(errorMessage);
        } else {
            if ("ignore".equals(value)) {
                return;
            }
            if (exit) {
                System.err.println(errorMessage);
                System.exit(-1);
            } else {
                throw new InternalError(errorMessage);
            }
        }
    }

    public static String check(Map<String, String> props) {
        JVMCIVersionCheck checker = JVMCIVersionCheck.newJVMCIVersionCheck(props);
        String reason = checker.run(JVMCIVersionCheck.getMinVersion(props, JVMCI_MIN_VERSIONS), null);
        if (reason != null) {
            Formatter errorMessage = new Formatter().format("%s%n", reason);
            checker.appendJVMInfo(errorMessage);
            return errorMessage.toString();
        }
        return null;
    }

    private String run(Version minVersion, PrintFormat format) {
        Runtime.Version rv;
        if (this.javaSpecVersion.compareTo(Integer.toString(21)) < 0) {
            return "Graal requires JDK 21 or later.";
        }
        if (this.vmVersion.contains("SNAPSHOT")) {
            return null;
        }
        if (this.vmVersion.contains("internal")) {
            return null;
        }
        if (!this.vmVersion.contains("-jvmci-") && (rv = Runtime.Version.parse(this.vmVersion)).pre().isPresent() && !"ea".equals(rv.pre().get())) {
            return null;
        }
        if (minVersion == null) {
            return String.format("No minimum JVMCI version specified for JDK version %s.", this.javaSpecVersion);
        }
        Version v = Version.parse(this.vmVersion);
        if (v != null) {
            if (format != null) {
                System.out.println(v.printFormat(format));
            }
            if (v.isLessThan(minVersion)) {
                return String.format("The VM does not support the minimum JVMCI API version required by Graal: %s < %s.", v, minVersion);
            }
            return null;
        }
        return String.format("The VM does not support the minimum JVMCI API version required by Graal.%nCannot read JVMCI version from java.vm.version property: %s.", this.vmVersion);
    }

    public static void main(String[] args) {
        Properties sprops = System.getProperties();
        HashMap<String, String> props = new HashMap<String, String>(sprops.size());
        for (String name : sprops.stringPropertyNames()) {
            props.put(name, sprops.getProperty(name));
        }
        PrintFormat format = PrintFormat.TUPLE;
        boolean minVersion = false;
        for (String arg : args) {
            if (arg.equals("--as-tag")) {
                format = PrintFormat.AS_TAG;
                continue;
            }
            if (arg.equals("--min-version")) {
                minVersion = true;
                continue;
            }
            throw new IllegalArgumentException("Unknown argument: " + arg);
        }
        if (minVersion) {
            String javaSpecVersion = (String)props.get("java.specification.version");
            Version v = JVMCIVersionCheck.getMinVersion(props, JVMCI_MIN_VERSIONS);
            if (v == null) {
                System.out.printf("No minimum JVMCI version specified for JDK version %s.%n", javaSpecVersion);
            } else {
                System.out.println(v.printFormat(format));
            }
        } else {
            JVMCIVersionCheck.check(props, true, format);
        }
    }

    public static final class Version {
        private final Runtime.Version jdkVersion;
        private final int jvmciMajor;
        private final int jvmciMinor;
        private final int jvmciBuild;
        private final boolean legacy;
        private final boolean isOpenJDK;
        public static final String AS_TAG_FORMAT_22_AND_LATER = "%s-jvmci-b%02d";
        public static final String AS_TAG_FORMAT_21_AND_EARLIER = "jvmci-%d.%d-b%02d";

        static Version parse(String vmVersion) {
            Matcher m = Pattern.compile("(.+)-jvmci(-(\\d+)\\.(\\d+))?-b(\\d+).*").matcher(vmVersion);
            if (m.matches()) {
                try {
                    if (m.group(3) == null) {
                        assert (m.group(4) == null) : "if jvmciMajor is null jvmciMinor must also be null";
                        String jdkVersion = m.group(1);
                        int jvmciBuild = Integer.parseInt(m.group(5));
                        return JVMCIVersionCheck.createLabsJDKVersion(jdkVersion, jvmciBuild);
                    }
                    int jvmciMajor = Integer.parseInt(m.group(3));
                    int jvmciMinor = Integer.parseInt(m.group(4));
                    int jvmciBuild = Integer.parseInt(m.group(5));
                    return JVMCIVersionCheck.createLegacyVersion(jvmciMajor, jvmciMinor, jvmciBuild);
                }
                catch (NumberFormatException jvmciMajor) {}
            } else {
                try {
                    Runtime.Version rv = Runtime.Version.parse(vmVersion);
                    if (rv.pre().isEmpty() || "ea".equals(rv.pre().get())) {
                        return JVMCIVersionCheck.createOpenJDKVersion(Version.stripVersion(rv));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return null;
        }

        private static String stripVersion(Runtime.Version rv) {
            StringBuilder sb = new StringBuilder(rv.version().stream().map(Object::toString).collect(Collectors.joining(".")));
            if (rv.build().isPresent()) {
                sb.append("+").append(rv.build().get());
            }
            return sb.toString();
        }

        private Version(String jdkVersionString, int jvmciMajor, int jvmciMinor, int jvmciBuild, boolean legacy, boolean isOpenJDK) {
            this(Runtime.Version.parse(jdkVersionString), jvmciMajor, jvmciMinor, jvmciBuild, legacy, isOpenJDK);
        }

        private Version(Runtime.Version jdkVersion, int jvmciMajor, int jvmciMinor, int jvmciBuild, boolean legacy, boolean isOpenJDK) {
            this.jdkVersion = jdkVersion;
            this.jvmciMajor = jvmciMajor;
            this.jvmciMinor = jvmciMinor;
            this.jvmciBuild = jvmciBuild;
            this.legacy = legacy;
            this.isOpenJDK = isOpenJDK;
        }

        boolean isGreaterThan(Version other) {
            if (!this.isLessThan(other)) {
                return !this.equals(other);
            }
            return false;
        }

        public boolean isLessThan(Version other) {
            if (this.legacy && !other.legacy) {
                return true;
            }
            if (this.legacy == other.legacy) {
                int compareTo;
                int n = compareTo = this.legacy ? 0 : this.jdkVersion.compareToIgnoreOptional(other.jdkVersion);
                if (compareTo < 0) {
                    return true;
                }
                if (compareTo == 0) {
                    if (this.isOpenJDK != other.isOpenJDK) {
                        return false;
                    }
                    if (this.jvmciMajor < other.jvmciMajor) {
                        return true;
                    }
                    if (this.jvmciMajor == other.jvmciMajor) {
                        if (this.jvmciMinor < other.jvmciMinor) {
                            return true;
                        }
                        if (this.jvmciMinor == other.jvmciMinor && this.jvmciBuild < other.jvmciBuild) {
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Version) {
                Version that = (Version)obj;
                return this.jdkVersion.equals(that.jdkVersion) && this.jvmciMajor == that.jvmciMajor && this.jvmciMinor == that.jvmciMinor && this.jvmciBuild == that.jvmciBuild;
            }
            return false;
        }

        public int hashCode() {
            return this.jdkVersion.hashCode() ^ this.jvmciMajor ^ this.jvmciMinor ^ this.jvmciBuild;
        }

        public String toString() {
            if (this.isOpenJDK) {
                return this.jdkVersion.toString();
            }
            if (!this.legacy) {
                return String.format(AS_TAG_FORMAT_22_AND_LATER, this.jdkVersion, this.jvmciBuild);
            }
            return String.format(AS_TAG_FORMAT_21_AND_EARLIER, this.jvmciMajor, this.jvmciMinor, this.jvmciBuild);
        }

        public String printFormat(PrintFormat format) {
            return switch (format.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> String.format("%s,%d,%d,%d", this.jdkVersion, this.jvmciMajor, this.jvmciMinor, this.jvmciBuild);
                case 1 -> this.toString();
            };
        }
    }

    static enum PrintFormat {
        TUPLE,
        AS_TAG;

    }
}

