/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.aarch64;

import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.HotSpotMarkId;
import jdk.graal.compiler.lir.LIRFrameState;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.aarch64.AArch64Call;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.hotspot.aarch64.AArch64HotSpotRegisterConfig;
import jdk.vm.ci.meta.InvokeTarget;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Value;

@Opcode(value="CALL_DIRECT")
final class AArch64HotSpotDirectStaticCallOp
extends AArch64Call.DirectCallOp {
    public static final LIRInstructionClass<AArch64HotSpotDirectStaticCallOp> TYPE = LIRInstructionClass.create(AArch64HotSpotDirectStaticCallOp.class);
    private final CallTargetNode.InvokeKind invokeKind;
    private final GraalHotSpotVMConfig config;

    AArch64HotSpotDirectStaticCallOp(ResolvedJavaMethod target, Value result, Value[] parameters, Value[] temps, LIRFrameState state, CallTargetNode.InvokeKind invokeKind, GraalHotSpotVMConfig config) {
        super((LIRInstructionClass<? extends AArch64Call.DirectCallOp>)TYPE, target, result, parameters, temps, state);
        assert (invokeKind.isDirect());
        this.invokeKind = invokeKind;
        this.config = config;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        crb.recordMark(this.invokeKind == CallTargetNode.InvokeKind.Static ? HotSpotMarkId.INVOKESTATIC : HotSpotMarkId.INVOKESPECIAL);
        masm.movNativeAddress(AArch64HotSpotRegisterConfig.inlineCacheRegister, this.config.nonOopBits);
        if (this.config.supportsMethodHandleDeoptimizationEntry() && this.config.isMethodHandleCall((HotSpotResolvedJavaMethod)this.callTarget) && this.invokeKind != CallTargetNode.InvokeKind.Static) {
            crb.setNeedsMHDeoptHandler();
        }
        AArch64Call.directCall(crb, masm, (InvokeTarget)this.callTarget, null, this.state);
    }
}

