/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.aarch64;

import jdk.graal.compiler.core.aarch64.AArch64MoveFactory;
import jdk.graal.compiler.hotspot.aarch64.AArch64HotSpotMove;
import jdk.graal.compiler.lir.aarch64.AArch64LIRInstruction;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.hotspot.HotSpotConstant;
import jdk.vm.ci.hotspot.HotSpotMetaspaceConstant;
import jdk.vm.ci.hotspot.HotSpotObjectConstant;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.PlatformKind;

public class AArch64HotSpotMoveFactory
extends AArch64MoveFactory {
    @Override
    public boolean canInlineConstant(Constant c) {
        if (JavaConstant.isNull((Constant)c)) {
            return true;
        }
        if (c instanceof HotSpotObjectConstant || c instanceof HotSpotMetaspaceConstant) {
            return false;
        }
        return super.canInlineConstant(c);
    }

    @Override
    public AArch64LIRInstruction createLoad(AllocatableValue dst, Constant src) {
        Constant usedSource;
        if (JavaConstant.isNull((Constant)src)) {
            PlatformKind platformKind = dst.getPlatformKind();
            assert (platformKind.equals((Object)AArch64Kind.DWORD) || platformKind.equals((Object)AArch64Kind.QWORD)) : String.format("unexpected null value: %s[%s]", platformKind, src);
            usedSource = platformKind.getSizeInBytes() == 4 ? JavaConstant.INT_0 : JavaConstant.LONG_0;
        } else {
            usedSource = src;
        }
        if (usedSource instanceof HotSpotConstant) {
            HotSpotConstant constant = (HotSpotConstant)usedSource;
            if (constant.isCompressed()) {
                return new AArch64HotSpotMove.LoadHotSpotObjectConstantInline(constant, dst);
            }
            return new AArch64HotSpotMove.LoadHotSpotObjectConstantInline(constant, dst);
        }
        return super.createLoad(dst, usedSource);
    }
}

