/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.aarch64;

import jdk.graal.compiler.core.aarch64.AArch64NodeLIRBuilder;
import jdk.graal.compiler.core.aarch64.AArch64NodeMatchRules;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.core.common.spi.ForeignCallLinkage;
import jdk.graal.compiler.core.gen.DebugInfoBuilder;
import jdk.graal.compiler.hotspot.HotSpotBackend;
import jdk.graal.compiler.hotspot.HotSpotDebugInfoBuilder;
import jdk.graal.compiler.hotspot.HotSpotForeignCallLinkage;
import jdk.graal.compiler.hotspot.HotSpotLIRGenerationResult;
import jdk.graal.compiler.hotspot.HotSpotLIRGenerator;
import jdk.graal.compiler.hotspot.HotSpotLockStack;
import jdk.graal.compiler.hotspot.HotSpotNodeLIRBuilder;
import jdk.graal.compiler.hotspot.aarch64.AArch64HotSpotDirectStaticCallOp;
import jdk.graal.compiler.hotspot.aarch64.AArch64HotSpotDirectVirtualCallOp;
import jdk.graal.compiler.hotspot.aarch64.AArch64HotSpotJumpToExceptionHandlerInCallerOp;
import jdk.graal.compiler.hotspot.aarch64.AArch64HotSpotLIRGenerator;
import jdk.graal.compiler.hotspot.aarch64.AArch64HotSpotPatchReturnAddressOp;
import jdk.graal.compiler.hotspot.aarch64.AArch64HotSpotSafepointOp;
import jdk.graal.compiler.hotspot.aarch64.AArch64IndirectCallOp;
import jdk.graal.compiler.hotspot.meta.HotSpotForeignCallDescriptor;
import jdk.graal.compiler.hotspot.nodes.HotSpotDirectCallTargetNode;
import jdk.graal.compiler.hotspot.nodes.HotSpotIndirectCallTargetNode;
import jdk.graal.compiler.hotspot.stubs.Stub;
import jdk.graal.compiler.lir.LIRFrameState;
import jdk.graal.compiler.lir.Variable;
import jdk.graal.compiler.lir.aarch64.AArch64BreakpointOp;
import jdk.graal.compiler.lir.aarch64.AArch64SaveRegistersOp;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.graal.compiler.nodes.BreakpointNode;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.DirectCallTargetNode;
import jdk.graal.compiler.nodes.FullInfopointNode;
import jdk.graal.compiler.nodes.IndirectCallTargetNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.SafepointNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.NodeValueMap;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.ValueKindFactory;
import jdk.vm.ci.hotspot.HotSpotCallingConventionType;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.hotspot.aarch64.AArch64HotSpotRegisterConfig;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;

public class AArch64HotSpotNodeLIRBuilder
extends AArch64NodeLIRBuilder
implements HotSpotNodeLIRBuilder {
    public AArch64HotSpotNodeLIRBuilder(StructuredGraph graph, LIRGeneratorTool gen, AArch64NodeMatchRules nodeMatchRules) {
        super(graph, gen, nodeMatchRules);
        assert (gen instanceof AArch64HotSpotLIRGenerator) : gen;
        assert (this.getDebugInfoBuilder() instanceof HotSpotDebugInfoBuilder) : this.getDebugInfoBuilder();
        ((AArch64HotSpotLIRGenerator)gen).setDebugInfoBuilder((HotSpotDebugInfoBuilder)this.getDebugInfoBuilder());
    }

    @Override
    protected DebugInfoBuilder createDebugInfoBuilder(StructuredGraph graph, NodeValueMap nodeValueMap) {
        HotSpotLockStack lockStack = new HotSpotLockStack(this.gen.getResult().getFrameMapBuilder(), LIRKind.value((PlatformKind)AArch64Kind.QWORD));
        return new HotSpotDebugInfoBuilder(nodeValueMap, lockStack, (HotSpotLIRGenerator)((Object)this.gen));
    }

    private AArch64HotSpotLIRGenerator getGen() {
        return (AArch64HotSpotLIRGenerator)this.gen;
    }

    @Override
    protected void emitPrologue(StructuredGraph graph) {
        CallingConvention incomingArguments = this.gen.getResult().getCallingConvention();
        HotSpotLIRGenerationResult result = this.getGen().getResult();
        Stub stub = result.getStub();
        if (stub != null && stub.getLinkage().getEffect() == HotSpotForeignCallLinkage.RegisterEffect.KILLS_NO_REGISTERS) {
            assert (stub.getLinkage().getDescriptor().getTransition() != HotSpotForeignCallDescriptor.Transition.SAFEPOINT) : stub;
            Register[] savedRegisters = this.getGen().getRegisterConfig().getAllocatableRegisters().toArray();
            AArch64SaveRegistersOp saveOp = this.getGen().emitSaveAllRegisters(savedRegisters);
            this.append(saveOp);
            result.setSaveOnEntry(saveOp);
        }
        Value[] params = new Value[incomingArguments.getArgumentCount() + 2];
        this.prologAssignParams(incomingArguments, params);
        params[params.length - 2] = AArch64HotSpotRegisterConfig.fp.asValue((ValueKind)LIRKind.value((PlatformKind)AArch64Kind.QWORD));
        params[params.length - 1] = AArch64.lr.asValue((ValueKind)LIRKind.value((PlatformKind)AArch64Kind.QWORD));
        this.gen.emitIncomingValues(params);
        this.prologSetParameterNodes(graph, params);
    }

    @Override
    public void visitSafepointNode(SafepointNode i) {
        LIRFrameState info = this.state(i);
        Register thread = this.getGen().getProviders().getRegisters().getThreadRegister();
        Variable scratch = this.gen.newVariable(LIRKind.value(this.getGen().target().arch.getWordKind()));
        this.append(new AArch64HotSpotSafepointOp(info, this.getGen().config, thread, scratch));
    }

    @Override
    protected void emitDirectCall(DirectCallTargetNode callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState callState) {
        CallTargetNode.InvokeKind invokeKind = ((HotSpotDirectCallTargetNode)callTarget).invokeKind();
        if (invokeKind.isIndirect()) {
            this.append(new AArch64HotSpotDirectVirtualCallOp(callTarget.targetMethod(), result, parameters, temps, callState, invokeKind, this.getGen().config));
        } else {
            assert (invokeKind.isDirect());
            HotSpotResolvedJavaMethod resolvedMethod = (HotSpotResolvedJavaMethod)callTarget.targetMethod();
            assert (resolvedMethod.isConcrete()) : "Cannot make direct call to abstract method.";
            this.append(new AArch64HotSpotDirectStaticCallOp(callTarget.targetMethod(), result, parameters, temps, callState, invokeKind, this.getGen().config));
        }
    }

    @Override
    protected void emitIndirectCall(IndirectCallTargetNode callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState callState) {
        Value metaspaceMethodSrc = this.operand(((HotSpotIndirectCallTargetNode)callTarget).metaspaceMethod());
        Value targetAddressSrc = this.operand(callTarget.computedAddress());
        RegisterValue metaspaceMethodDst = AArch64HotSpotRegisterConfig.metaspaceMethodRegister.asValue(metaspaceMethodSrc.getValueKind());
        RegisterValue targetAddressDst = AArch64HotSpotRegisterConfig.inlineCacheRegister.asValue(targetAddressSrc.getValueKind());
        this.gen.emitMove((AllocatableValue)metaspaceMethodDst, metaspaceMethodSrc);
        this.gen.emitMove((AllocatableValue)targetAddressDst, targetAddressSrc);
        this.append(new AArch64IndirectCallOp(callTarget.targetMethod(), result, parameters, temps, (Value)metaspaceMethodDst, (Value)targetAddressDst, callState));
    }

    @Override
    public void emitPatchReturnAddress(ValueNode address) {
        this.append(new AArch64HotSpotPatchReturnAddressOp(this.gen.asAllocatable(this.operand(address))));
    }

    @Override
    public void emitJumpToExceptionHandlerInCaller(ValueNode handlerInCallerPc, ValueNode exception, ValueNode exceptionPc) {
        AllocatableValue handler = this.gen.asAllocatable(this.operand(handlerInCallerPc));
        ForeignCallLinkage linkage = this.gen.getForeignCalls().lookupForeignCall(HotSpotBackend.EXCEPTION_HANDLER_IN_CALLER);
        CallingConvention outgoingCc = linkage.getOutgoingCallingConvention();
        assert (outgoingCc.getArgumentCount() == 2) : outgoingCc;
        RegisterValue exceptionFixed = (RegisterValue)outgoingCc.getArgument(0);
        RegisterValue exceptionPcFixed = (RegisterValue)outgoingCc.getArgument(1);
        this.gen.emitMove((AllocatableValue)exceptionFixed, this.operand(exception));
        this.gen.emitMove((AllocatableValue)exceptionPcFixed, this.operand(exceptionPc));
        AArch64HotSpotJumpToExceptionHandlerInCallerOp op = new AArch64HotSpotJumpToExceptionHandlerInCallerOp(handler, (AllocatableValue)exceptionFixed, (AllocatableValue)exceptionPcFixed, this.getGen().config);
        this.append(op);
    }

    @Override
    public void visitFullInfopointNode(FullInfopointNode i) {
        if (i.getState() != null && i.getState().bci == -3) {
            i.getDebug().log("Ignoring InfopointNode for AFTER_BCI");
        } else {
            super.visitFullInfopointNode(i);
        }
    }

    @Override
    public void visitBreakpointNode(BreakpointNode node) {
        JavaType[] sig = new JavaType[node.arguments().size()];
        for (int i = 0; i < sig.length; ++i) {
            sig[i] = ((ValueNode)node.arguments().get(i)).stamp(NodeView.DEFAULT).javaType(this.gen.getMetaAccess());
        }
        Value[] parameters = this.visitInvokeArguments(this.gen.getRegisterConfig().getCallingConvention((CallingConvention.Type)HotSpotCallingConventionType.JavaCall, null, sig, (ValueKindFactory)this.gen), node.arguments());
        this.append(new AArch64BreakpointOp(parameters));
    }

    @Override
    public ForeignCallLinkage lookupGraalStub(ValueNode valueNode, ForeignCallDescriptor foreignCallDescriptor) {
        if (this.getGen().getResult().getStub() != null) {
            return null;
        }
        return this.getGen().getForeignCalls().lookupForeignCall(foreignCallDescriptor);
    }
}

