/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.amd64;

import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.core.amd64.AMD64AddressNode;
import jdk.graal.compiler.core.amd64.AMD64CompressAddressLowering;
import jdk.graal.compiler.core.common.CompressEncoding;
import jdk.graal.compiler.core.common.Stride;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.nodes.CompressionNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.vm.ci.code.Register;

public class AMD64HotSpotAddressLowering
extends AMD64CompressAddressLowering {
    private final long heapBase;
    private final Register heapBaseRegister;

    public AMD64HotSpotAddressLowering(GraalHotSpotVMConfig config, Register heapBaseRegister) {
        this.heapBase = config.getOopEncoding().getBase();
        this.heapBaseRegister = this.heapBase == 0L ? null : heapBaseRegister;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected final boolean improveUncompression(AMD64AddressNode addr, CompressionNode compression, ValueNode other) {
        CompressEncoding encoding = compression.getEncoding();
        if (!AMD64Address.isScaleShiftSupported(encoding.getShift())) {
            return false;
        }
        if (this.heapBaseRegister != null && encoding.getBase() == this.heapBase) {
            if (other != null) return false;
            ValueNode base = compression.graph().unique(new AMD64CompressAddressLowering.HeapBaseNode(this.heapBaseRegister));
            addr.setBase(base);
        } else if (encoding.getBase() != 0L) {
            if (!AMD64HotSpotAddressLowering.updateDisplacement(addr, encoding.getBase(), false)) return false;
            addr.setBase(other);
        } else {
            addr.setBase(other);
        }
        Stride stride = Stride.fromLog2(encoding.getShift());
        addr.setScale(stride);
        addr.setIndex(compression.getValue());
        return true;
    }
}

