/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.amd64;

import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.hotspot.amd64.AMD64HotSpotRestoreRbpOp;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.amd64.AMD64BlockEndOp;
import jdk.graal.compiler.lir.amd64.AMD64FrameMap;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

abstract class AMD64HotSpotEpilogueBlockEndOp
extends AMD64BlockEndOp
implements AMD64HotSpotRestoreRbpOp {
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK, LIRInstruction.OperandFlag.ILLEGAL})
    protected AllocatableValue savedRbp = Value.ILLEGAL;

    protected AMD64HotSpotEpilogueBlockEndOp(LIRInstructionClass<? extends AMD64HotSpotEpilogueBlockEndOp> c) {
        super((LIRInstructionClass<? extends AMD64BlockEndOp>)c);
    }

    protected void leaveFrameAndRestoreRbp(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        if (Value.ILLEGAL.equals((Object)this.savedRbp)) {
            assert (((AMD64FrameMap)crb.frameMap).preserveFramePointer()) : "savedRbp is not initialized.";
        } else if (ValueUtil.isStackSlot((Value)this.savedRbp)) {
            masm.movq(AMD64.rbp, (AMD64Address)crb.asAddress((Value)this.savedRbp));
        } else {
            Register framePointer = ValueUtil.asRegister((Value)this.savedRbp);
            if (!framePointer.equals((Object)AMD64.rbp)) {
                masm.movq(AMD64.rbp, framePointer);
            }
        }
        crb.frameContext.leave(crb);
    }

    @Override
    public void setSavedRbp(AllocatableValue value) {
        this.savedRbp = value;
    }
}

