/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.amd64;

import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.hotspot.HotSpotMarkId;
import jdk.graal.compiler.lir.LIRFrameState;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.amd64.AMD64Call;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.InvokeTarget;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Value;

@Opcode(value="CALL_INDIRECT")
final class AMD64HotSpotIndirectCallOp
extends AMD64Call.IndirectCallOp {
    public static final LIRInstructionClass<AMD64HotSpotIndirectCallOp> TYPE = LIRInstructionClass.create(AMD64HotSpotIndirectCallOp.class);
    public static final Register METHOD = AMD64.rbx;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected Value metaspaceMethod;

    AMD64HotSpotIndirectCallOp(ResolvedJavaMethod targetMethod, Value result, Value[] parameters, Value[] temps, Value metaspaceMethod, Value targetAddress, LIRFrameState state) {
        super(TYPE, targetMethod, result, parameters, temps, targetAddress, state);
        this.metaspaceMethod = metaspaceMethod;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        Register callReg = ValueUtil.asRegister((Value)this.targetAddress);
        assert (!callReg.equals((Object)METHOD));
        int beforeCall = AMD64Call.indirectCall(crb, masm, callReg, (InvokeTarget)this.callTarget, this.state, true);
        crb.recordMark(beforeCall, HotSpotMarkId.INLINE_INVOKE);
    }

    @Override
    public void verify() {
        super.verify();
        assert (ValueUtil.asRegister((Value)this.metaspaceMethod).equals((Object)METHOD));
    }
}

