/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.amd64;

import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AMD64Assembler;
import jdk.graal.compiler.asm.amd64.AMD64BaseAssembler;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.core.common.CompressEncoding;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.Stride;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.amd64.AMD64HotSpotMove;
import jdk.graal.compiler.hotspot.meta.HotSpotProviders;
import jdk.graal.compiler.lir.amd64.AMD64Move;
import jdk.graal.compiler.options.OptionValues;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.site.Call;

public class AMD64HotSpotMacroAssembler
extends AMD64MacroAssembler {
    private final GraalHotSpotVMConfig config;
    private final HotSpotProviders providers;

    public AMD64HotSpotMacroAssembler(GraalHotSpotVMConfig config, TargetDescription target, OptionValues optionValues, HotSpotProviders providers, boolean hasIntelJccErratum) {
        super(target, optionValues, hasIntelJccErratum);
        this.config = config;
        this.providers = providers;
    }

    @Override
    public void postCallNop(Call call) {
        if (this.config.continuationsEnabled && call.debugInfo != null) {
            this.emitByte(15);
            this.emitByte(31);
            this.emitByte(132);
            this.emitByte(0);
            this.emitInt(0);
            return;
        }
        super.postCallNop(call);
    }

    public void nmethodEntryCompare(int displacement) {
        this.emitByte(65);
        this.emitByte(129);
        this.emitByte(127);
        GraalError.guarantee(NumUtil.isByte(displacement), "expected byte sized displacement");
        this.emitByte(displacement & 0xFF);
        GraalError.guarantee(this.position() % 4 == 0, "must be aligned");
        this.emitInt(0);
    }

    public void loadObject(Register dst, AMD64Address address) {
        if (this.config.useCompressedOops) {
            this.movl(dst, address);
            CompressEncoding encoding = this.config.getOopEncoding();
            Register baseReg = encoding.hasBase() ? this.providers.getRegisters().getHeapBaseRegister() : Register.None;
            AMD64Move.UncompressPointerOp.emitUncompressCode(this, dst, encoding.getShift(), baseReg, false);
        } else {
            this.movq(dst, address);
        }
    }

    public void verifyOop(Register value, Register tmp, Register tmp2, boolean compressed, boolean nonNull) {
        AMD64Address hubAddress;
        Label ok = new Label();
        if (!nonNull) {
            this.testAndJcc(compressed ? AMD64BaseAssembler.OperandSize.DWORD : AMD64BaseAssembler.OperandSize.QWORD, value, value, AMD64Assembler.ConditionFlag.Zero, ok, true);
        }
        if (compressed) {
            CompressEncoding encoding = this.config.getOopEncoding();
            Register heapBaseRegister = AMD64Move.UncompressPointerOp.hasBase(encoding) ? this.providers.getRegisters().getHeapBaseRegister() : Register.None;
            this.movq(tmp, value);
            AMD64Move.UncompressPointerOp.emitUncompressCode(this, tmp, encoding.getShift(), heapBaseRegister, true);
            hubAddress = new AMD64Address(tmp, this.config.hubOffset);
        } else {
            hubAddress = new AMD64Address(value, this.config.hubOffset);
        }
        if (this.config.useCompressedClassPointers) {
            AMD64HotSpotMove.decodeKlassPointer(this, tmp, tmp2, hubAddress, this.config);
        } else {
            this.movq(tmp, hubAddress);
        }
        this.movl(tmp2, new AMD64Address(tmp, this.config.superCheckOffsetOffset));
        this.cmplAndJcc(tmp2, this.config.secondarySuperCacheOffset, AMD64Assembler.ConditionFlag.Equal, ok, true);
        this.movq(tmp2, new AMD64Address(tmp, tmp2, Stride.S1));
        this.cmpqAndJcc(tmp2, tmp, AMD64Assembler.ConditionFlag.Equal, ok, true);
        this.illegal();
        this.bind(ok);
    }
}

