/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.amd64;

import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.amd64.AMD64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.graal.compiler.replacements.nodes.UnaryMathIntrinsicNode;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;

public final class AMD64HotSpotMathIntrinsicOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64HotSpotMathIntrinsicOp> TYPE = LIRInstructionClass.create(AMD64HotSpotMathIntrinsicOp.class);
    @Opcode
    private final UnaryMathIntrinsicNode.UnaryOperation opcode;
    @LIRInstruction.Def
    protected Value result;
    @LIRInstruction.Use
    protected Value input;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.STACK, LIRInstruction.OperandFlag.ILLEGAL})
    protected Value temp;

    public AMD64HotSpotMathIntrinsicOp(UnaryMathIntrinsicNode.UnaryOperation opcode, Value result, Value input, Value temp) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
        this.opcode = opcode;
        this.result = result;
        this.input = input;
        this.temp = temp;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        AMD64Address stackSlot = (AMD64Address)crb.asAddress(this.temp);
        switch (this.opcode) {
            case LOG: {
                masm.flog(ValueUtil.asRegister((Value)this.result, (PlatformKind)AMD64Kind.DOUBLE), ValueUtil.asRegister((Value)this.input, (PlatformKind)AMD64Kind.DOUBLE), false, stackSlot);
                break;
            }
            case LOG10: {
                masm.flog(ValueUtil.asRegister((Value)this.result, (PlatformKind)AMD64Kind.DOUBLE), ValueUtil.asRegister((Value)this.input, (PlatformKind)AMD64Kind.DOUBLE), true, stackSlot);
                break;
            }
            case SIN: {
                masm.fsin(ValueUtil.asRegister((Value)this.result, (PlatformKind)AMD64Kind.DOUBLE), ValueUtil.asRegister((Value)this.input, (PlatformKind)AMD64Kind.DOUBLE), stackSlot);
                break;
            }
            case COS: {
                masm.fcos(ValueUtil.asRegister((Value)this.result, (PlatformKind)AMD64Kind.DOUBLE), ValueUtil.asRegister((Value)this.input, (PlatformKind)AMD64Kind.DOUBLE), stackSlot);
                break;
            }
            case TAN: {
                masm.ftan(ValueUtil.asRegister((Value)this.result, (PlatformKind)AMD64Kind.DOUBLE), ValueUtil.asRegister((Value)this.input, (PlatformKind)AMD64Kind.DOUBLE), stackSlot);
                break;
            }
            default: {
                throw GraalError.shouldNotReachHereUnexpectedValue((Object)this.opcode);
            }
        }
    }
}

