/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.amd64;

import java.util.function.IntConsumer;
import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AMD64Assembler;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.HotSpotHostBackend;
import jdk.graal.compiler.hotspot.HotSpotMarkId;
import jdk.graal.compiler.lir.LIRFrameState;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.LIRInstructionClass;
import jdk.graal.compiler.lir.Opcode;
import jdk.graal.compiler.lir.amd64.AMD64Call;
import jdk.graal.compiler.lir.amd64.AMD64LIRInstruction;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.site.InfopointReason;
import jdk.vm.ci.meta.AllocatableValue;

@Opcode(value="SAFEPOINT")
public final class AMD64HotSpotSafepointOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64HotSpotSafepointOp> TYPE = LIRInstructionClass.create(AMD64HotSpotSafepointOp.class);
    @LIRInstruction.State
    protected LIRFrameState state;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    private AllocatableValue temp;
    private final GraalHotSpotVMConfig config;
    private final Register thread;

    public AMD64HotSpotSafepointOp(LIRFrameState state, GraalHotSpotVMConfig config, NodeLIRBuilderTool tool, Register thread) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
        this.state = state;
        this.config = config;
        this.thread = thread;
        this.temp = tool.getLIRGeneratorTool().newVariable(LIRKind.value(tool.getLIRGeneratorTool().target().arch.getWordKind()));
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler asm) {
        AMD64HotSpotSafepointOp.emitCode(crb, asm, this.config, false, this.state, this.thread, this.temp instanceof RegisterValue ? ((RegisterValue)this.temp).getRegister() : null);
    }

    public static void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler asm, GraalHotSpotVMConfig config, boolean atReturn, LIRFrameState state, Register thread, Register scratch) {
        assert (!atReturn || state == null) : "state is unneeded at return";
        assert (NumUtil.assertNonNegativeInt(config.threadPollingPageOffset));
        if (config.threadPollingWordOffset != -1 && atReturn && config.pollingPageReturnHandler != 0L) {
            int[] pos = new int[1];
            IntConsumer doMark = value -> {
                pos[0] = value;
                crb.recordMark(HotSpotMarkId.POLL_RETURN_FAR);
            };
            Label entryPoint = new Label();
            asm.cmpqAndJcc(AMD64.rsp, new AMD64Address(thread, config.threadPollingWordOffset), AMD64Assembler.ConditionFlag.Above, entryPoint, false, doMark);
            crb.getLIR().addSlowPath(null, () -> {
                asm.bind(entryPoint);
                asm.leaq(scratch, new AMD64Address(AMD64.rip, 0));
                int afterLea = asm.position();
                asm.emitInt(pos[0] - afterLea, afterLea - 4);
                asm.movq(new AMD64Address(AMD64.r15, config.savedExceptionPCOffset), scratch);
                AMD64Call.directJmp(crb, asm, crb.getForeignCalls().lookupForeignCall(HotSpotHostBackend.POLLING_PAGE_RETURN_HANDLER), null);
            });
        } else {
            asm.movptr(scratch, new AMD64Address(thread, config.threadPollingPageOffset));
            crb.recordMark(atReturn ? HotSpotMarkId.POLL_RETURN_FAR : HotSpotMarkId.POLL_FAR);
            int pos = asm.position();
            if (state != null) {
                crb.recordInfopoint(pos, state, InfopointReason.SAFEPOINT);
            }
            asm.testl(AMD64.rax, new AMD64Address(scratch));
        }
    }
}

