/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.amd64;

import jdk.graal.compiler.asm.Label;
import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AMD64Assembler;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.asm.amd64.AVXKind;
import jdk.graal.compiler.core.amd64.AMD64LIRGenerator;
import jdk.graal.compiler.core.amd64.AMD64ReadBarrierSetLIRGenerator;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.memory.BarrierType;
import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.core.common.spi.ForeignCallLinkage;
import jdk.graal.compiler.core.common.spi.ForeignCallsProvider;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.amd64.AMD64HotSpotBackend;
import jdk.graal.compiler.hotspot.amd64.AMD64HotSpotZAtomicReadAndWriteOp;
import jdk.graal.compiler.hotspot.amd64.AMD64HotSpotZCompareAndSwapOp;
import jdk.graal.compiler.hotspot.amd64.AMD64HotSpotZReadBarrierOp;
import jdk.graal.compiler.hotspot.amd64.AMD64HotSpotZVectorReadBarrierOp;
import jdk.graal.compiler.hotspot.meta.HotSpotHostForeignCallsProvider;
import jdk.graal.compiler.lir.LIRFrameState;
import jdk.graal.compiler.lir.LIRInstruction;
import jdk.graal.compiler.lir.Variable;
import jdk.graal.compiler.lir.amd64.AMD64AddressValue;
import jdk.graal.compiler.lir.amd64.AMD64Call;
import jdk.graal.compiler.lir.amd64.vector.AMD64VectorMove;
import jdk.graal.compiler.lir.asm.CompilationResultBuilder;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.graal.compiler.phases.util.Providers;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

public class AMD64HotSpotZBarrierSetLIRGenerator
extends AMD64ReadBarrierSetLIRGenerator {
    private final GraalHotSpotVMConfig config;
    private final Providers providers;

    public AMD64HotSpotZBarrierSetLIRGenerator(GraalHotSpotVMConfig config, Providers providers) {
        this.config = config;
        this.providers = providers;
    }

    public ForeignCallsProvider getForeignCalls() {
        return this.providers.getForeignCalls();
    }

    public static void emitBarrier(CompilationResultBuilder crb, AMD64MacroAssembler masm, Label success, Register resultReg, GraalHotSpotVMConfig config, ForeignCallLinkage callTarget, AMD64Address address, LIRInstruction op, AMD64HotSpotBackend.HotSpotFrameContext frameContext) {
        assert (!resultReg.equals((Object)address.getBase()) && !resultReg.equals((Object)address.getIndex())) : Assertions.errorMessage(resultReg, address);
        Label entryPoint = new Label();
        Label continuation = new Label();
        masm.testq(resultReg, new AMD64Address(AMD64.r15, config.threadAddressBadMaskOffset));
        if (success != null) {
            masm.jcc(AMD64Assembler.ConditionFlag.Zero, success);
            masm.jmp(entryPoint);
        } else {
            masm.jcc(AMD64Assembler.ConditionFlag.NotZero, entryPoint);
        }
        crb.getLIR().addSlowPath(op, () -> {
            masm.bind(entryPoint);
            if (frameContext != null) {
                frameContext.rawEnter(crb);
            }
            CallingConvention cc = callTarget.getOutgoingCallingConvention();
            AMD64Address cArg0 = (AMD64Address)crb.asAddress((Value)cc.getArgument(0));
            AMD64Address cArg1 = (AMD64Address)crb.asAddress((Value)cc.getArgument(1));
            masm.movq(cArg0, resultReg);
            masm.leaq(resultReg, address);
            masm.movq(cArg1, resultReg);
            AMD64Call.directCall(crb, masm, callTarget, null, false, null);
            masm.movq(resultReg, cArg0);
            if (frameContext != null) {
                frameContext.rawLeave(crb);
            }
            masm.jmp(continuation);
        });
        masm.bind(continuation);
    }

    @Override
    public Variable emitBarrieredLoad(LIRGeneratorTool tool, LIRKind kind, Value address, LIRFrameState state, MemoryOrderMode memoryOrder, BarrierType barrierType) {
        if (kind.getPlatformKind().getVectorLength() == 1) {
            GraalError.guarantee(kind.getPlatformKind() == AMD64Kind.QWORD, "ZGC only uses uncompressed oops: %s", (Object)kind);
            ForeignCallLinkage callTarget = this.getBarrierStub(barrierType);
            AMD64AddressValue loadAddress = ((AMD64LIRGenerator)tool).asAddressValue(address);
            Variable result = tool.newVariable(tool.toRegisterKind(kind));
            tool.getResult().getFrameMapBuilder().callsMethod(callTarget.getOutgoingCallingConvention());
            tool.append(new AMD64HotSpotZReadBarrierOp(result, loadAddress, state, this.config, callTarget));
            return result;
        }
        if (kind.getPlatformKind().getVectorLength() > 1) {
            assert (barrierType == BarrierType.READ) : Assertions.errorMessage(new Object[]{barrierType});
            ForeignCallLinkage callTarget = this.getForeignCalls().lookupForeignCall(HotSpotHostForeignCallsProvider.Z_ARRAY_BARRIER);
            AMD64AddressValue loadAddress = ((AMD64LIRGenerator)tool).asAddressValue(address);
            Variable result = tool.newVariable(tool.toRegisterKind(kind));
            AMD64Assembler.VexMoveOp op = AMD64VectorMove.getVectorMemMoveOp((AMD64Kind)kind.getPlatformKind());
            Variable temp = tool.newVariable(tool.toRegisterKind(kind));
            tool.getResult().getFrameMapBuilder().callsMethod(callTarget.getOutgoingCallingConvention());
            tool.append(new AMD64HotSpotZVectorReadBarrierOp(AVXKind.getRegisterSize((AMD64Kind)kind.getPlatformKind()), op, result, loadAddress, state, this.config, callTarget, temp));
            return result;
        }
        throw GraalError.shouldNotReachHere("unhandled barrier");
    }

    public ForeignCallLinkage getBarrierStub(BarrierType barrierType) {
        return switch (barrierType) {
            case BarrierType.READ -> this.getForeignCalls().lookupForeignCall(HotSpotHostForeignCallsProvider.Z_FIELD_BARRIER);
            case BarrierType.REFERENCE_GET -> this.getForeignCalls().lookupForeignCall(HotSpotHostForeignCallsProvider.Z_REFERENCE_GET_BARRIER);
            case BarrierType.WEAK_REFERS_TO -> this.getForeignCalls().lookupForeignCall(HotSpotHostForeignCallsProvider.Z_WEAK_REFERS_TO_BARRIER);
            case BarrierType.PHANTOM_REFERS_TO -> this.getForeignCalls().lookupForeignCall(HotSpotHostForeignCallsProvider.Z_PHANTOM_REFERS_TO_BARRIER);
            default -> throw GraalError.shouldNotReachHere("Unexpected barrier type: " + String.valueOf((Object)barrierType));
        };
    }

    @Override
    public void emitCompareAndSwapOp(LIRGeneratorTool tool, LIRKind accessKind, AMD64Kind memKind, RegisterValue raxValue, AMD64AddressValue address, AllocatableValue newValue, BarrierType barrierType) {
        ForeignCallLinkage callTarget = this.getBarrierStub(barrierType);
        assert (memKind == accessKind.getPlatformKind()) : Assertions.errorMessage(new Object[]{memKind, accessKind, raxValue, address, newValue});
        Variable temp = tool.newVariable(tool.toRegisterKind(accessKind));
        tool.getResult().getFrameMapBuilder().callsMethod(callTarget.getOutgoingCallingConvention());
        tool.append(new AMD64HotSpotZCompareAndSwapOp(memKind, (AllocatableValue)raxValue, address, (AllocatableValue)raxValue, tool.asAllocatable((Value)newValue), temp, this.config, callTarget));
    }

    @Override
    public Value emitAtomicReadAndWrite(LIRGeneratorTool tool, LIRKind accessKind, Value address, Value newValue, BarrierType barrierType) {
        AMD64Kind kind = (AMD64Kind)accessKind.getPlatformKind();
        GraalError.guarantee(barrierType == BarrierType.READ, "unexpected type for barrier: %s", (Object)barrierType);
        Variable result = tool.newVariable(accessKind);
        AMD64AddressValue addressValue = ((AMD64LIRGenerator)tool).asAddressValue(address);
        GraalError.guarantee(kind == AMD64Kind.QWORD, "unexpected kind for ZGC");
        ForeignCallLinkage callTarget = this.getBarrierStub(barrierType);
        tool.getResult().getFrameMapBuilder().callsMethod(callTarget.getOutgoingCallingConvention());
        tool.append(new AMD64HotSpotZAtomicReadAndWriteOp(result, addressValue, tool.asAllocatable(newValue), this.config, callTarget));
        return result;
    }
}

