/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.amd64;

import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.hotspot.HotSpotForeignCallLinkage;
import jdk.graal.compiler.hotspot.meta.HotSpotProviders;
import jdk.graal.compiler.hotspot.stubs.SnippetStub;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.replacements.nodes.BinaryMathIntrinsicNode;
import jdk.graal.compiler.replacements.nodes.UnaryMathIntrinsicNode;

public class AMD64MathStub
extends SnippetStub {
    public AMD64MathStub(UnaryMathIntrinsicNode.UnaryOperation operation, OptionValues options, HotSpotProviders providers, HotSpotForeignCallLinkage linkage) {
        super(AMD64MathStub.snippetName(operation), options, providers, linkage);
    }

    public AMD64MathStub(BinaryMathIntrinsicNode.BinaryOperation operation, OptionValues options, HotSpotProviders providers, HotSpotForeignCallLinkage linkage) {
        super(AMD64MathStub.snippetName(operation), options, providers, linkage);
    }

    private static String snippetName(UnaryMathIntrinsicNode.UnaryOperation operation) {
        switch (operation) {
            case SIN: {
                return "sin";
            }
            case COS: {
                return "cos";
            }
            case TAN: {
                return "tan";
            }
            case EXP: {
                return "exp";
            }
            case LOG: {
                return "log";
            }
            case LOG10: {
                return "log10";
            }
        }
        throw GraalError.shouldNotReachHere("Unknown operation " + String.valueOf((Object)operation));
    }

    private static String snippetName(BinaryMathIntrinsicNode.BinaryOperation operation) {
        if (operation == BinaryMathIntrinsicNode.BinaryOperation.POW) {
            return "pow";
        }
        throw GraalError.shouldNotReachHere("Unknown operation " + String.valueOf((Object)operation));
    }

    @Snippet
    private static double log(double value) {
        return UnaryMathIntrinsicNode.compute(value, UnaryMathIntrinsicNode.UnaryOperation.LOG);
    }

    @Snippet
    private static double log10(double value) {
        return UnaryMathIntrinsicNode.compute(value, UnaryMathIntrinsicNode.UnaryOperation.LOG10);
    }

    @Snippet
    private static double sin(double value) {
        return UnaryMathIntrinsicNode.compute(value, UnaryMathIntrinsicNode.UnaryOperation.SIN);
    }

    @Snippet
    private static double cos(double value) {
        return UnaryMathIntrinsicNode.compute(value, UnaryMathIntrinsicNode.UnaryOperation.COS);
    }

    @Snippet
    private static double tan(double value) {
        return UnaryMathIntrinsicNode.compute(value, UnaryMathIntrinsicNode.UnaryOperation.TAN);
    }

    @Snippet
    private static double exp(double value) {
        return UnaryMathIntrinsicNode.compute(value, UnaryMathIntrinsicNode.UnaryOperation.EXP);
    }

    @Snippet
    private static double pow(double value1, double value2) {
        return BinaryMathIntrinsicNode.compute(value1, value2, BinaryMathIntrinsicNode.BinaryOperation.POW);
    }
}

