/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.amd64.g1;

import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AMD64MacroAssembler;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.HotSpotG1BarrierSetLIRTool;
import jdk.graal.compiler.hotspot.amd64.AMD64HotSpotMacroAssembler;
import jdk.graal.compiler.hotspot.meta.HotSpotProviders;
import jdk.graal.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import jdk.graal.compiler.lir.amd64.g1.AMD64G1BarrierSetLIRTool;
import jdk.vm.ci.code.Register;

public class AMD64HotSpotG1BarrierSetLIRTool
extends HotSpotG1BarrierSetLIRTool
implements AMD64G1BarrierSetLIRTool {
    public AMD64HotSpotG1BarrierSetLIRTool(GraalHotSpotVMConfig config, HotSpotProviders providers) {
        super(config, providers);
    }

    @Override
    public Register getThread(AMD64MacroAssembler masm) {
        return this.providers.getRegisters().getThreadRegister();
    }

    @Override
    public void computeCard(Register cardAddress, Register storeAddress, Register tmp2, AMD64MacroAssembler masm) {
        int cardTableShift = HotSpotReplacementsUtil.cardTableShift(this.config);
        masm.movq(cardAddress, storeAddress);
        masm.shrq(cardAddress, cardTableShift);
        masm.movq(tmp2, HotSpotReplacementsUtil.cardTableStart(this.config));
        masm.addq(cardAddress, tmp2);
    }

    @Override
    public void loadObject(AMD64MacroAssembler masm, Register previousValue, AMD64Address storeAddress) {
        AMD64HotSpotMacroAssembler hasm = (AMD64HotSpotMacroAssembler)masm;
        hasm.loadObject(previousValue, storeAddress);
    }

    @Override
    public void verifyOop(AMD64MacroAssembler masm, Register value, Register tmp, Register tmp2, boolean compressed, boolean nonNull) {
        AMD64HotSpotMacroAssembler hasm = (AMD64HotSpotMacroAssembler)masm;
        hasm.verifyOop(value, tmp, tmp2, compressed, nonNull);
    }
}

