/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.meta;

import jdk.graal.compiler.core.common.spi.ConstantFieldProvider;
import jdk.graal.compiler.core.common.spi.JavaConstantFieldProvider;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.options.OptionValues;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaField;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;

public class HotSpotConstantFieldProvider
extends JavaConstantFieldProvider {
    private final GraalHotSpotVMConfig config;
    private static final String SystemClassName = "Ljava/lang/System;";

    public HotSpotConstantFieldProvider(GraalHotSpotVMConfig config, MetaAccessProvider metaAccess) {
        super(metaAccess);
        this.config = config;
    }

    @Override
    protected boolean isStableField(ResolvedJavaField field, ConstantFieldProvider.ConstantFieldTool<?> tool) {
        if (!this.config.foldStableValues) {
            return false;
        }
        if (field.isStatic() && !this.isStaticFieldConstant(field, tool.getOptions())) {
            return false;
        }
        if (((HotSpotResolvedJavaField)field).isStable()) {
            return true;
        }
        return super.isStableField(field, tool);
    }

    @Override
    protected boolean isFinalField(ResolvedJavaField field, ConstantFieldProvider.ConstantFieldTool<?> tool) {
        if (field.isStatic() && !this.isStaticFieldConstant(field, tool.getOptions())) {
            return false;
        }
        return super.isFinalField(field, tool);
    }

    protected boolean isStaticFieldConstant(ResolvedJavaField field, OptionValues options) {
        ResolvedJavaType declaringClass = field.getDeclaringClass();
        return declaringClass.isInitialized() && !declaringClass.getName().equals(SystemClassName);
    }
}

