/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.meta;

import java.util.function.Supplier;
import jdk.graal.compiler.core.common.CompilationIdentifier;
import jdk.graal.compiler.core.common.memory.BarrierType;
import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.HotSpotCompilationIdentifier;
import jdk.graal.compiler.hotspot.nodes.CurrentJavaThreadNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FixedGuardNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.NamedLocationIdentity;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.IntegerEqualsNode;
import jdk.graal.compiler.nodes.graphbuilderconf.NodePlugin;
import jdk.graal.compiler.nodes.memory.ReadNode;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.memory.address.OffsetAddressNode;
import jdk.graal.compiler.options.OptionKey;
import jdk.internal.misc.Unsafe;
import jdk.vm.ci.hotspot.HotSpotCompilationRequest;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.word.LocationIdentity;

public final class HotSpotExceptionDispatchPlugin
implements NodePlugin {
    private static final Unsafe UNSAFE = Unsafe.getUnsafe();
    private final GraalHotSpotVMConfig config;
    private final JavaKind wordKind;
    private static final LocationIdentity JAVA_THREAD_SHOULD_POST_ON_EXCEPTIONS_FLAG_LOCATION = NamedLocationIdentity.mutable("JavaThread::_should_post_on_exceptions_flag");

    public HotSpotExceptionDispatchPlugin(GraalHotSpotVMConfig config, JavaKind wordKind) {
        this.config = config;
        this.wordKind = wordKind;
    }

    @Override
    public FixedWithNextNode instrumentExceptionDispatch(StructuredGraph graph, FixedWithNextNode afterExceptionLoaded, Supplier<FrameState> frameStateFunction) {
        CompilationIdentifier id = graph.compilationId();
        if (id instanceof HotSpotCompilationIdentifier && this.config.jvmciCompileStateCanPostOnExceptionsOffset != Integer.MIN_VALUE && this.config.javaThreadShouldPostOnExceptionsFlagOffset != Integer.MIN_VALUE) {
            long compileState;
            boolean canPostOnExceptions = Options.HotSpotPostOnExceptions.getValue(graph.getOptions());
            HotSpotCompilationRequest request = ((HotSpotCompilationIdentifier)id).getRequest();
            if (request != null && (compileState = request.getJvmciEnv()) != 0L) {
                long canPostOnExceptionsOffset = compileState + (long)this.config.jvmciCompileStateCanPostOnExceptionsOffset;
                boolean bl = canPostOnExceptions = UNSAFE.getByte(canPostOnExceptionsOffset) != 0;
            }
            if (canPostOnExceptions) {
                CurrentJavaThreadNode thread = graph.unique(new CurrentJavaThreadNode(this.wordKind));
                ValueNode offset = graph.unique(ConstantNode.forLong(this.config.javaThreadShouldPostOnExceptionsFlagOffset));
                AddressNode address = graph.unique(new OffsetAddressNode(thread, offset));
                ReadNode shouldPostException = graph.add(new ReadNode(address, JAVA_THREAD_SHOULD_POST_ON_EXCEPTIONS_FLAG_LOCATION, StampFactory.intValue(), BarrierType.NONE, MemoryOrderMode.PLAIN));
                afterExceptionLoaded.setNext(shouldPostException);
                ValueNode zero = graph.unique(ConstantNode.forInt(0));
                LogicNode cond = graph.unique(new IntegerEqualsNode(shouldPostException, zero));
                FixedGuardNode check = graph.add(new FixedGuardNode(cond, DeoptimizationReason.TransferToInterpreter, DeoptimizationAction.None, false));
                FrameState fs = frameStateFunction.get();
                assert (fs.stackSize() == 1 && fs.rethrowException()) : "expected rethrow exception FrameState";
                check.setStateBefore(fs);
                shouldPostException.setNext(check);
                return check;
            }
        }
        return afterExceptionLoaded;
    }

    public static class Options {
        public static final OptionKey<Boolean> HotSpotPostOnExceptions = new OptionKey<Boolean>(false);
    }
}

