/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.nodes;

import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.hotspot.HotSpotLIRGenerator;
import jdk.graal.compiler.lir.Variable;
import jdk.graal.compiler.lir.VirtualStackSlot;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.word.Word;
import jdk.graal.compiler.word.WordTypes;
import jdk.vm.ci.meta.Value;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public final class CurrentLockNode
extends FixedWithNextNode
implements LIRLowerable {
    public static final NodeClass<CurrentLockNode> TYPE = NodeClass.create(CurrentLockNode.class);
    protected int lockDepth;

    public CurrentLockNode(@Node.InjectedNodeParameter WordTypes wordTypes, int lockDepth) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, StampFactory.forKind(wordTypes.getWordKind()));
        this.lockDepth = lockDepth;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        assert (this.lockDepth != -1);
        HotSpotLIRGenerator hsGen = (HotSpotLIRGenerator)gen.getLIRGeneratorTool();
        VirtualStackSlot slot = hsGen.getLockSlot(this.lockDepth);
        Variable result = gen.getLIRGeneratorTool().emitAddress(slot);
        gen.setResult(this, (Value)result);
    }

    @Node.NodeIntrinsic
    public static native Word currentLock(@Node.ConstantNodeParameter int var0);
}

