/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.nodes;

import jdk.graal.compiler.bytecode.Bytecode;
import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.spi.ForeignCallLinkage;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.hotspot.HotSpotBackend;
import jdk.graal.compiler.hotspot.nodes.DeoptimizingStubCall;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.replacements.nodes.CStringConstant;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Value;

@NodeInfo(cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_UNKNOWN)
public final class VMErrorNode
extends DeoptimizingStubCall
implements LIRLowerable {
    public static final NodeClass<VMErrorNode> TYPE = NodeClass.create(VMErrorNode.class);
    protected final CStringConstant format;
    @Node.Input
    ValueNode value;

    public VMErrorNode(CStringConstant format, ValueNode value) {
        super((NodeClass<? extends DeoptimizingStubCall>)TYPE, StampFactory.forVoid());
        this.format = format;
        this.value = value;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        Object whereString;
        if (this.stateBefore() != null) {
            String nl = CodeUtil.NEW_LINE;
            StringBuilder sb = new StringBuilder("in compiled code associated with frame state:");
            for (FrameState fs = this.stateBefore(); fs != null; fs = fs.outerFrameState()) {
                Bytecode.appendLocation(sb.append(nl).append("\t"), fs.getCode(), fs.bci);
            }
            whereString = sb.toString();
        } else {
            ResolvedJavaMethod method = this.graph().method();
            whereString = "in compiled code for " + (method == null ? this.graph().toString() : method.format("%H.%n(%p)"));
        }
        LIRKind wordKind = gen.getLIRGeneratorTool().getLIRKind(StampFactory.pointer());
        Value whereArg = gen.getLIRGeneratorTool().emitConstant(wordKind, (Constant)new CStringConstant((String)whereString));
        Value formatArg = gen.getLIRGeneratorTool().emitConstant(wordKind, (Constant)this.format);
        ForeignCallLinkage linkage = gen.getLIRGeneratorTool().getForeignCalls().lookupForeignCall(HotSpotBackend.VM_ERROR);
        gen.getLIRGeneratorTool().emitForeignCall(linkage, null, whereArg, formatArg, gen.operand(this.value));
    }

    @Node.NodeIntrinsic
    public static native void vmError(@Node.ConstantNodeParameter CStringConstant var0, long var1);
}

