/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.nodes.type;

import jdk.graal.compiler.core.common.type.AbstractPointerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.hotspot.nodes.type.MetaspacePointerStamp;
import jdk.vm.ci.hotspot.HotSpotMemoryAccessProvider;
import jdk.vm.ci.hotspot.HotSpotMetaspaceConstant;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MemoryAccessProvider;
import jdk.vm.ci.meta.MetaAccessProvider;

public final class MethodPointerStamp
extends MetaspacePointerStamp {
    private static final MethodPointerStamp METHOD = new MethodPointerStamp(false, false);
    private static final MethodPointerStamp METHOD_NON_NULL = new MethodPointerStamp(true, false);
    private static final MethodPointerStamp METHOD_ALWAYS_NULL = new MethodPointerStamp(false, true);

    public static MethodPointerStamp method() {
        return METHOD;
    }

    public static MethodPointerStamp methodNonNull() {
        return METHOD_NON_NULL;
    }

    public static MethodPointerStamp methodAlwaysNull() {
        return METHOD_ALWAYS_NULL;
    }

    private MethodPointerStamp(boolean nonNull, boolean alwaysNull) {
        super(nonNull, alwaysNull);
    }

    @Override
    protected AbstractPointerStamp copyWith(boolean newNonNull, boolean newAlwaysNull) {
        if (newNonNull) {
            assert (!newAlwaysNull) : "New ust not be always null";
            return METHOD_NON_NULL;
        }
        if (newAlwaysNull) {
            return METHOD_ALWAYS_NULL;
        }
        return METHOD;
    }

    @Override
    public boolean isCompatible(Stamp otherStamp) {
        if (this == otherStamp) {
            return true;
        }
        return otherStamp instanceof MethodPointerStamp;
    }

    @Override
    public boolean isCompatible(Constant constant) {
        if (constant instanceof HotSpotMetaspaceConstant) {
            return ((HotSpotMetaspaceConstant)constant).asResolvedJavaMethod() != null;
        }
        return super.isCompatible(constant);
    }

    @Override
    public Stamp constant(Constant c, MetaAccessProvider meta) {
        if (JavaConstant.NULL_POINTER.equals((Object)c)) {
            return METHOD_ALWAYS_NULL;
        }
        assert (c instanceof HotSpotMetaspaceConstant) : c;
        return METHOD_NON_NULL;
    }

    @Override
    public Constant readConstant(MemoryAccessProvider provider, Constant base, long displacement) {
        HotSpotMemoryAccessProvider hsProvider = (HotSpotMemoryAccessProvider)provider;
        return hsProvider.readMethodPointerConstant(base, displacement);
    }

    @Override
    public String toString() {
        StringBuilder ret = new StringBuilder("Method*");
        this.appendString(ret);
        return ret.toString();
    }
}

