/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.replacements;

import java.util.List;
import java.util.Objects;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.api.replacements.Snippet;
import jdk.graal.compiler.bytecode.ResolvedJavaMethodBytecode;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.core.common.type.ObjectStamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.StampPair;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.iterators.NodeIterable;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.meta.HotSpotForeignCallDescriptor;
import jdk.graal.compiler.hotspot.meta.HotSpotProviders;
import jdk.graal.compiler.hotspot.meta.HotSpotRegistersProvider;
import jdk.graal.compiler.hotspot.nodes.BeginLockScopeNode;
import jdk.graal.compiler.hotspot.nodes.CurrentLockNode;
import jdk.graal.compiler.hotspot.nodes.EndLockScopeNode;
import jdk.graal.compiler.hotspot.nodes.MonitorCounterNode;
import jdk.graal.compiler.hotspot.nodes.VMErrorNode;
import jdk.graal.compiler.hotspot.replacements.AssertionSnippets;
import jdk.graal.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import jdk.graal.compiler.hotspot.replacements.HotspotSnippetsOptions;
import jdk.graal.compiler.hotspot.replacements.Log;
import jdk.graal.compiler.hotspot.stubs.StubUtil;
import jdk.graal.compiler.hotspot.word.KlassPointer;
import jdk.graal.compiler.lir.SyncPort;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.InvokeNode;
import jdk.graal.compiler.nodes.NamedLocationIdentity;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ReturnNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.debug.DynamicCounterNode;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.extended.ForeignCallNode;
import jdk.graal.compiler.nodes.extended.MembarNode;
import jdk.graal.compiler.nodes.java.MethodCallTargetNode;
import jdk.graal.compiler.nodes.java.MonitorEnterNode;
import jdk.graal.compiler.nodes.java.MonitorExitNode;
import jdk.graal.compiler.nodes.spi.LoweringTool;
import jdk.graal.compiler.nodes.type.StampTool;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.common.inlining.InliningUtil;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.SnippetCounter;
import jdk.graal.compiler.replacements.SnippetTemplate;
import jdk.graal.compiler.replacements.Snippets;
import jdk.graal.compiler.replacements.nodes.CStringConstant;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

@SyncPort(from="https://github.com/openjdk/jdk/blob/7f6bb71eb302e8388c959bdaa914b758a766d299/src/hotspot/cpu/x86/c2_MacroAssembler_x86.cpp#L479-L937", sha1="f7935caf24770868ffc539215e72c6317ce2af74")
public class MonitorSnippets
implements Snippets {
    private static final LocationIdentity MONITOR_COUNTER_LOCATION = NamedLocationIdentity.mutable("MonitorCounter");
    public static final HotSpotForeignCallDescriptor MONITORENTER = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.SAFEPOINT, ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, LocationIdentity.any(), "monitorenter", Void.TYPE, Object.class, Word.class);
    public static final HotSpotForeignCallDescriptor MONITOREXIT = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.STACK_INSPECTABLE_LEAF, ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, LocationIdentity.any(), "monitorexit", Void.TYPE, Object.class, Word.class);

    @Snippet
    public static void monitorenter(Object object, KlassPointer hub, @Snippet.ConstantParameter int lockDepth, @Snippet.ConstantParameter Register threadRegister, @Snippet.ConstantParameter Register stackPointerRegister, @Snippet.ConstantParameter boolean trace, @Snippet.ConstantParameter Counters counters) {
        HotSpotReplacementsUtil.verifyOop(object);
        Word mark = HotSpotReplacementsUtil.loadWordFromObject(object, HotSpotReplacementsUtil.markOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
        Word lock = BeginLockScopeNode.beginLockScope(lockDepth);
        Word thread = HotSpotReplacementsUtil.registerAsWord(threadRegister);
        MonitorSnippets.trace(trace, "           object: 0x%016lx\n", (WordBase)Word.objectToTrackedPointer(object));
        MonitorSnippets.trace(trace, "             lock: 0x%016lx\n", (WordBase)lock);
        MonitorSnippets.trace(trace, "             mark: 0x%016lx\n", (WordBase)mark);
        MonitorSnippets.incCounter();
        if (HotSpotReplacementsUtil.diagnoseSyncOnValueBasedClasses(GraalHotSpotVMConfig.INJECTED_VMCONFIG) && hub.readWord(HotSpotReplacementsUtil.klassAccessFlagsOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), HotSpotReplacementsUtil.KLASS_ACCESS_FLAGS_LOCATION).and(HotSpotReplacementsUtil.jvmAccIsValueBasedClass(GraalHotSpotVMConfig.INJECTED_VMCONFIG)).notEqual(0)) {
            MonitorSnippets.monitorenterStubC(MONITORENTER, object, lock);
            return;
        }
        if (MonitorSnippets.tryFastPathLocking(object, stackPointerRegister, trace, counters, mark, lock, thread)) {
            MonitorSnippets.incrementHeldMonitorCount(thread);
        } else {
            MonitorSnippets.monitorenterStubC(MONITORENTER, object, lock);
        }
    }

    private static boolean tryFastPathLocking(Object object, Register stackPointerRegister, boolean trace, Counters counters, Word mark, Word lock, Word thread) {
        if (HotSpotReplacementsUtil.useLightweightLocking(GraalHotSpotVMConfig.INJECTED_VMCONFIG)) {
            return MonitorSnippets.tryLightweightLocking(object, lock, mark, thread, trace, counters, stackPointerRegister);
        }
        if (HotSpotReplacementsUtil.useStackLocking(GraalHotSpotVMConfig.INJECTED_VMCONFIG)) {
            return MonitorSnippets.tryStackLocking(object, lock, mark, thread, trace, counters, stackPointerRegister);
        }
        return false;
    }

    private static boolean tryEnterInflated(Object object, Word mark, Word thread, boolean trace, Counters counters) {
        int ownerOffset;
        Word monitor = mark.subtract(HotSpotReplacementsUtil.monitorMask(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
        Word owner = (Word)monitor.readWord(ownerOffset = HotSpotReplacementsUtil.objectMonitorOwnerOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), HotSpotReplacementsUtil.OBJECT_MONITOR_OWNER_LOCATION);
        if (BranchProbabilityNode.probability(0.9, owner.equal(0))) {
            if (BranchProbabilityNode.probability(0.9, monitor.logicCompareAndSwapWord(ownerOffset, (WordBase)owner, (WordBase)thread, HotSpotReplacementsUtil.OBJECT_MONITOR_OWNER_LOCATION))) {
                MonitorSnippets.traceObject(trace, "+lock{heavyweight:cas}", object, true);
                counters.lockHeavyCas.inc();
                return true;
            }
            MonitorSnippets.traceObject(trace, "+lock{heavyweight:failed-cas}", object, true);
            counters.lockHeavyFailedCas.inc();
        } else {
            if (BranchProbabilityNode.probability(0.4, owner.equal(thread))) {
                int recursionsOffset = HotSpotReplacementsUtil.objectMonitorRecursionsOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
                Word recursions = (Word)monitor.readWord(recursionsOffset, HotSpotReplacementsUtil.OBJECT_MONITOR_RECURSION_LOCATION);
                monitor.writeWord(recursionsOffset, (WordBase)recursions.add(1), HotSpotReplacementsUtil.OBJECT_MONITOR_RECURSION_LOCATION);
                MonitorSnippets.traceObject(trace, "+lock{heavyweight:recursive}", object, true);
                counters.lockHeavyRecursive.inc();
                return true;
            }
            MonitorSnippets.traceObject(trace, "+lock{heavyweight:owned}", object, true);
            counters.lockHeavyOwned.inc();
        }
        return false;
    }

    private static boolean tryStackLocking(Object object, Word lock, Word mark, Word thread, boolean trace, Counters counters, Register stackPointerRegister) {
        if (BranchProbabilityNode.probability(0.010000000000000009, mark.and(HotSpotReplacementsUtil.monitorMask(GraalHotSpotVMConfig.INJECTED_VMCONFIG)).notEqual(0))) {
            lock.writeWord(HotSpotReplacementsUtil.lockDisplacedMarkOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), (WordBase)WordFactory.unsigned((int)3), HotSpotReplacementsUtil.DISPLACED_MARK_WORD_LOCATION);
            return MonitorSnippets.tryEnterInflated(object, mark, thread, trace, counters);
        }
        Word objectPointer = Word.objectToTrackedPointer(object);
        Word unlockedMark = mark.or(HotSpotReplacementsUtil.unlockedMask(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
        MonitorSnippets.trace(trace, "     unlockedMark: 0x%016lx\n", (WordBase)unlockedMark);
        lock.writeWord(HotSpotReplacementsUtil.lockDisplacedMarkOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), (WordBase)unlockedMark, HotSpotReplacementsUtil.DISPLACED_MARK_WORD_LOCATION);
        Word currentMark = (Word)objectPointer.compareAndSwapWord(HotSpotReplacementsUtil.markOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), (WordBase)unlockedMark, (WordBase)lock, HotSpotReplacementsUtil.MARK_WORD_LOCATION);
        if (BranchProbabilityNode.probability(0.99, currentMark.equal(unlockedMark))) {
            MonitorSnippets.traceObject(trace, "+lock{stack:cas}", object, true);
            counters.lockFastCas.inc();
            return true;
        }
        MonitorSnippets.trace(trace, "      currentMark: 0x%016lx\n", (WordBase)currentMark);
        Word alignedMask = (Word)WordFactory.unsigned((int)(HotSpotReplacementsUtil.wordSize() - 1));
        Word stackPointer = HotSpotReplacementsUtil.registerAsWord(stackPointerRegister);
        if (BranchProbabilityNode.probability(0.99, currentMark.subtract(stackPointer).and(alignedMask.subtract(HotSpotReplacementsUtil.pageSize(GraalHotSpotVMConfig.INJECTED_VMCONFIG))).equal(0))) {
            lock.writeWord(HotSpotReplacementsUtil.lockDisplacedMarkOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), WordFactory.zero(), HotSpotReplacementsUtil.DISPLACED_MARK_WORD_LOCATION);
            MonitorSnippets.traceObject(trace, "+lock{stack:recursive}", object, true);
            counters.lockFastRecursive.inc();
            return true;
        }
        MonitorSnippets.traceObject(trace, "+lock{stack:failed-cas}", object, true);
        counters.lockFastFailedCas.inc();
        return false;
    }

    @SyncPort(from="https://github.com/openjdk/jdk/blob/2e925f263d5a9a69f21e0c12bd71242fdff084cd/src/hotspot/cpu/x86/c2_MacroAssembler_x86.cpp#L939-L1040", sha1="b8ed14b9452ca81095d6e0ccc49f0948c8b7812c")
    private static boolean tryLightweightLocking(Object object, Word lock, Word mark, Word thread, boolean trace, Counters counters, Register stackPointerRegister) {
        Word lockStackTop = (Word)WordFactory.unsigned((int)thread.readInt(HotSpotReplacementsUtil.javaThreadLockStackTopOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), HotSpotReplacementsUtil.JAVA_THREAD_LOCK_STACK_TOP_LOCATION));
        if (BranchProbabilityNode.probability(0.010000000000000009, mark.and(HotSpotReplacementsUtil.monitorMask(GraalHotSpotVMConfig.INJECTED_VMCONFIG)).notEqual(0))) {
            return MonitorSnippets.tryEnterInflated(object, mark, thread, trace, counters);
        }
        if (BranchProbabilityNode.probability(0.010000000000000009, lockStackTop.greaterOrEqual(HotSpotReplacementsUtil.javaThreadLockStackEndOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG)))) {
            MonitorSnippets.traceObject(trace, "+lock{lightweight:fulllockstack}", object, true);
            counters.lockFastRuntimeConstraint.inc();
            return false;
        }
        Word objectPointer = Word.objectToTrackedPointer(object);
        if (BranchProbabilityNode.probability(0.99, MonitorSnippets.tryLightweightLockingHelper(object, objectPointer, mark, thread, trace, counters, lockStackTop))) {
            thread.writeWord((WordBase)lockStackTop, (WordBase)objectPointer, HotSpotReplacementsUtil.JAVA_THREAD_LOCK_STACK_LOCATION);
            thread.writeInt(HotSpotReplacementsUtil.javaThreadLockStackTopOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), (int)lockStackTop.rawValue() + HotSpotReplacementsUtil.wordSize(), HotSpotReplacementsUtil.JAVA_THREAD_LOCK_STACK_TOP_LOCATION);
            return true;
        }
        MonitorSnippets.traceObject(trace, "+lock{lightweight:failed-cas}", object, true);
        counters.lockFastFailedCas.inc();
        return false;
    }

    private static boolean tryLightweightLockingHelper(Object object, Pointer objectPointer, Word mark, Word thread, boolean trace, Counters counters, Word lockStackTop) {
        Word lastLock = (Word)thread.readWord((WordBase)lockStackTop.add(-HotSpotReplacementsUtil.wordSize()), HotSpotReplacementsUtil.JAVA_THREAD_LOCK_STACK_LOCATION);
        if (BranchProbabilityNode.probability(0.010000000000000009, objectPointer.equal((UnsignedWord)lastLock))) {
            MonitorSnippets.traceObject(trace, "+lock{lightweight:recursive}", object, true);
            counters.lockFastRecursive.inc();
            return true;
        }
        Word markUnlocked = mark.or(HotSpotReplacementsUtil.unlockedMask(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
        Word markLocked = markUnlocked.and(~HotSpotReplacementsUtil.unlockedMask(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
        if (BranchProbabilityNode.probability(0.99, objectPointer.logicCompareAndSwapWord(HotSpotReplacementsUtil.markOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), (WordBase)markUnlocked, (WordBase)markLocked, HotSpotReplacementsUtil.MARK_WORD_LOCATION))) {
            MonitorSnippets.traceObject(trace, "+lock{lightweight:cas}", object, true);
            counters.lockFastCas.inc();
            return true;
        }
        return false;
    }

    @Snippet
    public static void monitorexit(Object object, @Snippet.ConstantParameter int lockDepth, @Snippet.ConstantParameter Register threadRegister, @Snippet.ConstantParameter boolean trace, @Snippet.ConstantParameter Counters counters) {
        HotSpotReplacementsUtil.verifyOop(object);
        Word thread = HotSpotReplacementsUtil.registerAsWord(threadRegister);
        Word lock = CurrentLockNode.currentLock(lockDepth);
        Word displacedMark = (Word)lock.readWord(HotSpotReplacementsUtil.lockDisplacedMarkOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), HotSpotReplacementsUtil.DISPLACED_MARK_WORD_LOCATION);
        MonitorSnippets.trace(trace, "           object: 0x%016lx\n", (WordBase)Word.objectToTrackedPointer(object));
        MonitorSnippets.trace(trace, "             lock: 0x%016lx\n", (WordBase)lock);
        MonitorSnippets.trace(trace, "    displacedMark: 0x%016lx\n", (WordBase)displacedMark);
        if (MonitorSnippets.tryFastPathUnlocking(object, trace, counters, thread, lock, displacedMark)) {
            MonitorSnippets.decrementHeldMonitorCount(thread);
        } else {
            MonitorSnippets.monitorexitStubC(MONITOREXIT, object, lock);
        }
        EndLockScopeNode.endLockScope();
        MonitorSnippets.decCounter();
    }

    private static boolean tryFastPathUnlocking(Object object, boolean trace, Counters counters, Word thread, Word lock, Word displacedMark) {
        if (HotSpotReplacementsUtil.useLightweightLocking(GraalHotSpotVMConfig.INJECTED_VMCONFIG)) {
            return MonitorSnippets.tryLightweightUnlocking(object, thread, trace, counters);
        }
        if (HotSpotReplacementsUtil.useStackLocking(GraalHotSpotVMConfig.INJECTED_VMCONFIG)) {
            return MonitorSnippets.tryStackUnlocking(object, displacedMark, thread, lock, trace, counters);
        }
        return false;
    }

    private static boolean tryStackUnlocking(Object object, Word displacedMark, Word thread, Word lock, boolean trace, Counters counters) {
        if (BranchProbabilityNode.probability(0.4, displacedMark.equal(0))) {
            MonitorSnippets.traceObject(trace, "-lock{stack:recursive}", object, false);
            counters.unlockFastRecursive.inc();
            return true;
        }
        Word mark = HotSpotReplacementsUtil.loadWordFromObject(object, HotSpotReplacementsUtil.markOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
        if (BranchProbabilityNode.probability(0.010000000000000009, mark.and(HotSpotReplacementsUtil.monitorMask(GraalHotSpotVMConfig.INJECTED_VMCONFIG)).notEqual(0))) {
            return MonitorSnippets.tryExitInflated(object, thread, trace, counters);
        }
        if (BranchProbabilityNode.probability(0.999, Word.objectToTrackedPointer(object).logicCompareAndSwapWord(HotSpotReplacementsUtil.markOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), (WordBase)lock, (WordBase)displacedMark, HotSpotReplacementsUtil.MARK_WORD_LOCATION))) {
            MonitorSnippets.traceObject(trace, "-lock{stack:cas}", object, false);
            counters.unlockFastCas.inc();
            return true;
        }
        MonitorSnippets.traceObject(trace, "-lock{stack:failed-cas}", object, false);
        counters.unlockFastFailedCas.inc();
        return false;
    }

    @SyncPort(from="https://github.com/openjdk/jdk/blob/2e925f263d5a9a69f21e0c12bd71242fdff084cd/src/hotspot/cpu/x86/c2_MacroAssembler_x86.cpp#L1042-L1181", sha1="9254c9e734304a65365bd67dbff5809501c0d28f")
    private static boolean tryLightweightUnlocking(Object object, Word thread, boolean trace, Counters counters) {
        Word lockStackTop = (Word)WordFactory.unsigned((int)thread.readInt(HotSpotReplacementsUtil.javaThreadLockStackTopOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), HotSpotReplacementsUtil.JAVA_THREAD_LOCK_STACK_TOP_LOCATION));
        Word newLockStackTop = lockStackTop.add(-HotSpotReplacementsUtil.wordSize());
        Word mark = HotSpotReplacementsUtil.loadWordFromObject(object, HotSpotReplacementsUtil.markOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
        Word objectPointer = Word.objectToTrackedPointer(object);
        if (BranchProbabilityNode.probability(0.010000000000000009, objectPointer.notEqual((UnsignedWord)thread.readWord((WordBase)newLockStackTop, HotSpotReplacementsUtil.JAVA_THREAD_LOCK_STACK_LOCATION)))) {
            if (HotSpotReplacementsUtil.isCAssertEnabled(GraalHotSpotVMConfig.INJECTED_VMCONFIG) && BranchProbabilityNode.probability(0.09999999999999998, mark.and(HotSpotReplacementsUtil.monitorMask(GraalHotSpotVMConfig.INJECTED_VMCONFIG)).equal(0))) {
                AssertionSnippets.vmMessageC(StubUtil.VM_MESSAGE_C, true, CStringConstant.cstring("Fast Unlock not monitor"), 0L, 0L, 0L);
            }
            return MonitorSnippets.tryExitInflated(object, thread, trace, counters);
        }
        if (HotSpotReplacementsUtil.isCAssertEnabled(GraalHotSpotVMConfig.INJECTED_VMCONFIG)) {
            thread.writeWord((WordBase)newLockStackTop, WordFactory.zero(), HotSpotReplacementsUtil.JAVA_THREAD_LOCK_STACK_LOCATION);
        }
        thread.writeInt(HotSpotReplacementsUtil.javaThreadLockStackTopOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), (int)newLockStackTop.rawValue(), HotSpotReplacementsUtil.JAVA_THREAD_LOCK_STACK_TOP_LOCATION);
        if (BranchProbabilityNode.probability(0.010000000000000009, objectPointer.equal((UnsignedWord)thread.readWord((WordBase)lockStackTop.add(-2 * HotSpotReplacementsUtil.wordSize()), HotSpotReplacementsUtil.JAVA_THREAD_LOCK_STACK_LOCATION)))) {
            MonitorSnippets.traceObject(trace, "-lock{lightweight:recursive}", object, false);
            counters.unlockFastRecursive.inc();
            return true;
        }
        Word markLocked = mark.and(~HotSpotReplacementsUtil.lockMaskInPlace(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
        Word markUnlocked = mark.or(HotSpotReplacementsUtil.unlockedMask(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
        if (BranchProbabilityNode.probability(0.99, objectPointer.logicCompareAndSwapWord(HotSpotReplacementsUtil.markOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), (WordBase)markLocked, (WordBase)markUnlocked, HotSpotReplacementsUtil.MARK_WORD_LOCATION))) {
            MonitorSnippets.traceObject(trace, "-lock{lightweight:cas}", object, false);
            counters.unlockFastCas.inc();
            return true;
        }
        if (HotSpotReplacementsUtil.isCAssertEnabled(GraalHotSpotVMConfig.INJECTED_VMCONFIG)) {
            thread.writeWord((WordBase)newLockStackTop, (WordBase)objectPointer, HotSpotReplacementsUtil.JAVA_THREAD_LOCK_STACK_LOCATION);
        }
        thread.writeInt(HotSpotReplacementsUtil.javaThreadLockStackTopOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), (int)lockStackTop.rawValue(), HotSpotReplacementsUtil.JAVA_THREAD_LOCK_STACK_TOP_LOCATION);
        MonitorSnippets.traceObject(trace, "-lock{lightweight:failed-cas}", object, false);
        counters.unlockFastFailedCas.inc();
        return false;
    }

    private static boolean tryExitInflated(Object object, Word thread, boolean trace, Counters counters) {
        Word mark = HotSpotReplacementsUtil.loadWordFromObject(object, HotSpotReplacementsUtil.markOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
        Word monitor = mark.subtract(HotSpotReplacementsUtil.monitorMask(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
        int ownerOffset = HotSpotReplacementsUtil.objectMonitorOwnerOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
        int recursionsOffset = HotSpotReplacementsUtil.objectMonitorRecursionsOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
        Word recursions = (Word)monitor.readWord(recursionsOffset, HotSpotReplacementsUtil.OBJECT_MONITOR_RECURSION_LOCATION);
        if (BranchProbabilityNode.probability(0.99, recursions.equal(0))) {
            int entryListOffset;
            Word entryList;
            int cxqOffset = HotSpotReplacementsUtil.objectMonitorCxqOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
            Word cxq = (Word)monitor.readWord(cxqOffset, HotSpotReplacementsUtil.OBJECT_MONITOR_CXQ_LOCATION);
            if (BranchProbabilityNode.probability(0.9, cxq.or(entryList = (Word)monitor.readWord(entryListOffset = HotSpotReplacementsUtil.objectMonitorEntryListOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), HotSpotReplacementsUtil.OBJECT_MONITOR_ENTRY_LIST_LOCATION)).equal(0))) {
                MembarNode.memoryBarrier(MembarNode.FenceKind.STORE_RELEASE);
                monitor.writeWord(ownerOffset, WordFactory.zero());
                MonitorSnippets.traceObject(trace, "-lock{heavyweight:simple}", object, false);
                counters.unlockHeavySimple.inc();
                return true;
            }
            int succOffset = HotSpotReplacementsUtil.objectMonitorSuccOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
            Word succ = (Word)monitor.readWord(succOffset, HotSpotReplacementsUtil.OBJECT_MONITOR_SUCC_LOCATION);
            if (BranchProbabilityNode.probability(0.9, succ.isNonNull())) {
                monitor.writeWordVolatile(ownerOffset, WordFactory.zero());
                succ = (Word)monitor.readWordVolatile(succOffset, HotSpotReplacementsUtil.OBJECT_MONITOR_SUCC_LOCATION);
                if (BranchProbabilityNode.probability(0.09999999999999998, succ.isNonNull())) {
                    MonitorSnippets.traceObject(trace, "-lock{heavyweight:transfer}", object, false);
                    counters.unlockHeavyTransfer.inc();
                    return true;
                }
                if (BranchProbabilityNode.probability(0.9, !monitor.logicCompareAndSwapWord(ownerOffset, WordFactory.zero(), (WordBase)thread, HotSpotReplacementsUtil.OBJECT_MONITOR_OWNER_LOCATION))) {
                    MonitorSnippets.traceObject(trace, "-lock{heavyweight:transfer}", object, false);
                    counters.unlockHeavyTransfer.inc();
                    return true;
                }
            }
        } else {
            monitor.writeWord(recursionsOffset, (WordBase)recursions.subtract(1), HotSpotReplacementsUtil.OBJECT_MONITOR_RECURSION_LOCATION);
            MonitorSnippets.traceObject(trace, "-lock{heavyweight:recursive}", object, false);
            counters.unlockHeavyRecursive.inc();
            return true;
        }
        MonitorSnippets.traceObject(trace, "-lock{heavyweight:stub}", object, false);
        counters.unlockHeavyStub.inc();
        return false;
    }

    private static void incrementHeldMonitorCount(Word thread) {
        MonitorSnippets.updateHeldMonitorCount(thread, 1);
    }

    private static void decrementHeldMonitorCount(Word thread) {
        MonitorSnippets.updateHeldMonitorCount(thread, -1);
    }

    private static void updateHeldMonitorCount(Word thread, int increment) {
        Word heldMonitorCount = (Word)thread.readWord(HotSpotReplacementsUtil.heldMonitorCountOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), HotSpotReplacementsUtil.JAVA_THREAD_HOLD_MONITOR_COUNT_LOCATION);
        thread.writeWord(HotSpotReplacementsUtil.heldMonitorCountOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), (WordBase)heldMonitorCount.add(increment), HotSpotReplacementsUtil.JAVA_THREAD_HOLD_MONITOR_COUNT_LOCATION);
    }

    @Fold
    static boolean doProfile(@Fold.InjectedParameter OptionValues options) {
        return HotspotSnippetsOptions.ProfileMonitors.getValue(options);
    }

    private static void traceObject(boolean enabled, String action, Object object, boolean enter) {
        if (MonitorSnippets.doProfile(GraalHotSpotVMConfig.INJECTED_OPTIONVALUES)) {
            DynamicCounterNode.counter(enter ? "number of monitor enters" : "number of monitor exits", action, 1L, false);
        }
        if (enabled) {
            Log.print(action);
            Log.print(' ');
            Log.printlnObject(object);
        }
    }

    private static void trace(boolean enabled, String format, WordBase value) {
        if (enabled) {
            Log.printf(format, value.rawValue());
        }
    }

    @Fold
    static boolean verifyBalancedMonitors(@Fold.InjectedParameter OptionValues options) {
        return HotspotSnippetsOptions.VerifyBalancedMonitors.getValue(options);
    }

    static void incCounter() {
        if (MonitorSnippets.verifyBalancedMonitors(GraalHotSpotVMConfig.INJECTED_OPTIONVALUES)) {
            Word counter = MonitorCounterNode.counter();
            int count = counter.readInt(0, MONITOR_COUNTER_LOCATION);
            counter.writeInt(0, count + 1, MONITOR_COUNTER_LOCATION);
        }
    }

    static void decCounter() {
        if (MonitorSnippets.verifyBalancedMonitors(GraalHotSpotVMConfig.INJECTED_OPTIONVALUES)) {
            Word counter = MonitorCounterNode.counter();
            int count = counter.readInt(0, MONITOR_COUNTER_LOCATION);
            counter.writeInt(0, count - 1, MONITOR_COUNTER_LOCATION);
        }
    }

    @Snippet
    private static void initCounter() {
        Word counter = MonitorCounterNode.counter();
        counter.writeInt(0, 0, MONITOR_COUNTER_LOCATION);
    }

    @Snippet
    private static void checkCounter(@Snippet.ConstantParameter CStringConstant errMsg) {
        Word counter = MonitorCounterNode.counter();
        int count = counter.readInt(0, MONITOR_COUNTER_LOCATION);
        if (count != 0) {
            VMErrorNode.vmError(errMsg, count);
        }
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void monitorenterStubC(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Object var1, Word var2);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native void monitorexitStubC(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Object var1, Word var2);

    public static class Counters {
        public final SnippetCounter lockFastCas;
        public final SnippetCounter lockFastFailedCas;
        public final SnippetCounter lockFastRecursive;
        public final SnippetCounter lockFastRuntimeConstraint;
        public final SnippetCounter lockHeavyCas;
        public final SnippetCounter lockHeavyFailedCas;
        public final SnippetCounter lockHeavyRecursive;
        public final SnippetCounter lockHeavyOwned;
        public final SnippetCounter unlockFastCas;
        public final SnippetCounter unlockFastRecursive;
        public final SnippetCounter unlockFastFailedCas;
        public final SnippetCounter unlockHeavyStub;
        public final SnippetCounter unlockHeavySimple;
        public final SnippetCounter unlockHeavyTransfer;
        public final SnippetCounter unlockHeavyRecursive;

        public Counters(SnippetCounter.Group.Factory factory) {
            SnippetCounter.Group enter = factory.createSnippetCounterGroup("MonitorEnters");
            SnippetCounter.Group exit = factory.createSnippetCounterGroup("MonitorExits");
            this.lockFastCas = new SnippetCounter(enter, "lock{fast:cas}", "fast locking, cas-locked");
            this.lockFastRecursive = new SnippetCounter(enter, "lock{fast:recursive}", "fast locking, recursive");
            this.lockFastFailedCas = new SnippetCounter(enter, "lock{fast:failed-cas}", "fast locking, failed cas, call stub");
            this.lockFastRuntimeConstraint = new SnippetCounter(enter, "lock{fast:runtime-constraint}", "fast locking, runtime constraint, call stub");
            this.lockHeavyCas = new SnippetCounter(enter, "lock{heavyweight:cas}", "heavyweight locking, cas-locked");
            this.lockHeavyRecursive = new SnippetCounter(enter, "lock{heavyweight:recursive}", "heavyweight locking, recursive");
            this.lockHeavyFailedCas = new SnippetCounter(enter, "lock{heavyweight:failed-cas}", "heavyweight locking, failed cas, call stub");
            this.lockHeavyOwned = new SnippetCounter(enter, "lock{heavyweight:owned}", "heavyweight locking, owned by other, call stub");
            this.unlockFastCas = new SnippetCounter(exit, "unlock{fast:cas}", "fast locking, cas-unlocked");
            this.unlockFastRecursive = new SnippetCounter(exit, "unlock{fast:recursive}", "fast locking, recursive");
            this.unlockFastFailedCas = new SnippetCounter(exit, "unlock{fast:failed-cas}", "fast locking, failed cas, call stub");
            this.unlockHeavySimple = new SnippetCounter(exit, "unlock{heavyweight:simple}", "heavyweight locking, unlocked an object monitor");
            this.unlockHeavyRecursive = new SnippetCounter(exit, "unlock{heavyweight:recursive}", "heavyweight locking, unlocked an object monitor, recursive");
            this.unlockHeavyTransfer = new SnippetCounter(exit, "unlock{heavyweight:transfer}", "heavyweight locking, unlocked an object monitor in the presence of ObjectMonitor::_succ");
            this.unlockHeavyStub = new SnippetCounter(exit, "unlock{heavyweight:stub}", "heavyweight locking, stub-unlocked an object with inflated monitor");
        }
    }

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        private final SnippetTemplate.SnippetInfo monitorenter;
        private final SnippetTemplate.SnippetInfo monitorexit;
        private final SnippetTemplate.SnippetInfo initCounter;
        private final SnippetTemplate.SnippetInfo checkCounter;
        public final Counters counters;

        public Templates(OptionValues options, SnippetCounter.Group.Factory factory, HotSpotProviders providers, GraalHotSpotVMConfig config) {
            super(options, providers);
            LocationIdentity[] exitLocations;
            LocationIdentity[] enterLocations;
            if (HotSpotReplacementsUtil.useLightweightLocking(config)) {
                enterLocations = new LocationIdentity[]{HotSpotReplacementsUtil.JAVA_THREAD_LOCK_STACK_LOCATION, HotSpotReplacementsUtil.JAVA_THREAD_LOCK_STACK_TOP_LOCATION, HotSpotReplacementsUtil.JAVA_THREAD_HOLD_MONITOR_COUNT_LOCATION};
                exitLocations = new LocationIdentity[]{HotSpotReplacementsUtil.JAVA_THREAD_LOCK_STACK_LOCATION, HotSpotReplacementsUtil.JAVA_THREAD_LOCK_STACK_TOP_LOCATION, HotSpotReplacementsUtil.DISPLACED_MARK_WORD_LOCATION, HotSpotReplacementsUtil.OBJECT_MONITOR_OWNER_LOCATION, HotSpotReplacementsUtil.OBJECT_MONITOR_CXQ_LOCATION, HotSpotReplacementsUtil.OBJECT_MONITOR_ENTRY_LIST_LOCATION, HotSpotReplacementsUtil.OBJECT_MONITOR_RECURSION_LOCATION, HotSpotReplacementsUtil.OBJECT_MONITOR_SUCC_LOCATION, HotSpotReplacementsUtil.MARK_WORD_LOCATION, HotSpotReplacementsUtil.JAVA_THREAD_HOLD_MONITOR_COUNT_LOCATION};
            } else {
                enterLocations = new LocationIdentity[]{HotSpotReplacementsUtil.JAVA_THREAD_HOLD_MONITOR_COUNT_LOCATION};
                exitLocations = new LocationIdentity[]{HotSpotReplacementsUtil.DISPLACED_MARK_WORD_LOCATION, HotSpotReplacementsUtil.OBJECT_MONITOR_OWNER_LOCATION, HotSpotReplacementsUtil.OBJECT_MONITOR_CXQ_LOCATION, HotSpotReplacementsUtil.OBJECT_MONITOR_ENTRY_LIST_LOCATION, HotSpotReplacementsUtil.OBJECT_MONITOR_RECURSION_LOCATION, HotSpotReplacementsUtil.OBJECT_MONITOR_SUCC_LOCATION, HotSpotReplacementsUtil.MARK_WORD_LOCATION, HotSpotReplacementsUtil.JAVA_THREAD_HOLD_MONITOR_COUNT_LOCATION};
            }
            this.monitorenter = this.snippet((Providers)providers, MonitorSnippets.class, "monitorenter", enterLocations);
            this.monitorexit = this.snippet((Providers)providers, MonitorSnippets.class, "monitorexit", exitLocations);
            this.initCounter = this.snippet((Providers)providers, MonitorSnippets.class, "initCounter", new LocationIdentity[0]);
            this.checkCounter = this.snippet((Providers)providers, MonitorSnippets.class, "checkCounter", new LocationIdentity[0]);
            this.counters = new Counters(factory);
        }

        public void lower(MonitorEnterNode monitorenterNode, HotSpotRegistersProvider registers, LoweringTool tool) {
            StructuredGraph graph = monitorenterNode.graph();
            this.checkBalancedMonitors(graph, tool);
            assert (((ObjectStamp)monitorenterNode.object().stamp(NodeView.DEFAULT)).nonNull());
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.monitorenter, graph.getGuardsStage(), tool.getLoweringStage());
            args.add("object", monitorenterNode.object());
            args.add("hub", Objects.requireNonNull(monitorenterNode.getObjectData()));
            args.addConst("lockDepth", monitorenterNode.getMonitorId().getLockDepth());
            args.addConst("threadRegister", registers.getThreadRegister());
            args.addConst("stackPointerRegister", registers.getStackPointerRegister());
            args.addConst("trace", Templates.isTracingEnabledForType(monitorenterNode.object()) || Templates.isTracingEnabledForMethod(graph));
            args.addConst("counters", this.counters);
            this.template(tool, monitorenterNode, args).instantiate(tool.getMetaAccess(), monitorenterNode, SnippetTemplate.DEFAULT_REPLACER, args);
        }

        public void lower(MonitorExitNode monitorexitNode, HotSpotRegistersProvider registers, LoweringTool tool) {
            StructuredGraph graph = monitorexitNode.graph();
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.monitorexit, graph.getGuardsStage(), tool.getLoweringStage());
            args.add("object", monitorexitNode.object());
            args.addConst("lockDepth", monitorexitNode.getMonitorId().getLockDepth());
            args.addConst("threadRegister", registers.getThreadRegister());
            args.addConst("trace", Templates.isTracingEnabledForType(monitorexitNode.object()) || Templates.isTracingEnabledForMethod(graph));
            args.addConst("counters", this.counters);
            this.template(tool, monitorexitNode, args).instantiate(tool.getMetaAccess(), monitorexitNode, SnippetTemplate.DEFAULT_REPLACER, args);
        }

        public static boolean isTracingEnabledForType(ValueNode object) {
            ResolvedJavaType type = StampTool.typeOrNull(object.stamp(NodeView.DEFAULT));
            String filter = HotspotSnippetsOptions.TraceMonitorsTypeFilter.getValue(object.getOptions());
            if (filter == null) {
                return false;
            }
            if (filter.length() == 0) {
                return true;
            }
            if (type == null) {
                return false;
            }
            return type.getName().contains(filter);
        }

        public static boolean isTracingEnabledForMethod(StructuredGraph graph) {
            String filter = HotspotSnippetsOptions.TraceMonitorsMethodFilter.getValue(graph.getOptions());
            if (filter == null) {
                return false;
            }
            if (filter.length() == 0) {
                return true;
            }
            if (graph.method() == null) {
                return false;
            }
            return graph.method().format("%H.%n").contains(filter);
        }

        private void checkBalancedMonitors(StructuredGraph graph, LoweringTool tool) {
            NodeIterable<MonitorCounterNode> nodes;
            if (HotspotSnippetsOptions.VerifyBalancedMonitors.getValue(this.options).booleanValue() && (nodes = graph.getNodes().filter(MonitorCounterNode.class)).isEmpty()) {
                JavaType returnType = this.initCounter.getMethod().getSignature().getReturnType(this.initCounter.getMethod().getDeclaringClass());
                StampPair returnStamp = StampFactory.forDeclaredType(graph.getAssumptions(), returnType, false);
                MethodCallTargetNode callTarget = graph.add(new MethodCallTargetNode(CallTargetNode.InvokeKind.Static, this.initCounter.getMethod(), ValueNode.EMPTY_ARRAY, returnStamp, null));
                InvokeNode invoke = graph.add(new InvokeNode(callTarget, 0));
                invoke.setStateAfter(graph.start().stateAfter());
                graph.addAfterFixed(graph.start(), invoke);
                StructuredGraph inlineeGraph = tool.getReplacements().getSnippet(this.initCounter.getMethod(), null, null, null, invoke.graph().trackNodeSourcePosition(), invoke.getNodeSourcePosition(), invoke.getOptions());
                InliningUtil.inline(invoke, inlineeGraph, false, null);
                List<ReturnNode> rets = graph.getNodes(ReturnNode.TYPE).snapshot();
                for (ReturnNode ret : rets) {
                    returnType = this.checkCounter.getMethod().getSignature().getReturnType(this.checkCounter.getMethod().getDeclaringClass());
                    String msg = "unbalanced monitors in " + graph.method().format("%H.%n(%p)") + ", count = %d";
                    ConstantNode errMsg = ConstantNode.forConstant(tool.getConstantReflection().forString(msg), tool.getMetaAccess(), graph);
                    returnStamp = StampFactory.forDeclaredType(graph.getAssumptions(), returnType, false);
                    callTarget = graph.add(new MethodCallTargetNode(CallTargetNode.InvokeKind.Static, this.checkCounter.getMethod(), new ValueNode[]{errMsg}, returnStamp, null));
                    invoke = graph.add(new InvokeNode(callTarget, 0));
                    ResolvedJavaMethodBytecode code = new ResolvedJavaMethodBytecode(graph.method());
                    FrameState stateAfter = new FrameState(null, code, -3, ValueNode.EMPTY_ARRAY, ValueNode.EMPTY_ARRAY, 0, null, null, ValueNode.EMPTY_ARRAY, null, FrameState.StackState.BeforePop);
                    invoke.setStateAfter(graph.add(stateAfter));
                    graph.addBeforeFixed(ret, invoke);
                    SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.checkCounter, graph.getGuardsStage(), tool.getLoweringStage());
                    args.addConst("errMsg", new CStringConstant(msg));
                    inlineeGraph = this.template(tool, invoke, args).copySpecializedGraph(graph.getDebug());
                    InliningUtil.inline(invoke, inlineeGraph, false, null);
                }
            }
        }
    }
}

