/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.replacements;

import java.util.Arrays;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.nodes.type.KlassPointerStamp;
import jdk.graal.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import jdk.graal.compiler.hotspot.stubs.LookUpSecondarySupersTableStub;
import jdk.graal.compiler.hotspot.word.KlassPointer;
import jdk.graal.compiler.lir.SyncPort;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.TypeCheckHints;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.replacements.SnippetCounter;
import jdk.graal.compiler.serviceprovider.JavaVersionUtil;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectType;
import jdk.vm.ci.meta.MetaAccessProvider;

public class TypeCheckSnippetUtils {
    @Fold
    static boolean isJDK21() {
        return JavaVersionUtil.JAVA_SPEC == 21;
    }

    static boolean checkSecondarySubType(KlassPointer t, KlassPointer sNonNull, Counters counters) {
        if (TypeCheckSnippetUtils.isJDK21() && sNonNull.readKlassPointer(HotSpotReplacementsUtil.secondarySuperCacheOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), HotSpotReplacementsUtil.SECONDARY_SUPER_CACHE_LOCATION).equal(t)) {
            counters.cacheHit.inc();
            return true;
        }
        return TypeCheckSnippetUtils.checkSelfAndSupers(t, sNonNull, counters);
    }

    static boolean checkUnknownSubType(KlassPointer t, KlassPointer sNonNull, Counters counters) {
        boolean primary;
        int superCheckOffset = t.readInt(HotSpotReplacementsUtil.superCheckOffsetOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), HotSpotReplacementsUtil.KLASS_SUPER_CHECK_OFFSET_LOCATION);
        boolean bl = primary = superCheckOffset != HotSpotReplacementsUtil.secondarySuperCacheOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
        if (sNonNull.readKlassPointer(superCheckOffset, HotSpotReplacementsUtil.PRIMARY_SUPERS_LOCATION).equal(t)) {
            if (primary) {
                counters.cacheHit.inc();
            } else {
                counters.displayHit.inc();
            }
            return true;
        }
        if (primary) {
            counters.displayMiss.inc();
            return false;
        }
        return TypeCheckSnippetUtils.checkSelfAndSupers(t, sNonNull, counters);
    }

    @SyncPort(from="https://github.com/openjdk/jdk/blob/8032d640c0d34fe507392a1d4faa4ff2005c771d/src/hotspot/cpu/x86/macroAssembler_x86.cpp#L4786-L4881", sha1="c0e2fdd973dc975757d58080ba94efe628d6a380")
    static boolean checkSelfAndSupers(KlassPointer t, KlassPointer s, Counters counters) {
        if (s.equal(t)) {
            counters.equalsSecondary.inc();
            return true;
        }
        Word secondarySupers = s.readWord(HotSpotReplacementsUtil.secondarySupersOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), HotSpotReplacementsUtil.SECONDARY_SUPERS_LOCATION);
        if (TypeCheckSnippetUtils.isJDK21()) {
            int length = secondarySupers.readInt(HotSpotReplacementsUtil.metaspaceArrayLengthOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), HotSpotReplacementsUtil.METASPACE_ARRAY_LENGTH_LOCATION);
            for (int i = 0; i < length; ++i) {
                if (!BranchProbabilityNode.probability(0.4, t.equal(LookUpSecondarySupersTableStub.loadSecondarySupersElement(secondarySupers, i)))) continue;
                s.writeKlassPointer(HotSpotReplacementsUtil.secondarySuperCacheOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), t, HotSpotReplacementsUtil.SECONDARY_SUPER_CACHE_LOCATION);
                counters.secondariesHit.inc();
                return true;
            }
            counters.secondariesMiss.inc();
            return false;
        }
        byte bit = t.readByte(HotSpotReplacementsUtil.klassHashSlotOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), HotSpotReplacementsUtil.KLASS_HASH_SLOT_LOCATION);
        long bitmap = s.readLong(HotSpotReplacementsUtil.klassBitmapOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), HotSpotReplacementsUtil.KLASS_BITMAP_LOCATION);
        long bitmapShifted = bitmap << 63 - bit;
        if (BranchProbabilityNode.probability(0.4, bitmapShifted >= 0L)) {
            counters.bitmapMiss.inc();
            return false;
        }
        long index = (long)Long.bitCount(bitmapShifted) - 1L;
        KlassPointer hashed = LookUpSecondarySupersTableStub.loadSecondarySupersElement(secondarySupers, index);
        if (BranchProbabilityNode.probability(0.9, t.equal(hashed))) {
            counters.hashHit.inc();
            return true;
        }
        if (BranchProbabilityNode.probability(0.4, (bitmap & 1L << (bit + 1 & 0x3F)) == 0L)) {
            counters.bitmapMiss.inc();
            return false;
        }
        bitmap = Long.rotateRight(bitmap, bit);
        counters.hashMissStub.inc();
        return LookUpSecondarySupersTableStub.lookupSecondarySupersTableStub(t, secondarySupers, bitmap, index + 1L);
    }

    static Hints createHints(TypeCheckHints hints, MetaAccessProvider metaAccess, boolean positiveOnly, StructuredGraph graph) {
        ConstantNode[] hubs = new ConstantNode[hints.hints.length];
        boolean[] isPositive = new boolean[hints.hints.length];
        int index = 0;
        for (int i = 0; i < hubs.length; ++i) {
            if (positiveOnly && !hints.hints[i].positive) continue;
            hubs[index] = ConstantNode.forConstant(KlassPointerStamp.klassNonNull(), ((HotSpotResolvedObjectType)hints.hints[i].type).klass(), metaAccess, graph);
            isPositive[index] = hints.hints[i].positive;
            ++index;
        }
        if (positiveOnly && index != hubs.length) {
            assert (index < hubs.length) : Assertions.errorMessage(index, hubs);
            hubs = Arrays.copyOf(hubs, index);
            isPositive = Arrays.copyOf(isPositive, index);
        }
        return new Hints(hubs, isPositive);
    }

    static class Counters {
        final SnippetCounter hintsHit;
        final SnippetCounter hintsMiss;
        final SnippetCounter exactHit;
        final SnippetCounter exactMiss;
        final SnippetCounter isNull;
        final SnippetCounter cacheHit;
        final SnippetCounter secondariesHit;
        final SnippetCounter secondariesMiss;
        final SnippetCounter bitmapMiss;
        final SnippetCounter hashHit;
        final SnippetCounter hashMissStub;
        final SnippetCounter displayHit;
        final SnippetCounter displayMiss;
        final SnippetCounter equalsSecondary;

        Counters(SnippetCounter.Group.Factory factory) {
            SnippetCounter.Group group = factory.createSnippetCounterGroup("TypeCheck");
            this.hintsHit = new SnippetCounter(group, "hintsHit", "hit a hint type");
            this.hintsMiss = new SnippetCounter(group, "hintsMiss", "missed a hint type");
            this.exactHit = new SnippetCounter(group, "exactHit", "exact type test succeeded");
            this.exactMiss = new SnippetCounter(group, "exactMiss", "exact type test failed");
            this.isNull = new SnippetCounter(group, "isNull", "object tested was null");
            this.cacheHit = new SnippetCounter(group, "cacheHit", "secondary type cache hit");
            this.secondariesHit = new SnippetCounter(group, "secondariesHit", "secondaries scan succeeded");
            this.secondariesMiss = new SnippetCounter(group, "secondariesMiss", "secondaries scan failed");
            this.bitmapMiss = new SnippetCounter(group, "bitmapMiss", "secondary type not present in bitmap");
            this.hashHit = new SnippetCounter(group, "hashHit", "secondary type found in hashed table");
            this.hashMissStub = new SnippetCounter(group, "hashMissStub", "secondary type not found in first attempt, call into runtime");
            this.displayHit = new SnippetCounter(group, "displayHit", "primary type test succeeded");
            this.displayMiss = new SnippetCounter(group, "displayMiss", "primary type test failed");
            this.equalsSecondary = new SnippetCounter(group, "T_equals_S", "object type was equal to secondary type");
        }
    }

    public static class Hints {
        public final ConstantNode[] hubs;
        public final boolean[] isPositive;

        Hints(ConstantNode[] hints, boolean[] hintIsPositive) {
            this.hubs = hints;
            this.isPositive = hintIsPositive;
        }
    }
}

