/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.hotspot.replacements.arraycopy;

import jdk.graal.compiler.hotspot.GraalHotSpotVMConfig;
import jdk.graal.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import jdk.graal.compiler.hotspot.replacements.arraycopy.CheckcastArrayCopyCallNode;
import jdk.graal.compiler.hotspot.replacements.arraycopy.GenericArrayCopyCallNode;
import jdk.graal.compiler.hotspot.word.KlassPointer;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.SnippetAnchorNode;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.replacements.arraycopy.ArrayCopyCallNode;
import jdk.graal.compiler.replacements.arraycopy.ArrayCopySnippets;
import jdk.graal.compiler.word.Word;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.WordFactory;

public class HotSpotArraycopySnippets
extends ArrayCopySnippets {
    @Override
    public boolean hubsEqual(Object nonNullSrc, Object nonNullDest) {
        KlassPointer srcHub = HotSpotReplacementsUtil.loadHub(nonNullSrc);
        KlassPointer destHub = HotSpotReplacementsUtil.loadHub(nonNullDest);
        return srcHub.equal(destHub);
    }

    Word getSuperCheckOffset(KlassPointer destElemKlass) {
        return (Word)WordFactory.signed((int)destElemKlass.readInt(HotSpotReplacementsUtil.superCheckOffsetOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), HotSpotReplacementsUtil.KLASS_SUPER_CHECK_OFFSET_LOCATION));
    }

    @Override
    public boolean layoutHelpersEqual(Object nonNullSrc, Object nonNullDest) {
        KlassPointer srcHub = HotSpotReplacementsUtil.loadHub(nonNullSrc);
        KlassPointer destHub = HotSpotReplacementsUtil.loadHub(nonNullDest);
        return HotSpotReplacementsUtil.readLayoutHelper(srcHub) == HotSpotReplacementsUtil.readLayoutHelper(destHub);
    }

    KlassPointer getDestElemClass(KlassPointer destKlass) {
        return destKlass.readKlassPointer(HotSpotReplacementsUtil.arrayClassElementOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), HotSpotReplacementsUtil.OBJ_ARRAY_KLASS_ELEMENT_KLASS_LOCATION);
    }

    @Override
    protected int heapWordSize() {
        return HotSpotReplacementsUtil.getHeapWordSize(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
    }

    @Override
    protected void doCheckcastArraycopySnippet(Object src, int srcPos, Object dest, int destPos, int length, JavaKind elementKind, LocationIdentity arrayLocation, ArrayCopySnippets.Counters counters) {
        if (BranchProbabilityNode.probability(0.9, length > 0)) {
            KlassPointer destKlass;
            Object nonNullSrc = PiNode.piCastNonNull(src, SnippetAnchorNode.anchor());
            Object nonNullDest = PiNode.piCastNonNull(dest, SnippetAnchorNode.anchor());
            KlassPointer srcKlass = HotSpotReplacementsUtil.loadHub(nonNullSrc);
            if (BranchProbabilityNode.probability(0.6, srcKlass.equal(destKlass = HotSpotReplacementsUtil.loadHub(nonNullDest))) || BranchProbabilityNode.probability(0.6, nonNullDest.getClass() == Object[].class)) {
                counters.objectCheckcastSameTypeCounter.inc();
                counters.objectCheckcastSameTypeCopiedCounter.add(length);
                ArrayCopyCallNode.arraycopyObjectKillsAny(nonNullSrc, srcPos, nonNullDest, destPos, length, this.heapWordSize());
            } else {
                KlassPointer destElemKlass = this.getDestElemClass(destKlass);
                Word superCheckOffset = this.getSuperCheckOffset(destElemKlass);
                counters.objectCheckcastDifferentTypeCounter.inc();
                counters.objectCheckcastDifferentTypeCopiedCounter.add(length);
                int copiedElements = CheckcastArrayCopyCallNode.checkcastArraycopy(nonNullSrc, srcPos, nonNullDest, destPos, length, superCheckOffset, destElemKlass, false);
                if (BranchProbabilityNode.probability(0.010000000000000009, copiedElements != 0)) {
                    System.arraycopy(nonNullSrc, srcPos + (copiedElements ^= 0xFFFFFFFF), nonNullDest, destPos + copiedElements, length - copiedElements);
                }
            }
        }
    }

    @Override
    protected void doGenericArraycopySnippet(Object src, int srcPos, Object dest, int destPos, int length, JavaKind elementKind, LocationIdentity arrayLocation, ArrayCopySnippets.Counters counters) {
        counters.genericArraycopyDifferentTypeCounter.inc();
        counters.genericArraycopyDifferentTypeCopiedCounter.add(length);
        int copiedElements = GenericArrayCopyCallNode.genericArraycopy(src, srcPos, dest, destPos, length);
        if (BranchProbabilityNode.probability(0.010000000000000009, copiedElements != 0)) {
            System.arraycopy(src, srcPos + (copiedElements ^= 0xFFFFFFFF), dest, destPos + copiedElements, length - copiedElements);
        }
    }
}

